/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.customizer;

import datechooser.beans.customizer.PropertyPair;
import datechooser.beans.editor.BooleanEditorFoo;
import datechooser.beans.editor.StringEditor;
import datechooser.beans.locale.LocaleUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditorSupport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;

public class PropertyDescriptorsHolder
implements PropertyChangeListener {
    public static final String OK = "ok";
    private Map<String, PropertyEditorSupport> editorsCash = new HashMap<String, PropertyEditorSupport>();
    private Map<String, PropertyDescriptor> descriptorsCash = new HashMap<String, PropertyDescriptor>();
    private PropertyDescriptor[] descriptorsCashArray;
    private Map<Class, Class> additionalDescriptor;
    private BeanInfo info;
    private Object bean;
    private boolean beanAttached;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public PropertyDescriptorsHolder(BeanInfo beanInfo) throws IntrospectionException {
        this(beanInfo, null);
    }

    public PropertyDescriptorsHolder(BeanInfo beanInfo, Object bean) throws IntrospectionException {
        this.initializeAdditionalDescriptors();
        this.setBeanInfo(beanInfo);
        this.initialize(beanInfo);
        this.prepareForBean(bean);
        this.getBeanInfo().getPropertyDescriptors();
    }

    private void initializeAdditionalDescriptors() {
        this.additionalDescriptor = new HashMap<Class, Class>();
        this.additionalDescriptor.put(String.class, StringEditor.class);
        this.additionalDescriptor.put(Boolean.TYPE, BooleanEditorFoo.class);
        this.additionalDescriptor.put(Boolean.class, BooleanEditorFoo.class);
    }

    private Class getAdditionalDescriptorClass(Class key) {
        return this.additionalDescriptor.get(key);
    }

    private void initialize(BeanInfo beanInfo) {
        PropertyDescriptor[] descriptors;
        for (PropertyDescriptor elem : descriptors = this.getBeanInfo().getPropertyDescriptors()) {
            Class editorClass = elem.getPropertyEditorClass();
            if (editorClass == null) {
                editorClass = this.getAdditionalDescriptorClass(elem.getReadMethod().getReturnType());
            }
            if (editorClass == null) continue;
            this.createPropertyEditor(elem.getName(), editorClass);
            this.registerDescriptor(elem);
        }
        this.descriptorsCashArray = this.descriptorsCash.values().toArray(new PropertyDescriptor[this.descriptorsCash.size()]);
    }

    public static boolean isBooleanDescriptor(PropertyDescriptor propertyDescriptor) {
        Class<?> type = propertyDescriptor.getReadMethod().getReturnType();
        return type == Boolean.TYPE || type == Boolean.class;
    }

    public static boolean isStringDescriptor(PropertyDescriptor propertyDescriptor) {
        Class<?> type = propertyDescriptor.getReadMethod().getReturnType();
        return type == String.class;
    }

    public void prepareForBean(Object bean) {
        if (bean == null) {
            return;
        }
        this.setBeanAttached(false);
        this.testBean(bean);
        this.bean = bean;
        PropertyDescriptor[] descriptors = this.getPropertyDescriptors();
        PropertyEditorSupport editor = null;
        for (PropertyDescriptor elem : descriptors) {
            try {
                editor = this.getPropertyEditor(elem.getName());
                editor.setValue(elem.getReadMethod().invoke(bean, new Object[0]));
                editor.firePropertyChange();
            }
            catch (Exception ex) {
                this.showExeption(ex);
            }
        }
        this.setBeanAttached(true);
    }

    private void testBean(Object bean) {
        String mustHaveInfo = bean.getClass().getName() + "BeanInfo";
        if (!mustHaveInfo.equals(this.getBeanInfo().getClass().getName())) {
            throw new RuntimeException("Incorrect Bean class name (" + this.getBeanInfo().getClass().getName() + ')');
        }
    }

    public PropertyEditorSupport getPropertyEditor(String property) {
        return this.editorsCash.get(property);
    }

    public PropertyDescriptor getPropertydescriptor(String property) {
        return this.descriptorsCash.get(property);
    }

    private void registerDescriptor(PropertyDescriptor descr) {
        this.descriptorsCash.put(descr.getName(), descr);
    }

    private void createPropertyEditor(String property, Class editorClass) {
        if (this.editorsCash.containsKey(property)) {
            return;
        }
        try {
            PropertyEditorSupport newEditor = (PropertyEditorSupport)Class.forName(editorClass.getName()).newInstance();
            newEditor.addPropertyChangeListener(this);
            this.editorsCash.put(property, newEditor);
            return;
        }
        catch (Exception ex) {
            this.showExeption(ex);
            return;
        }
    }

    private Object getProperty(String name) {
        PropertyDescriptor descriptor = this.getPropertydescriptor(name);
        try {
            return descriptor.getReadMethod().invoke(this.bean, new Object[0]);
        }
        catch (Exception ex) {
            this.showExeption(ex);
            return null;
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.isBeanAttached()) {
            return;
        }
        PropertyDescriptor[] descriptors = this.getBeanInfo().getPropertyDescriptors();
        PropertyEditorSupport editor = null;
        for (PropertyDescriptor elem : descriptors) {
            if (elem.getWriteMethod() == null) continue;
            editor = this.getPropertyEditor(elem.getName());
            if (evt.getSource() != editor) continue;
            try {
                elem.getWriteMethod().invoke(this.bean, editor.getValue());
                this.firePropertyChange(elem.getName(), null, null);
            }
            catch (Exception ex) {
                this.setProperty(this.bean, elem.getName(), this.getProperty(elem.getName()));
                this.showExeption(ex);
            }
        }
    }

    private void showExeption(Exception ex) {
        Throwable cause = ex;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        JOptionPane.showMessageDialog(null, "<html>" + cause.getMessage() + "<br>(<i>" + cause.getClass().getName() + "</i>)", LocaleUtils.getErrorsLocaleString("Exception"), 0);
    }

    public int getPropertyCount() {
        return this.descriptorsCash.size();
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.descriptorsCashArray;
    }

    public boolean isBeanAttached() {
        return this.beanAttached;
    }

    private void setBeanAttached(boolean beanAttached) {
        this.beanAttached = beanAttached;
    }

    public BeanInfo getBeanInfo() {
        return this.info;
    }

    public void setBeanInfo(BeanInfo info) {
        this.info = info;
    }

    public String writeToFile(File file) {
        try {
            ObjectOutputStream dataOut = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            PropertyPair[] pairs = new PropertyPair[this.editorsCash.size()];
            int i = 0;
            for (String elem : this.editorsCash.keySet()) {
                pairs[i] = new PropertyPair(elem, this.editorsCash.get(elem).getValue());
                ++i;
            }
            dataOut.writeObject(pairs);
            dataOut.flush();
            dataOut.close();
            return OK;
        }
        catch (Exception ex) {
            return ex.getClass().getName() + " : " + ex.getMessage();
        }
    }

    private void setProperty(Object bean, String name, Object value) {
        this.getPropertyEditor(name).setValue(value);
    }

    public String readFromStream(InputStream from) {
        try {
            PropertyPair[] pairs;
            ObjectInputStream dataIn = new ObjectInputStream(new BufferedInputStream(from));
            for (PropertyPair pair : pairs = (PropertyPair[])dataIn.readObject()) {
                this.setProperty(this.bean, pair.propertyName, pair.propertyValue);
            }
            dataIn.close();
            return OK;
        }
        catch (Exception ex) {
            return ex.getClass().getName() + " : " + ex.getMessage();
        }
    }

    public String readFromFile(File file) {
        try {
            return this.readFromStream(new FileInputStream(file));
        }
        catch (FileNotFoundException ex) {
            return ex.getClass().getName() + " : " + ex.getMessage();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void firePropertyChange(String name, Object oldVal, Object newVal) {
        this.changeSupport.firePropertyChange(name, oldVal, newVal);
    }
}

