/*
 * Decompiled with CFR 0.152.
 */
package datechooser.model.multiple;

import datechooser.beans.locale.LocaleUtils;
import datechooser.model.AbstractDateChooseModel;
import datechooser.model.CellState;
import datechooser.model.DaysGrid;
import datechooser.model.exeptions.IncompatibleDataExeption;
import datechooser.model.multiple.MultyDateChoose;
import datechooser.model.multiple.MultyModelBehavior;
import datechooser.model.multiple.MultySelectModes;
import datechooser.model.multiple.Period;
import datechooser.model.multiple.PeriodSet;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultyDateChooseModel
extends AbstractDateChooseModel
implements MultyDateChoose {
    private PeriodSet selection;
    private PeriodSet defaultPeriods;
    private MultySelectModes mode;
    private Calendar previous;
    private MultyModelBehavior behavior;
    private boolean add;
    private boolean periodSelectionStarted;

    public MultyDateChooseModel(Calendar current) {
        super(current, DaysGrid.getRowsCount(), DaysGrid.getColsCount());
        this.setAdd(false);
        this.setBehavior(MultyModelBehavior.SELECT_ALL);
        this.setPeriodSelectionStarted(false);
        this.selection = new PeriodSet();
        this.defaultPeriods = new PeriodSet();
        this.defaultPeriods.add(super.getDefaultDate());
        this.selection.add(new Period(this.getCurrent()));
        this.previous = (Calendar)current.clone();
        this.mode = MultySelectModes.SINGLE;
    }

    @Override
    public boolean isSelected(Calendar aDate) {
        return this.selection.contains(aDate);
    }

    @Override
    public Calendar getSelectedDate() {
        if (this.isNothingSelected()) {
            return null;
        }
        return this.getCurrent();
    }

    @Override
    public void reset() {
        this.selection.clear();
    }

    @Override
    public Iterable<Calendar> getSelectedDates() {
        return this.selection.getDates();
    }

    @Override
    public Iterable<Period> getSelectedPeriods() {
        return this.selection.getPeriods();
    }

    @Override
    public PeriodSet getSelectedPeriodSet() {
        return this.selection;
    }

    public void setSelectedPeriods(Iterable<Period> newSelection) {
        this.reset();
        if (newSelection != null) {
            this.selection.set(newSelection);
            this.select(this.selection.getFirstDate());
        }
        this.firePropertyChange("selected", null, null);
    }

    public void setSelectedPeriods(PeriodSet newSelection) {
        this.reset();
        if (newSelection != null) {
            this.selection.set(newSelection);
            this.select(this.selection.getFirstDate());
        }
        this.firePropertyChange("selected", null, null);
    }

    public Period getSelectedPeriod() {
        return this.selection.getLastAddedPeriod();
    }

    private void addPeriod(Period aPeriod) {
        if (this.isPeriodForbidden(aPeriod)) {
            return;
        }
        this.selection.add(aPeriod);
    }

    @Override
    public void setMode(MultySelectModes mode, boolean add) {
        switch (this.getBehavior()) {
            case SELECT_SINGLE: {
                this.mode = MultySelectModes.SINGLE;
                this.setAdd(false);
                return;
            }
            case SELECT_PERIOD: {
                this.mode = mode;
                this.setAdd(false);
                return;
            }
            case SELECT_ALL: {
                this.mode = mode;
                this.setAdd(add);
            }
        }
    }

    public boolean isAdd() {
        return this.add;
    }

    @Override
    public void setAdd(boolean add) {
        this.add = add;
    }

    public boolean isPeriodSelectionStarted() {
        return this.periodSelectionStarted;
    }

    @Override
    public void setPeriodSelectionStarted(boolean periodSelectionStarted) {
        this.periodSelectionStarted = periodSelectionStarted;
    }

    @Override
    protected void applySelection() {
        if (this.isDateForbidden(this.getCurrent())) {
            return;
        }
        if (!this.isAdd() && !this.isPeriodSelectionStarted()) {
            this.reset();
        }
        switch (this.mode) {
            case SINGLE: {
                this.addPeriod(new Period(this.getCurrent()));
                break;
            }
            case PERIOD: {
                this.setPeriodSelectionStarted(true);
                this.addPeriod(new Period(this.previous, this.getCurrent()));
            }
        }
        this.previous.setTime(this.getCurrent().getTime());
        this.firePropertyChange("selected", null, null);
        this.fireSelectionChange();
        if (this.getBehavior().equals((Object)MultyModelBehavior.SELECT_SINGLE)) {
            this.commit();
        }
    }

    @Override
    public void setBehavior(MultyModelBehavior behavior) {
        this.behavior = behavior;
        if (behavior == MultyModelBehavior.SELECT_SINGLE && !this.getSelection().isSingleDate()) {
            this.selectOneDate(this.getSelection().getFirstDate());
            this.firePropertyChange("behavior", null, null);
        }
    }

    @Override
    public MultyModelBehavior getBehavior() {
        return this.behavior;
    }

    public PeriodSet getDefaultPeriodSet() {
        return this.defaultPeriods;
    }

    public void setDefaultPeriodSet(PeriodSet periodSet) throws IncompatibleDataExeption {
        if (this.isPeriodSetForbidden(periodSet)) {
            throw new IncompatibleDataExeption(LocaleUtils.getErrorsLocaleString("Periods_forbidden"));
        }
        this.defaultPeriods.set(periodSet);
        this.setSelectedPeriods(this.defaultPeriods);
        this.firePropertyChange("defaultDates", null, null);
    }

    protected boolean isPeriodSetForbidden(PeriodSet periods) {
        for (Period period : periods.getPeriods()) {
            if (!this.isPeriodForbidden(period)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Calendar getDefaultDate() {
        return this.defaultPeriods.getCount() > 0 ? this.defaultPeriods.getFirstDate() : null;
    }

    public Iterable<Period> getDefaultPeriods() {
        return this.defaultPeriods.getPeriods();
    }

    public void setDefaultPeriods(Iterable<Period> newPeriods) throws IncompatibleDataExeption {
        this.defaultPeriods.clear();
        if (newPeriods != null) {
            this.defaultPeriods.set(newPeriods);
            Calendar defDate = this.defaultPeriods.getFirstDate();
            if (defDate != null) {
                this.setDefaultDate(defDate);
                this.select(defDate);
            }
            if (this.getBehavior() == MultyModelBehavior.SELECT_SINGLE) {
                this.selectOneDate(defDate);
            } else {
                this.setSelectedPeriods(newPeriods);
            }
        }
        this.firePropertyChange("defaultDates", null, null);
    }

    private void selectOneDate(Calendar aDate) {
        this.reset();
        this.addPeriod(new Period(aDate));
        this.firePropertyChange("selected", null, null);
    }

    @Override
    public CellState getCellState(int row, int column) {
        CellState cellState = super.getCellState(row, column);
        if (cellState == CellState.NORMAL && this.defaultPeriods != null && this.defaultPeriods.contains(this.getCellDate(row, column))) {
            return CellState.NOW;
        }
        return cellState;
    }

    @Override
    protected void selectColumn(int column) {
    }

    public MultySelectModes getMode() {
        return this.mode;
    }

    protected PeriodSet getSelection() {
        return this.selection;
    }

    @Override
    public void applySelectNothing() {
        this.reset();
        this.firePropertyChange("selected", null, null);
        this.fireSelectionChange();
        this.commit();
    }

    @Override
    protected boolean isForbiddenDefault(PeriodSet forbiddenPeriods) {
        return this.getDefaultPeriodSet().intersects(forbiddenPeriods);
    }

    @Override
    public boolean isNothingSelected() {
        if (this.selection == null) {
            return true;
        }
        return this.selection.isEmpty();
    }

    @Override
    public void setNothingSelected(boolean nothingSelected) {
        if (!this.isNothingAllowed() && nothingSelected) {
            return;
        }
        if (nothingSelected) {
            this.reset();
        }
    }

    private boolean isTouchesSomeSelected(Period period) {
        return this.selection.near(period);
    }
}

