/*
 * Decompiled with CFR 0.152.
 */
package datechooser.view.appearance;

import datechooser.beans.pic.Pictures;
import datechooser.view.BackRenderer;
import datechooser.view.appearance.ViewAppearance;
import datechooser.view.appearance.custom.CustomCellAppearance;
import datechooser.view.appearance.swing.ButtonPainter;
import datechooser.view.appearance.swing.LabelPainter;
import datechooser.view.appearance.swing.SwingCellAppearance;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.BorderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppearancesList
implements PropertyChangeListener,
Cloneable,
Serializable {
    public static String DEFAULT = "Swing";
    public static String CUSTOM = "custom";
    private transient PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private HashMap<String, ViewAppearance> appearances;
    private ViewAppearance current = null;

    public AppearancesList() {
        this(true);
    }

    public AppearancesList(boolean autoInit) {
        this.appearances = new HashMap();
        this.registerHardCoded();
        this.setCurrent(DEFAULT);
        if (autoInit) {
            ViewAppearance customView = (ViewAppearance)this.getDefaultAppearance().clone();
            customView.setName(CUSTOM);
            customView.setEditable(true);
            this.registerAppearance(customView);
        }
    }

    private AppearancesList(HashMap<String, ViewAppearance> data, PropertyChangeSupport changer, ViewAppearance current) {
        this.movePropertyChangeListeners(changer, this.changeSupport);
        this.appearances = data;
        this.current = current;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.changeSupport = new PropertyChangeSupport(this);
    }

    private void registerHardCoded() {
        this.registerHardCodedAppearance(new ViewAppearance("Contrast", new CustomCellAppearance(new Color(0, 0, 0), new Color(255, 255, 255), BorderFactory.createLineBorder(new Color(0, 0, 0), 1), new Font("Serif", 1, 12), new Color(255, 255, 255), 1.0f), new CustomCellAppearance(new Color(0, 0, 0), new Color(255, 255, 255), BorderFactory.createLineBorder(new Color(255, 255, 255), 1), new Font("Serif", 1, 16), new Color(0, 255, 0), 1.0f), new CustomCellAppearance(new Color(0, 0, 0), new Color(255, 255, 255), BorderFactory.createLineBorder(new Color(0, 0, 0), 1), new Font("Serif", 1, 14), new Color(0, 255, 0), 1.0f), new CustomCellAppearance(new Color(0, 0, 0), new Color(250, 250, 250), BorderFactory.createLineBorder(new Color(0, 0, 0), 1), new Font("Serif", 2, 12), new Color(0, 0, 255), 1.0f), new CustomCellAppearance(new Color(0, 0, 0), new Color(255, 255, 255), BorderFactory.createLineBorder(new Color(0, 0, 0), 1), new Font("Serif", 1, 12), new Color(0, 0, 255), 1.0f), new CustomCellAppearance(new Color(0, 0, 0), new Color(180, 180, 180), BorderFactory.createLineBorder(new Color(0, 0, 0), 1), new Font("Serif", 0, 10), new Color(255, 0, 0), 1.0f), null, true));
        this.registerHardCodedAppearance(new ViewAppearance("Light", new CustomCellAppearance(new Color(255, 255, 255), new Color(0, 0, 0), null, new Font("Serif", 0, 12), new Color(0, 0, 153), 1.0f), new CustomCellAppearance(new Color(153, 153, 255), new Color(0, 0, 0), null, new Font("Serif", 0, 12), new Color(0, 0, 102), 1.0f), new CustomCellAppearance(new Color(204, 255, 204), new Color(51, 255, 51), null, new Font("Serif", 0, 12), new Color(0, 0, 153), 1.0f), new CustomCellAppearance(new Color(255, 255, 255), new Color(0, 0, 102), null, new Font("Serif", 2, 10), new Color(0, 0, 255), 1.0f), new CustomCellAppearance(new Color(255, 255, 255), new Color(0, 0, 0), null, new Font("Serif", 1, 12), new Color(0, 0, 255), 1.0f), new CustomCellAppearance(new Color(255, 255, 255), new Color(255, 0, 0), null, new Font("Serif", 0, 12), new Color(255, 0, 0), 1.0f), null, true));
        this.registerHardCodedAppearance(new ViewAppearance("Bordered", new CustomCellAppearance(new Color(204, 204, 204), new Color(0, 0, 249), BorderFactory.createEtchedBorder(1, null, null), new Font("Serif", 0, 12), new Color(0, 0, 0), 1.0f), new CustomCellAppearance(new Color(204, 204, 204), new Color(0, 0, 255), BorderFactory.createBevelBorder(1, null, null, new Color(0, 0, 0), null), new Font("Serif", 1, 12), new Color(0, 0, 102), 1.0f), new CustomCellAppearance(new Color(204, 204, 204), new Color(0, 51, 0), BorderFactory.createEtchedBorder(1, null, null), new Font("Serif", 0, 12), new Color(0, 102, 0), 1.0f), new CustomCellAppearance(new Color(204, 204, 204), new Color(102, 102, 102), BorderFactory.createEtchedBorder(1, null, null), new Font("Serif", 0, 10), new Color(0, 0, 255), 1.0f), new CustomCellAppearance(new Color(204, 204, 204), new Color(0, 0, 0), BorderFactory.createEtchedBorder(1, null, null), new Font("Serif", 1, 12), new Color(0, 0, 255), 1.0f), new CustomCellAppearance(new Color(204, 204, 204), new Color(153, 153, 153), BorderFactory.createEtchedBorder(1, null, null), new Font("Serif", 0, 12), new Color(255, 0, 0), 1.0f), null, true));
        this.registerHardCodedAppearance(new ViewAppearance("Grey", new CustomCellAppearance(new Color(120, 120, 120), new Color(255, 255, 255), BorderFactory.createLineBorder(new Color(0, 0, 0), 1), new Font("Serif", 0, 12), new Color(255, 255, 255), 1.0f), new CustomCellAppearance(new Color(100, 100, 100), new Color(255, 255, 255), BorderFactory.createLineBorder(new Color(0, 0, 0), 1), new Font("Serif", 0, 12), new Color(0, 255, 0), 1.0f), new CustomCellAppearance(new Color(120, 120, 120), new Color(0, 255, 0), BorderFactory.createLineBorder(new Color(0, 0, 0), 1), new Font("Serif", 0, 12), new Color(0, 255, 0), 1.0f), new CustomCellAppearance(new Color(160, 160, 160), new Color(250, 250, 250), BorderFactory.createLineBorder(new Color(0, 0, 0), 1), new Font("Serif", 0, 12), new Color(0, 0, 255), 1.0f), new CustomCellAppearance(new Color(100, 100, 100), new Color(255, 255, 255), BorderFactory.createLineBorder(new Color(0, 0, 0), 1), new Font("Serif", 0, 12), new Color(0, 0, 255), 1.0f), new CustomCellAppearance(new Color(120, 120, 120), new Color(180, 180, 180), BorderFactory.createLineBorder(new Color(0, 0, 0), 1), new Font("Serif", 0, 12), new Color(255, 0, 0), 1.0f), null, true));
        this.registerHardCodedAppearance(new ViewAppearance("Dali", new CustomCellAppearance(new Color(0, 0, 0), new Color(255, 255, 255), null, new Font("Serif", 0, 12), new Color(0, 0, 153), 0.4f), new CustomCellAppearance(new Color(153, 153, 255), new Color(255, 255, 0), null, new Font("Serif", 1, 14), new Color(0, 0, 102), 0.2f), new CustomCellAppearance(new Color(0, 0, 0), new Color(51, 255, 51), null, new Font("Serif", 0, 12), new Color(0, 0, 153), 0.5f), new CustomCellAppearance(new Color(204, 204, 204), new Color(0, 0, 102), null, new Font("Serif", 2, 10), new Color(0, 0, 255), 0.4f), new CustomCellAppearance(new Color(0, 0, 0), new Color(255, 255, 255), null, new Font("Serif", 1, 12), new Color(0, 0, 255), 0.4f), new CustomCellAppearance(new Color(255, 0, 0), new Color(255, 0, 0), null, new Font("Serif", 0, 12), new Color(255, 0, 0), 0.3f), new BackRenderer(1, Pictures.getResource("dali.gif")), true, true));
        this.registerHardCodedAppearance(new ViewAppearance(DEFAULT, new SwingCellAppearance(null, null, Color.BLUE, false, true, new ButtonPainter()), new SwingCellAppearance(null, null, Color.BLUE, true, true, new ButtonPainter()), new SwingCellAppearance(null, Color.BLUE, Color.BLUE, false, true, new ButtonPainter()), new SwingCellAppearance(null, Color.GRAY, Color.BLUE, false, true, new LabelPainter()), new SwingCellAppearance(null, null, Color.BLUE, false, true, new LabelPainter()), new SwingCellAppearance(null, null, Color.RED, false, false, new ButtonPainter()), null, false));
    }

    public AppearancesList(String current, ViewAppearance ... cellViews) {
        this(false);
        for (ViewAppearance view : cellViews) {
            this.registerAppearance(view);
        }
        this.setCurrent(current);
    }

    public int getRegisteredCount() {
        return this.appearances.size();
    }

    public boolean isRegistered(String name) {
        return this.appearances.containsKey(name);
    }

    public String[] getRegisteredNames() {
        String[] result = new String[this.appearances.size()];
        result[0] = this.getAppearance(CUSTOM).getName();
        result[1] = this.getAppearance(DEFAULT).getName();
        int index = 2;
        for (String key : this.getKeys()) {
            if (key.equals(DEFAULT) || key.equals(CUSTOM)) continue;
            result[index] = this.appearances.get(key).getName();
            ++index;
        }
        return result;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.changeSupport.firePropertyChange(evt);
    }

    public ViewAppearance getAppearance(String name) {
        return this.appearances.get(name);
    }

    public ViewAppearance getDefaultAppearance() {
        return this.appearances.get(DEFAULT);
    }

    public boolean setCurrent(String name) {
        if (this.isRegistered(name)) {
            this.current = this.appearances.get(name);
            return true;
        }
        this.current = this.getDefaultAppearance();
        return false;
    }

    public ViewAppearance getCurrent() {
        return this.current;
    }

    public void registerAppearance(ViewAppearance anAppearance) {
        this.appearances.put(anAppearance.getName(), anAppearance);
        anAppearance.addPropertyChangeListener(this);
        this.changeSupport.firePropertyChange("Appearance list", null, null);
    }

    public void registerHardCodedAppearance(ViewAppearance anAppearance) {
        anAppearance.setEditable(false);
        this.registerAppearance(anAppearance);
    }

    private void reRegisterAppearance(ViewAppearance anAppearance) {
        this.unRegisterAnyAppearance(anAppearance.getName());
        this.registerAppearance(anAppearance);
    }

    public boolean unRegisterAppearance(String aName) {
        if (aName.equals(DEFAULT) || aName.equals(CUSTOM)) {
            return false;
        }
        this.unRegisterAnyAppearance(aName);
        return true;
    }

    private void unRegisterAnyAppearance(String aName) {
        if (this.appearances.containsKey(aName)) {
            this.getAppearance(aName).removePropertyChangeListener(this);
            this.appearances.remove(aName);
            this.changeSupport.firePropertyChange("Appearance list", null, null);
        }
    }

    private void movePropertyChangeListeners(PropertyChangeSupport from, PropertyChangeSupport to) {
        PropertyChangeListener[] listeners;
        for (PropertyChangeListener theListener : listeners = from.getPropertyChangeListeners()) {
            to.addPropertyChangeListener(theListener);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public Object clone() {
        AppearancesList newInst = new AppearancesList(false);
        this.movePropertyChangeListeners(this.changeSupport, newInst.changeSupport);
        for (String key : this.appearances.keySet()) {
            ViewAppearance view = this.appearances.get(key);
            if (!view.isEditable()) continue;
            newInst.registerAppearance((ViewAppearance)view.clone());
        }
        newInst.setCurrent(this.getCurrent().getName());
        return newInst;
    }

    public AppearancesList notDeepClone() {
        return new AppearancesList(this.appearances, this.changeSupport, this.current);
    }

    public Iterable<String> getKeys() {
        return this.appearances.keySet();
    }
}

