/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.odfdom.converter.pdf.internal.stylable;

import com.lowagie.text.pdf.PdfPCell;
import fr.opensagres.odfdom.converter.pdf.internal.styles.StyleBorder;
import java.awt.Color;

public class StyleUtils {
    public static void applyStyles(StyleBorder border, PdfPCell cell) {
        if (border == null) {
            return;
        }
        switch (border.getBorderType()) {
            case ALL: {
                Float width;
                if (border.isNoBorder()) {
                    cell.disableBorderSide(1);
                    cell.disableBorderSide(2);
                    cell.disableBorderSide(8);
                    cell.disableBorderSide(4);
                    break;
                }
                cell.enableBorderSide(1);
                cell.enableBorderSide(2);
                cell.enableBorderSide(8);
                cell.enableBorderSide(4);
                Color color = border.getColor();
                if (color != null) {
                    cell.setBorderColor(color);
                }
                if ((width = border.getWidth()) == null) break;
                cell.setBorderWidth(width.floatValue());
                break;
            }
            case BOTTOM: {
                Float width;
                if (border.isNoBorder()) {
                    cell.disableBorderSide(2);
                    break;
                }
                cell.enableBorderSide(2);
                Color color = border.getColor();
                if (color != null) {
                    cell.setBorderColorBottom(color);
                }
                if ((width = border.getWidth()) == null) break;
                cell.setBorderWidthBottom(width.floatValue());
                break;
            }
            case LEFT: {
                Float width;
                if (border.isNoBorder()) {
                    cell.disableBorderSide(4);
                    break;
                }
                cell.enableBorderSide(4);
                Color color = border.getColor();
                if (color != null) {
                    cell.setBorderColorLeft(color);
                }
                if ((width = border.getWidth()) == null) break;
                cell.setBorderWidthLeft(width.floatValue());
                break;
            }
            case RIGHT: {
                Float width;
                if (border.isNoBorder()) {
                    cell.disableBorderSide(8);
                    break;
                }
                cell.enableBorderSide(8);
                Color color = border.getColor();
                if (color != null) {
                    cell.setBorderColorRight(color);
                }
                if ((width = border.getWidth()) == null) break;
                cell.setBorderWidthRight(width.floatValue());
                break;
            }
            case TOP: {
                Float width;
                if (border.isNoBorder()) {
                    cell.disableBorderSide(1);
                    break;
                }
                cell.enableBorderSide(1);
                Color color = border.getColor();
                if (color != null) {
                    cell.setBorderColorTop(color);
                }
                if ((width = border.getWidth()) == null) break;
                cell.setBorderWidthTop(width.floatValue());
            }
        }
    }
}

