/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.converter.docx.poi.itext;

import fr.opensagres.poi.xwpf.converter.core.openxmlformats.AbstractOpenXMLFormatsPartProvider;
import fr.opensagres.poi.xwpf.converter.core.openxmlformats.IOpenXMLFormatsPartProvider;
import fr.opensagres.poi.xwpf.converter.pdf.FastPdfConverter;
import fr.opensagres.poi.xwpf.converter.pdf.PdfOptions;
import fr.opensagres.xdocreport.converter.MimeMapping;
import fr.opensagres.xdocreport.converter.MimeMappingConstants;
import fr.opensagres.xdocreport.converter.Options;
import fr.opensagres.xdocreport.converter.OptionsHelper;
import fr.opensagres.xdocreport.converter.XDocConverterException;
import fr.opensagres.xdocreport.converter.internal.AbstractConverterEntriesSupport;
import fr.opensagres.xdocreport.core.io.IEntryInputStreamProvider;
import fr.opensagres.xdocreport.core.logging.LogUtils;
import fr.opensagres.xdocreport.core.utils.StringUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;

public class OpenXMLFormats2PDFViaITextConverter
extends AbstractConverterEntriesSupport {
    private static final OpenXMLFormats2PDFViaITextConverter INSTANCE = new OpenXMLFormats2PDFViaITextConverter();
    private static final Logger LOGGER = LogUtils.getLogger(OpenXMLFormats2PDFViaITextConverter.class.getName());

    public static OpenXMLFormats2PDFViaITextConverter getInstance() {
        return INSTANCE;
    }

    @Override
    public void convert(final IEntryInputStreamProvider inProvider, OutputStream out, Options options) throws XDocConverterException {
        try {
            AbstractOpenXMLFormatsPartProvider provider = new AbstractOpenXMLFormatsPartProvider(){

                @Override
                public InputStream getEntryInputStream(String entryName) {
                    return inProvider.getEntryInputStream(entryName);
                }
            };
            FastPdfConverter.getInstance().convert((IOpenXMLFormatsPartProvider)provider, out, this.toPdfOptions(options));
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new XDocConverterException(e);
        }
    }

    public PdfOptions toPdfOptions(Options options) {
        if (options == null) {
            return null;
        }
        Object value = options.getSubOptions(PdfOptions.class);
        if (value instanceof PdfOptions) {
            return (PdfOptions)value;
        }
        PdfOptions pdfOptions = PdfOptions.create();
        String fontEncoding = OptionsHelper.getFontEncoding(options);
        if (StringUtils.isNotEmpty(fontEncoding)) {
            pdfOptions.fontEncoding(fontEncoding);
        }
        return pdfOptions;
    }

    @Override
    public MimeMapping getMimeMapping() {
        return MimeMappingConstants.PDF_MIME_MAPPING;
    }
}

