/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.odt.images;

import fr.opensagres.xdocreport.core.io.IEntryOutputStreamProvider;
import fr.opensagres.xdocreport.core.io.IEntryReaderProvider;
import fr.opensagres.xdocreport.core.io.IEntryWriterProvider;
import fr.opensagres.xdocreport.document.images.AbstractImageRegistry;
import fr.opensagres.xdocreport.document.images.ImageProviderInfo;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import java.text.DecimalFormat;

public class ODTImageRegistry
extends AbstractImageRegistry {
    private DecimalFormat df = new DecimalFormat("#");
    private static final String POINT_UNIT = "pt";
    private static final String IMAGE_BASE_PATH = "Pictures/";

    public ODTImageRegistry(IEntryReaderProvider readerProvider, IEntryWriterProvider writerProvider, IEntryOutputStreamProvider outputStreamProvider, FieldsMetadata fieldsMetadata) {
        super(readerProvider, writerProvider, outputStreamProvider, fieldsMetadata);
    }

    @Override
    protected String getImageBasePath() {
        return IMAGE_BASE_PATH;
    }

    @Override
    protected String getPath(ImageProviderInfo info) {
        return info.getImageBasePath() + info.getImageFileName();
    }

    @Override
    public String getSize(float sizeAsPixel) {
        float sizeAsPoint = sizeAsPixel * 0.75f;
        String s = this.df.format(sizeAsPoint);
        return s + POINT_UNIT;
    }

    @Override
    public Float getSize(String sizeAsDxa) {
        if (sizeAsDxa == null) {
            return null;
        }
        try {
            float sizeAsPixel = Float.parseFloat(sizeAsDxa);
            return Float.valueOf(sizeAsPixel /= 0.75f);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

