/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.odt.textstyling;

import fr.opensagres.xdocreport.document.odt.textstyling.IODTStylesGenerator;
import fr.opensagres.xdocreport.document.odt.textstyling.ODTDefaultStyle;
import fr.opensagres.xdocreport.document.textstyling.properties.ContainerProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.TextAlignment;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ODTDefaultStylesGenerator
implements IODTStylesGenerator {
    protected static final String HEADER_PREFIX = "Heading_20_";
    protected static final Pattern HEADER_PATTERN = Pattern.compile("Heading_20_(\\d+).*");
    protected static final String[] BULLET_CHARS = new String[]{"\u2022", "\u25e6", "\u25aa"};
    protected static final String OL_STYLE_NAME = "XDocReport_OL";
    protected static final String UL_STYLE_NAME = "XDocReport_UL";
    protected static final String LIST_P_STYLE_NAME_SUFFIX = "_P";
    protected static final double BULLET_STEP = 0.635;
    protected static final String BOLD_STYLE_NAME = "XDocReport_Bold";
    protected static final String ITALIC_STYLE_NAME = "XDocReport_Italic";
    protected static final String UNDERLINE_STYLE_NAME = "XDocReport_Underline";
    protected static final String STRIKE_STYLE_NAME = "XDocReport_Strike";
    protected static final String SUBSCRIPT_STYLE_NAME = "XDocReport_Subscript";
    protected static final String SUPERSCRIPT_STYLE_NAME = "XDocReport_Superscript";
    protected static final String PAGE_BREAK_BEFORE_PARAGRAPH_STYLE_NAME = "XDocReport_ParaBreakBefore";
    protected static final String PAGE_BREAK_AFTER_PARAGRAPH_STYLE_NAME = "XDocReport_ParaBreakAfter";
    protected static final String EMPTY_TEXT_STYLE_NAME = "XDocReport_EmptyText";
    protected static String[] TITLE_FONT_SIZE = new String[]{"115%", "14pt", "14pt", "85%", "85%", "75%"};
    private long dynamicParagraphStylesNb = 0L;
    private long dynamicTextStylesNb = 0L;
    private final StringBuilder dynamicStyles = new StringBuilder();
    private String styleName = null;
    private ODTStyleProperties propertiesKind;
    private boolean hasPropertiesKind;

    protected String getBulletChar(int level) {
        return BULLET_CHARS[(level - 1) % 3];
    }

    @Override
    public String getHeaderStyleName(int level) {
        return HEADER_PREFIX + level;
    }

    @Override
    public String generateHeaderStyle(int level) {
        StringBuilder style = new StringBuilder("<style:style style:name=\"");
        style.append(this.getHeaderStyleName(level));
        style.append("\" style:display-name=\"");
        style.append("Heading " + level);
        style.append("\" style:family=\"paragraph\" style:parent-style-name=\"Heading\" style:next-style-name=\"Text_20_body\" ");
        style.append("style:default-outline-level=\"");
        style.append(level + "\" ");
        style.append("style:class=\"text\"><style:text-properties ");
        style.append("fo:font-size=\"");
        style.append(TITLE_FONT_SIZE[level - 1]);
        style.append("\" fo:font-weight=\"bold\" ");
        if (level % 2 == 0) {
            style.append(" fo:font-style=\"italic\" ");
        }
        style.append("/></style:style>");
        return style.toString();
    }

    @Override
    public String generateTextStyles() {
        StringBuilder region = new StringBuilder();
        region.append(this.generateStyle(EMPTY_TEXT_STYLE_NAME, ""));
        region.append(this.generateStyle(BOLD_STYLE_NAME, "fo:font-weight=\"bold\""));
        region.append(this.generateStyle(ITALIC_STYLE_NAME, "fo:font-style=\"italic\""));
        region.append(this.generateStyle(UNDERLINE_STYLE_NAME, "style:text-underline-style=\"solid\" style:text-underline-width=\"auto\" style:text-underline-color=\"font-color\""));
        region.append(this.generateStyle(STRIKE_STYLE_NAME, "style:text-line-through-style=\"solid\" style:text-underline-style=\"none\""));
        region.append(this.generateStyle(SUBSCRIPT_STYLE_NAME, "style:text-position=\"sub\""));
        region.append(this.generateStyle(SUPERSCRIPT_STYLE_NAME, "style:text-position=\"super\""));
        return region.toString();
    }

    @Override
    public String generateParagraphStyles() {
        StringBuilder region = new StringBuilder();
        region.append(this.generateStylePageBreak(true));
        region.append(this.generateStylePageBreak(false));
        return region.toString();
    }

    private String generateStyle(String styleName, String style) {
        StringBuilder region = new StringBuilder();
        region.append("<style:style style:name=\"");
        region.append(styleName);
        region.append("\" style:family=\"text\">");
        region.append("<style:text-properties ");
        region.append(style);
        region.append("/></style:style>");
        return region.toString();
    }

    @Override
    public String generateListStyle() {
        StringBuilder region = new StringBuilder();
        region.append(this.generateListStyle(true));
        region.append(this.generateListStyle(false));
        return region.toString();
    }

    protected String generateListStyle(boolean ordered) {
        StringBuilder region = new StringBuilder();
        String styleName = UL_STYLE_NAME;
        if (ordered) {
            styleName = OL_STYLE_NAME;
        }
        region.append("<style:style style:name=\"");
        region.append(styleName + LIST_P_STYLE_NAME_SUFFIX);
        region.append("\" style:family=\"paragraph\" style:parent-style-name=\"Standard\" style:list-style-name=\"");
        region.append(styleName);
        region.append("\"/>");
        region.append("<text:list-style style:name=\"");
        region.append(styleName);
        region.append("\">");
        for (int level = 1; level <= 10; ++level) {
            region.append(this.generateBulletStyle(level, ordered));
        }
        region.append("</text:list-style>");
        return region.toString();
    }

    protected String generateBulletStyle(Integer level, boolean ordered) {
        StringBuilder region = new StringBuilder();
        if (ordered) {
            region.append("<text:list-level-style-number text:level=\"");
        } else {
            region.append("<text:list-level-style-bullet text:level=\"");
        }
        region.append(level.toString());
        region.append("\" text:style-name=\"");
        if (ordered) {
            region.append("Numbering_20_Symbols");
        } else {
            region.append("Bullet_20_Symbols");
        }
        region.append("\" style:num-suffix=\".\" ");
        if (ordered) {
            region.append("style:num-format=\"1\">");
        } else {
            region.append("text:bullet-char=\"" + this.getBulletChar(level) + "\">");
        }
        region.append("<style:list-level-properties text:list-level-position-and-space-mode=\"label-alignment\">");
        region.append("<style:list-level-label-alignment text:label-followed-by=\"listtab\" ");
        DecimalFormatSymbols decimalFormat = new DecimalFormatSymbols();
        decimalFormat.setDecimalSeparator('.');
        String offset = new DecimalFormat("#.###", decimalFormat).format(0.635 * (double)(level + 1));
        region.append(" text:list-tab-stop-position=\"");
        region.append(offset);
        region.append("cm\" fo:text-indent=\"-0.635cm\" fo:margin-left=\"");
        region.append(offset);
        region.append("cm\"/>");
        region.append("</style:list-level-properties>");
        if (ordered) {
            region.append("</text:list-level-style-number>");
        } else {
            region.append("</text:list-level-style-bullet>");
        }
        return region.toString();
    }

    @Override
    public int getHeaderStylesCount() {
        return 6;
    }

    @Override
    public int getHeaderStyleNameLevel(String styleName) {
        if (styleName == null) {
            return -1;
        }
        Matcher matcher = HEADER_PATTERN.matcher(styleName);
        if (!matcher.find()) {
            return -1;
        }
        String headerIdx = matcher.group(1);
        return Integer.parseInt(headerIdx);
    }

    @Override
    public String getOLStyleName() {
        return OL_STYLE_NAME;
    }

    @Override
    public String getULStyleName() {
        return UL_STYLE_NAME;
    }

    @Override
    public String getListItemParagraphStyleNameSuffix() {
        return LIST_P_STYLE_NAME_SUFFIX;
    }

    @Override
    public String getBoldStyleName() {
        return BOLD_STYLE_NAME;
    }

    @Override
    public String getItalicStyleName() {
        return ITALIC_STYLE_NAME;
    }

    @Override
    public String getUnderlineStyleName() {
        return UNDERLINE_STYLE_NAME;
    }

    @Override
    public String getStrikeStyleName() {
        return STRIKE_STYLE_NAME;
    }

    @Override
    public String getSubscriptStyleName() {
        return SUBSCRIPT_STYLE_NAME;
    }

    @Override
    public String getSuperscriptStyleName() {
        return SUPERSCRIPT_STYLE_NAME;
    }

    @Override
    public String getParaBreakBeforeStyleName() {
        return PAGE_BREAK_BEFORE_PARAGRAPH_STYLE_NAME;
    }

    @Override
    public String getParaBreakAfterStyleName() {
        return PAGE_BREAK_AFTER_PARAGRAPH_STYLE_NAME;
    }

    private String generateStylePageBreak(boolean pageBreakBefore) {
        String styleName = pageBreakBefore ? PAGE_BREAK_BEFORE_PARAGRAPH_STYLE_NAME : PAGE_BREAK_AFTER_PARAGRAPH_STYLE_NAME;
        StringBuilder style = new StringBuilder();
        style.append("<style:style style:name=\"");
        style.append(styleName);
        style.append("\" style:family=\"paragraph\" >");
        style.append("<style:paragraph-properties");
        if (pageBreakBefore) {
            style.append(" fo:break-before=\"page\"");
        } else {
            style.append(" fo:break-after=\"page\"");
        }
        style.append(" />");
        style.append("</style:style>");
        return style.toString();
    }

    @Override
    public String generateAllStyles(ODTDefaultStyle defaultStyle) {
        StringBuilder styles = new StringBuilder();
        styles.append(this.generateTextStyles());
        styles.append(this.generateParagraphStyles());
        styles.append(this.generateListStyle());
        styles.append(this.getDynamicStyles());
        return styles.toString();
    }

    @Override
    public String getDynamicStyles() {
        return this.dynamicStyles.toString();
    }

    @Override
    public String getTextStyleName(ContainerProperties properties) {
        if (properties == null) {
            return EMPTY_TEXT_STYLE_NAME;
        }
        this.styleName = null;
        this.setPropertiesKind(ODTStyleProperties.TEXT);
        if (properties.isBold()) {
            this.startStyleIfNeeded(properties.getType(), properties.getStyleName());
            this.dynamicStyles.append("fo:font-weight=\"bold\" ");
        }
        if (properties.isItalic()) {
            this.startStyleIfNeeded(properties.getType(), properties.getStyleName());
            this.dynamicStyles.append("fo:font-style=\"italic\" ");
        }
        if (properties.isUnderline()) {
            this.startStyleIfNeeded(properties.getType(), properties.getStyleName());
            this.dynamicStyles.append("style:text-underline-style=\"solid\" style:text-underline-width=\"auto\" style:text-underline-color=\"font-color\" ");
            if (properties.isStrike()) {
                this.dynamicStyles.append("style:text-line-through-style=\"solid\" ");
            }
        } else if (properties.isStrike()) {
            this.startStyleIfNeeded(properties.getType(), properties.getStyleName());
            this.dynamicStyles.append("style:text-underline-style=\"none\" style:text-line-through-style=\"solid\" ");
        }
        if (properties.isSubscript()) {
            this.startStyleIfNeeded(properties.getType(), properties.getStyleName());
            this.dynamicStyles.append("style:text-position=\"sub\" ");
        }
        if (properties.isSuperscript()) {
            this.startStyleIfNeeded(properties.getType(), properties.getStyleName());
            this.dynamicStyles.append("style:text-position=\"super\" ");
        }
        this.setPropertiesKind(ODTStyleProperties.PARAGRAPH);
        TextAlignment textAlignment = properties.getTextAlignment();
        if (textAlignment != null) {
            switch (textAlignment) {
                case Center: {
                    this.startStyleIfNeeded(properties.getType(), properties.getStyleName());
                    this.dynamicStyles.append("fo:text-align=\"center\" style:justify-single-word=\"false\" ");
                    break;
                }
                case Justify: {
                    this.startStyleIfNeeded(properties.getType(), properties.getStyleName());
                    this.dynamicStyles.append("fo:text-align=\"justify\" ");
                    break;
                }
                case Left: {
                    this.startStyleIfNeeded(properties.getType(), properties.getStyleName());
                    this.dynamicStyles.append("fo:text-align=\"left\" ");
                    break;
                }
                case Right: {
                    this.startStyleIfNeeded(properties.getType(), properties.getStyleName());
                    this.dynamicStyles.append("fo:text-align=\"right\" ");
                }
            }
        }
        this.endStyleIfNeeded();
        if (this.styleName == null && properties.getStyleName() != null) {
            this.styleName = properties.getStyleName();
        }
        return this.styleName;
    }

    private void setPropertiesKind(ODTStyleProperties propertiesKind) {
        this.propertiesKind = propertiesKind;
        this.hasPropertiesKind = false;
    }

    private void startStyleIfNeeded(ContainerProperties.ContainerType type, String baseStyleName) {
        if (this.styleName == null) {
            this.styleName = ContainerProperties.ContainerType.PARAGRAPH.equals((Object)type) ? "XDocReport_P" + this.dynamicParagraphStylesNb++ : "XDocReport_T" + this.dynamicTextStylesNb++;
            this.dynamicStyles.append("<style:style style:name=\"");
            this.dynamicStyles.append(this.styleName);
            if (baseStyleName != null) {
                this.dynamicStyles.append("\" style:parent-style-name=\"");
                this.dynamicStyles.append(baseStyleName);
            }
            if (ContainerProperties.ContainerType.PARAGRAPH.equals((Object)type)) {
                this.dynamicStyles.append("\" style:family=\"paragraph\">");
            } else {
                this.dynamicStyles.append("\" style:family=\"text\">");
            }
        }
        if (!this.hasPropertiesKind) {
            switch (this.propertiesKind) {
                case TEXT: {
                    this.dynamicStyles.append("<style:text-properties ");
                    break;
                }
                case PARAGRAPH: {
                    this.dynamicStyles.append("/><style:paragraph-properties ");
                    break;
                }
            }
            this.hasPropertiesKind = true;
        }
    }

    private void endStyleIfNeeded() {
        if (this.styleName != null) {
            this.dynamicStyles.append("/></style:style>");
        }
    }

    private static enum ODTStyleProperties {
        TEXT,
        PARAGRAPH;

    }
}

