/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans;

import datechooser.beans.BeanUtils;
import datechooser.beans.DateChooserBean;
import datechooser.beans.DateChooserPanel;
import datechooser.beans.locale.LocaleUtils;
import datechooser.events.CommitEvent;
import datechooser.events.CommitListener;
import datechooser.events.CursorMoveListener;
import datechooser.events.SelectionChangedListener;
import datechooser.model.exeptions.IncompatibleDataExeption;
import datechooser.model.multiple.MultyModelBehavior;
import datechooser.model.multiple.Period;
import datechooser.model.multiple.PeriodSet;
import datechooser.view.WeekDaysStyle;
import datechooser.view.appearance.AppearancesList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateChooserDialog
implements DateChooserBean,
Serializable,
PropertyChangeListener {
    public static final long serialVersionUID = 8940585643117164408L;
    public static final String DIALOG_PREFIX = "dch_dialog_";
    public static final String PROPERTY_MODAL = "dch_dialog_modal";
    public static final String PROPERTY_CAPTION = "dch_dialog_caption";
    private DateChooserPanel chooser;
    private JPanel dialogPanel;
    private JDialog dialog = null;
    private Iterable<Period> state;
    private String caption;
    private boolean modal;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public DateChooserDialog() {
        this.setModal(true);
        this.chooser = new DateChooserPanel();
        this.chooser.addPropertyChangeListener(this);
        this.dialogPanel = this.getDialogPane();
        this.setCaption("");
        this.addCommitListener(new CommitListener(){

            public void onCommit(CommitEvent evt) {
                DateChooserDialog.this.disposeDialog();
            }
        });
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                SwingUtilities.updateComponentTreeUI(DateChooserDialog.this.dialogPanel);
            }
        });
    }

    public boolean isModal() {
        return this.modal;
    }

    public void setModal(boolean modal) {
        boolean old = this.isModal();
        this.modal = modal;
        this.changeSupport.firePropertyChange(PROPERTY_MODAL, old, this.isModal());
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        String old = this.getCaption();
        this.caption = caption;
        this.changeSupport.firePropertyChange(PROPERTY_CAPTION, old, this.getCaption());
    }

    public void showDialog(Frame owner) {
        this.showDialog(owner, this.isModal());
    }

    public void showDialog(Frame owner, boolean isModal) {
        Dimension ownerSize = null;
        ownerSize = owner != null ? owner.getSize() : Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dim = this.dialogPanel.getPreferredSize();
        Point location = new Point((ownerSize.width - dim.width) / 2, (ownerSize.height - dim.height) / 2);
        this.showDialog(owner, isModal, location);
    }

    public void showDialog(Frame owner, boolean isModal, Point location) {
        this.dialog = new JDialog(owner, isModal);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new OnClose());
        this.dialog.setContentPane(this.dialogPanel);
        this.dialog.setTitle(this.getCaption());
        this.saveState();
        Dimension dim = this.dialogPanel.getPreferredSize();
        this.dialog.setSize(dim.width, dim.height + 80);
        this.dialog.setLocation(location);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    @Override
    public MultyModelBehavior getBehavior() {
        return this.chooser.getBehavior();
    }

    @Override
    public AppearancesList getCurrentView() {
        return this.chooser.getCurrentView();
    }

    @Override
    public PeriodSet getDefaultPeriods() {
        return this.chooser.getDefaultPeriods();
    }

    @Override
    public PeriodSet getForbiddenPeriods() {
        return this.chooser.getForbiddenPeriods();
    }

    @Override
    public Calendar getMaxDate() {
        return this.chooser.getMaxDate();
    }

    @Override
    public Calendar getMinDate() {
        return this.chooser.getMinDate();
    }

    @Override
    public Calendar getSelectedDate() {
        return this.chooser.getSelectedDate();
    }

    @Override
    public PeriodSet getSelectedPeriodSet() {
        return this.chooser.getSelectedPeriodSet();
    }

    @Override
    public Iterable<Period> getSelection() {
        return this.chooser.getSelection();
    }

    @Override
    public boolean isAutoScroll() {
        return this.chooser.isAutoScroll();
    }

    @Override
    public boolean isEnabled() {
        return this.chooser.isEnabled();
    }

    @Override
    public boolean isShowOneMonth() {
        return this.chooser.isShowOneMonth();
    }

    @Override
    public void setAutoScroll(boolean autoScroll) {
        this.chooser.setAutoScroll(autoScroll);
    }

    @Override
    public void setBehavior(MultyModelBehavior behavior) {
        this.chooser.setBehavior(behavior);
    }

    @Override
    public void setCurrentView(AppearancesList aList) {
        this.chooser.setCurrentView(aList);
    }

    @Override
    public void setDefaultPeriods(PeriodSet periods) throws IncompatibleDataExeption {
        this.chooser.setDefaultPeriods(periods);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.chooser.setEnabled(enabled);
    }

    @Override
    public void setForbidden(Iterable<Period> forbiddenPeriods) {
        this.chooser.setForbidden(forbiddenPeriods);
    }

    @Override
    public void setForbiddenPeriods(PeriodSet periods) throws IncompatibleDataExeption {
        this.chooser.setForbiddenPeriods(periods);
    }

    @Override
    public void setMaxDate(Calendar aDate) {
        this.chooser.setMaxDate(aDate);
    }

    @Override
    public void setMinDate(Calendar aDate) {
        this.chooser.setMinDate(aDate);
    }

    @Override
    public void setSelectedDate(Calendar aDate) {
        this.chooser.setSelectedDate(aDate);
    }

    @Override
    public void setSelection(Iterable<Period> periods) {
        this.chooser.setSelection(periods);
    }

    @Override
    public void setSelection(PeriodSet periods) {
        this.chooser.setSelection(periods);
    }

    @Override
    public void setShowOneMonth(boolean showOneMonth) {
        this.chooser.setShowOneMonth(showOneMonth);
    }

    public Dimension getPreferredSize() {
        return this.chooser.getPreferredSize();
    }

    @Override
    public Font getNavigateFont() {
        return this.chooser.getNavigateFont();
    }

    @Override
    public void setNavigateFont(Font font) {
        this.chooser.setNavigateFont(font);
    }

    @Override
    public Locale getLocale() {
        return this.chooser.getLocale();
    }

    @Override
    public void setLocale(Locale locale) {
        this.chooser.setLocale(locale);
    }

    @Override
    public int getCurrentNavigateIndex() {
        return this.chooser.getCurrentNavigateIndex();
    }

    @Override
    public void setCurrentNavigateIndex(int currentNavigateIndex) {
        this.chooser.setCurrentNavigateIndex(currentNavigateIndex);
    }

    @Override
    public boolean isLocked() {
        return this.chooser.isLocked();
    }

    @Override
    public void setLocked(boolean lock) {
        this.chooser.setLocked(lock);
    }

    @Override
    public WeekDaysStyle getWeekStyle() {
        return this.chooser.getWeekStyle();
    }

    @Override
    public void setWeekStyle(WeekDaysStyle weekStyle) {
        this.chooser.setWeekStyle(weekStyle);
    }

    @Override
    public Calendar getCurrent() {
        return this.chooser.getCurrent();
    }

    @Override
    public boolean setCurrent(Calendar aDate) {
        return this.chooser.setCurrent(aDate);
    }

    @Override
    public void setNothingAllowed(boolean allow) {
        this.chooser.setNothingAllowed(allow);
    }

    @Override
    public boolean isNothingAllowed() {
        return this.chooser.isNothingAllowed();
    }

    @Override
    public Dimension getCalendarPreferredSize() {
        return this.chooser.getCalendarPreferredSize();
    }

    @Override
    public void setCalendarPreferredSize(Dimension dim) {
        this.chooser.setCalendarPreferredSize(dim);
    }

    @Override
    public void commit() {
        this.chooser.commit();
    }

    private JPanel getDialogPane() {
        JButton bOK = new JButton(LocaleUtils.getEditorLocaleString("OK"));
        JButton bCancel = new JButton(LocaleUtils.getEditorLocaleString("Cancel"));
        bOK.addActionListener(new OnOK());
        bCancel.addActionListener(new OnCancel());
        JPanel buttonPane = new JPanel(new GridLayout(1, 2));
        buttonPane.add(bOK);
        buttonPane.add(bCancel);
        JPanel dialogPane = new JPanel(new BorderLayout());
        dialogPane.add((Component)this.chooser, "Center");
        dialogPane.add((Component)buttonPane, "South");
        return dialogPane;
    }

    private void saveState() {
        this.state = this.chooser.getSelection();
    }

    private void restoreState() {
        this.chooser.setSelection(this.state);
    }

    private void disposeDialog() {
        if (this.dialog == null) {
            return;
        }
        this.dialog.setVisible(false);
        this.dialog.dispose();
        this.dialog = null;
    }

    private void commitAction() {
        this.commit();
        this.disposeDialog();
    }

    private void cancelAction() {
        this.restoreState();
        this.commit();
        this.disposeDialog();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.chooser.isDateChooserPanelProperty(evt.getPropertyName())) {
            this.changeSupport.firePropertyChange(evt);
        }
    }

    @Override
    public void addCommitListener(CommitListener listener) {
        this.chooser.addCommitListener(listener);
    }

    @Override
    public void removeCommitListener(CommitListener listener) {
        this.chooser.removeCommitListener(listener);
    }

    @Override
    public void addSelectionChangedListener(SelectionChangedListener listener) {
        this.chooser.addSelectionChangedListener(listener);
    }

    @Override
    public void removeSelectionChangedListener(SelectionChangedListener listener) {
        this.chooser.removeSelectionChangedListener(listener);
    }

    @Override
    public void addCursorMoveListener(CursorMoveListener listener) {
        this.chooser.addCursorMoveListener(listener);
    }

    @Override
    public void removeCursorMoveListener(CursorMoveListener listener) {
        this.chooser.removeCursorMoveListener(listener);
    }

    @Override
    public Color getCalendarBackground() {
        return this.chooser.getCalendarBackground();
    }

    @Override
    public void setCalendarBackground(Color backColor) {
        this.chooser.setCalendarBackground(backColor);
    }

    @Override
    public AppearancesList getAppearancesList() {
        return this.chooser.getAppearancesList();
    }

    @Override
    public DateChooserDialog clone() {
        return (DateChooserDialog)BeanUtils.cloneBean(this);
    }

    private class OnCancel
    implements ActionListener {
        private OnCancel() {
        }

        public void actionPerformed(ActionEvent e) {
            DateChooserDialog.this.cancelAction();
        }
    }

    private class OnOK
    implements ActionListener {
        private OnOK() {
        }

        public void actionPerformed(ActionEvent e) {
            DateChooserDialog.this.commitAction();
        }
    }

    private class OnClose
    implements WindowListener {
        private OnClose() {
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            DateChooserDialog.this.disposeDialog();
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }
    }
}

