/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.customizer.edit;

import datechooser.beans.customizer.PropertyDescriptorsHolder;
import datechooser.beans.customizer.edit.TextChangeListener;
import datechooser.beans.editor.utils.EditorDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditorSupport;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.table.TableCellEditor;

public class PropertyCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private PropertyDescriptorsHolder holder;
    private String property;
    private PropertyDescriptor descriptor;
    private PropertyEditorSupport editor;
    private boolean needsCustomEditor;
    private JTextField textEditor;
    private JCheckBox boolEditor;
    private JComboBox comboEditor;
    private EditorDialog customEditor;
    private JPanel editPanel;
    private JButton customEditorButton;
    private JComponent cellEditorCashed;
    private TagsModel tagsModel;

    public PropertyCellEditor(PropertyDescriptorsHolder holder) {
        this.holder = holder;
        this.tagsModel = new TagsModel();
        this.comboEditor = new JComboBox(this.tagsModel);
        this.boolEditor = new JCheckBox();
        this.boolEditor.addActionListener(new OnBoolChanged());
        this.textEditor = new JTextField();
        this.textEditor.setBorder(null);
        this.textEditor.getDocument().addDocumentListener(new OnTextChange());
        this.editPanel = new JPanel(new BorderLayout());
        this.customEditorButton = this.createCustomEditorButton();
        this.editPanel.add((Component)this.customEditorButton, "East");
        this.cellEditorCashed = null;
        UIManager.addPropertyChangeListener(new OnUIChange());
    }

    private JButton createCustomEditorButton() {
        JButton customEditorButton = new JButton("...");
        customEditorButton.setMargin(new Insets(2, 2, 2, 2));
        customEditorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertyCellEditor.this.setNeedsCustomEditor(false);
                PropertyCellEditor.this.customEditor = new EditorDialog(null, PropertyCellEditor.this.getEditor());
                Object newVal = PropertyCellEditor.this.customEditor.showDialog(PropertyCellEditor.this.getEditor().getValue(), PropertyCellEditor.this.getDescriptor().getDisplayName());
                if (!PropertyCellEditor.this.customEditor.isCanceled()) {
                    PropertyCellEditor.this.getEditor().setValue(newVal);
                    PropertyCellEditor.this.stopCellEditing();
                }
            }
        });
        return customEditorButton;
    }

    public Object getCellEditorValue() {
        return this.property;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        if (this.isNeedsCustomEditor()) {
            this.customEditor = new EditorDialog(null, this.getEditor());
            Object newVal = this.customEditor.showDialog(this.getEditor().getValue(), this.getDescriptor().getDisplayName());
            if (this.customEditor.isCanceled()) {
                this.cancelCellEditing();
            } else {
                this.getEditor().setValue(newVal);
                this.stopCellEditing();
            }
        }
        return true;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.property = (String)value;
        this.setDescriptor(this.holder.getPropertydescriptor(this.property));
        this.setEditor(this.holder.getPropertyEditor(this.property));
        this.setNeedsCustomEditor(false);
        JComponent cellEditor = null;
        if (this.getEditor().getTags() != null) {
            this.tagsModel.fireDataChanged();
            cellEditor = this.comboEditor;
        } else if (PropertyDescriptorsHolder.isBooleanDescriptor(this.getDescriptor())) {
            this.boolEditor.setSelected((Boolean)this.getEditor().getValue());
            cellEditor = this.boolEditor;
        } else if (PropertyDescriptorsHolder.isStringDescriptor(this.getDescriptor())) {
            this.textEditor.setText((String)this.getEditor().getValue());
            cellEditor = this.textEditor;
        } else if (this.getEditor().getCustomEditor() != null) {
            this.setNeedsCustomEditor(true);
            return table.getCellRenderer(row, column).getTableCellRendererComponent(table, value, isSelected, true, row, column);
        }
        if (this.getEditor().getCustomEditor() != null && cellEditor != null) {
            if (this.cellEditorCashed != null) {
                this.editPanel.remove(this.cellEditorCashed);
            }
            this.editPanel.add((Component)cellEditor, "Center");
            this.cellEditorCashed = cellEditor;
            this.editPanel.revalidate();
            return this.editPanel;
        }
        return cellEditor;
    }

    public PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(PropertyDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public PropertyEditorSupport getEditor() {
        return this.editor;
    }

    public void setEditor(PropertyEditorSupport editor) {
        this.editor = editor;
    }

    public boolean isNeedsCustomEditor() {
        return this.needsCustomEditor;
    }

    public void setNeedsCustomEditor(boolean needsCustomEditor) {
        this.needsCustomEditor = needsCustomEditor;
    }

    private class OnUIChange
    implements PropertyChangeListener {
        private OnUIChange() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            PropertyCellEditor.this.textEditor.updateUI();
            PropertyCellEditor.this.boolEditor.updateUI();
            PropertyCellEditor.this.comboEditor.updateUI();
            SwingUtilities.updateComponentTreeUI(PropertyCellEditor.this.editPanel);
        }
    }

    private class TagsModel
    extends AbstractListModel
    implements ComboBoxModel {
        private TagsModel() {
        }

        public int getSize() {
            if (PropertyCellEditor.this.getEditor() == null || PropertyCellEditor.this.getEditor().getTags() == null) {
                return 0;
            }
            return PropertyCellEditor.this.getEditor().getTags().length;
        }

        public Object getElementAt(int index) {
            return PropertyCellEditor.this.getEditor().getTags()[index];
        }

        public void setSelectedItem(Object anItem) {
            PropertyCellEditor.this.getEditor().setAsText((String)anItem);
        }

        public Object getSelectedItem() {
            if (PropertyCellEditor.this.getEditor() == null) {
                return null;
            }
            return PropertyCellEditor.this.getEditor().getAsText();
        }

        public void fireDataChanged() {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }

    private class OnTextChange
    extends TextChangeListener {
        private OnTextChange() {
        }

        public void textChanged(DocumentEvent e) {
            if (PropertyCellEditor.this.getEditor() == null) {
                return;
            }
            PropertyCellEditor.this.getEditor().setValue(PropertyCellEditor.this.textEditor.getText());
        }
    }

    private class OnBoolChanged
    implements ActionListener {
        private OnBoolChanged() {
        }

        public void actionPerformed(ActionEvent e) {
            if (PropertyCellEditor.this.getEditor() == null) {
                return;
            }
            PropertyCellEditor.this.getEditor().setValue(PropertyCellEditor.this.boolEditor.isSelected());
        }
    }
}

