/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.dates;

import datechooser.beans.DateChooserPanel;
import datechooser.model.multiple.MultyModelBehavior;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.Calendar;
import javax.swing.JPanel;

class DateEditorPane
extends JPanel {
    private PropertyEditorSupport editor;
    private DateChooserPanel chooser;
    private boolean innerEdit;

    public DateEditorPane(PropertyEditorSupport editor) {
        this.setEditor(editor);
        this.chooser = new DateChooserPanel();
        this.chooser.setBehavior(MultyModelBehavior.SELECT_SINGLE);
        this.initEditor();
        this.setLayout(new BorderLayout());
        this.add((Component)this.chooser, "Center");
        this.chooser.getModel().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                DateEditorPane.this.innerSetValue(DateEditorPane.this.chooser.getSelectedDate());
            }
        });
        this.getEditor().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                DateEditorPane.this.initEditor();
            }
        });
    }

    private void initEditor() {
        if (!this.isInnerEdit()) {
            this.innerSetValue(this.getEditorValue());
            this.setInnerEdit(true);
            this.chooser.setSelectedDate(this.getEditorValue());
            this.setInnerEdit(false);
        }
    }

    private void innerSetValue(Calendar value) {
        if (this.isInnerEdit()) {
            return;
        }
        this.setInnerEdit(true);
        Calendar date = value != null ? (Calendar)value.clone() : null;
        this.getEditor().setValue(date);
        this.setInnerEdit(false);
    }

    private Calendar getEditorValue() {
        return (Calendar)this.editor.getValue();
    }

    public PropertyEditorSupport getEditor() {
        return this.editor;
    }

    public void setEditor(PropertyEditorSupport editor) {
        this.editor = editor;
    }

    public boolean isInnerEdit() {
        return this.innerEdit;
    }

    public void setInnerEdit(boolean innerEdit) {
        this.innerEdit = innerEdit;
    }
}

