/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.core.styles.paragraph;

import fr.opensagres.poi.xwpf.converter.core.styles.XWPFStylesDocument;
import fr.opensagres.poi.xwpf.converter.core.styles.paragraph.AbstractSpacingParagraphValueProvider;
import fr.opensagres.poi.xwpf.converter.core.utils.DxaUtil;
import java.math.BigInteger;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSpacing;

public class ParagraphSpacingAfterValueProvider
extends AbstractSpacingParagraphValueProvider<Float> {
    public static ParagraphSpacingAfterValueProvider INSTANCE = new ParagraphSpacingAfterValueProvider();

    @Override
    protected Float getDefaultValue(XWPFParagraph paragraph, XWPFStylesDocument stylesDocument) {
        if (paragraph.getPartType() == BodyType.TABLECELL) {
            return null;
        }
        return (Float)super.getDefaultValue(paragraph, stylesDocument);
    }

    @Override
    protected Float getValue(CTSpacing spacing) {
        BigInteger after = spacing.getAfter();
        if (after != null) {
            return Float.valueOf(DxaUtil.dxa2points(after));
        }
        return null;
    }

    @Override
    protected Float getStaticValue(XWPFParagraph paragraph, XWPFStylesDocument stylesDocument) {
        if (stylesDocument.getDocDefaults() == null) {
            return Float.valueOf(10.0f);
        }
        return null;
    }
}

