/*
 * Decompiled with CFR 0.152.
 */
package org.quinto.swing.table.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.quinto.swing.table.model.IModelFieldGroup;
import org.quinto.swing.table.model.ModelField;
import org.quinto.swing.table.model.ModelFieldGroup;
import org.quinto.swing.table.model.ModelRow;
import org.quinto.swing.table.model.Utils;

public class ModelData
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int[] NO_FIELD_COORDINATES = new int[]{-1, -1};
    private ModelRow[] rows;
    private ModelField[] fields;
    private transient Map<String, Integer> fieldsIndex = new HashMap<String, Integer>();
    private transient Map<String, int[]> fieldGroupsIndex = new HashMap<String, int[]>();
    private transient List<IModelFieldGroup[]> fieldGroups = new ArrayList<IModelFieldGroup[]>();

    public ModelData() {
        this((ModelField[])null);
    }

    public ModelData(ModelField[] fields) {
        this.setFields(fields);
    }

    public ModelData(IModelFieldGroup[] fieldGroups) {
        this(ModelFieldGroup.getBottomFields(fieldGroups));
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.indexateFields();
    }

    public void setFields(ModelField[] fields) {
        if (ModelField.equals(this.fields, fields)) {
            this.fields = fields;
        } else {
            if (this.fields != null) {
                this.rows = null;
            }
            this.fields = fields;
            this.indexateFields();
        }
    }

    public ModelField[] getFields() {
        return this.fields;
    }

    public int getFieldsCount() {
        return this.getFieldsCount(false);
    }

    public int getFieldsCount(boolean visibleOnly) {
        if (this.fields == null) {
            return 0;
        }
        return visibleOnly ? ModelField.getVisibleFieldsCount(this.fields) : this.fields.length;
    }

    public List<IModelFieldGroup[]> getFieldGroups() {
        return this.fieldGroups;
    }

    public void setRows(ModelRow[] rows) {
        this.rows = rows;
    }

    public ModelRow[] getRows() {
        return this.rows;
    }

    public int getRowsCount() {
        return this.rows == null ? 0 : this.rows.length;
    }

    public int getIndexOfModelField(String identifier) {
        Integer ret = this.fieldsIndex.get(identifier);
        return ret == null ? -1 : ret;
    }

    public int[] getIndexOfModelFieldGroup(String identifier) {
        int[] ret = this.fieldGroupsIndex.get(identifier);
        return ret == null ? NO_FIELD_COORDINATES : ret;
    }

    public Object getValue(int row, String fieldName) {
        if (row < 0 || row >= this.getRowsCount()) {
            return null;
        }
        int fIdx = this.getIndexOfModelField(fieldName);
        if (fIdx == -1) {
            return null;
        }
        return this.rows[row] == null ? null : this.rows[row].getValue(fIdx);
    }

    public Object getValue(int row, int field) {
        if (row < 0 || row >= this.getRowsCount()) {
            return null;
        }
        if (field < 0 || field >= this.getFieldsCount()) {
            return null;
        }
        return this.rows[row] == null ? null : this.rows[row].getValue(field);
    }

    public void setValue(int row, String fieldName, Object value) {
        if (row < 0 || row >= this.getRowsCount()) {
            return;
        }
        int fIdx = this.getIndexOfModelField(fieldName);
        if (fIdx == -1) {
            return;
        }
        this.rows[row].getValues()[fIdx] = value;
    }

    public void setValue(int row, int field, Object value) {
        if (row < 0 || row >= this.getRowsCount()) {
            return;
        }
        if (field < 0 || field >= this.getFieldsCount()) {
            return;
        }
        this.rows[row].getValues()[field] = value;
    }

    private void indexateFields() {
        if (this.fields == null) {
            this.fields = new ModelField[0];
        }
        HashMap<String, Integer> newFieldsIndex = new HashMap<String, Integer>(this.fields.length);
        for (int i = 0; i < this.fields.length; ++i) {
            if (newFieldsIndex.put(this.fields[i].getIdentifier(), i) == null) continue;
            throw new IllegalArgumentException("Duplicated identifier: " + this.fields[i].getIdentifier());
        }
        this.fieldsIndex = newFieldsIndex;
        this.fieldGroupsIndex = new HashMap<String, int[]>();
        IModelFieldGroup[] upper = ModelFieldGroup.getUpperFieldGroups(this.fields);
        Object[] bottom = ModelFieldGroup.getBottomFields(upper);
        if (!Arrays.equals(bottom, this.fields)) {
            throw new IllegalArgumentException("Field groups contain more children than specified in fields array.\nActual: " + Arrays.toString(this.fields) + "\nExpected: " + Arrays.toString(bottom));
        }
        this.calculateRowspan(this.fields);
        for (IModelFieldGroup group : upper) {
            group.setRowspan(0);
        }
        this.calculateRowspanForUpper(upper);
        this.fieldGroups = new ArrayList<IModelFieldGroup[]>();
        this.addFieldGroupsRecursively(upper, 0, new HashMap<String, Integer>());
    }

    private void calculateRowspan(IModelFieldGroup[] fieldGroups) {
        ArrayList<ModelFieldGroup> parents = new ArrayList<ModelFieldGroup>();
        block0: for (IModelFieldGroup fieldGroup : fieldGroups) {
            int rowspan;
            ModelFieldGroup parent = fieldGroup.getParent();
            if (parent == null || parent.getChildrenRowspan() != -1) continue;
            int childrenRowspan = 0;
            for (IModelFieldGroup child : parent.getChildren()) {
                rowspan = child.getRowspan();
                if (rowspan < 1) {
                    rowspan = 1;
                }
                if (child instanceof ModelFieldGroup) {
                    int childChildrenRowspan = ((ModelFieldGroup)child).getChildrenRowspan();
                    if (childChildrenRowspan < 0) continue block0;
                    rowspan += childChildrenRowspan;
                }
                if (rowspan <= childrenRowspan) continue;
                childrenRowspan = rowspan;
            }
            parent.setChildrenRowspan(childrenRowspan);
            for (IModelFieldGroup child : parent.getChildren()) {
                rowspan = childrenRowspan;
                if (child instanceof ModelFieldGroup) {
                    rowspan -= ((ModelFieldGroup)child).getChildrenRowspan();
                }
                child.setRowspan(rowspan);
            }
            parents.add(parent);
        }
        if (!parents.isEmpty()) {
            this.calculateRowspan(parents.toArray(new IModelFieldGroup[parents.size()]));
        }
    }

    private void calculateRowspanForUpper(IModelFieldGroup[] upper) {
        int rowspan;
        int childrenRowspan = 0;
        for (IModelFieldGroup fieldGroup : upper) {
            rowspan = fieldGroup.getRowspan();
            if (rowspan < 1) {
                rowspan = 1;
            }
            if (fieldGroup instanceof ModelFieldGroup) {
                rowspan += ((ModelFieldGroup)fieldGroup).getChildrenRowspan();
            }
            if (rowspan <= childrenRowspan) continue;
            childrenRowspan = rowspan;
        }
        for (IModelFieldGroup fieldGroup : upper) {
            rowspan = childrenRowspan;
            if (fieldGroup instanceof ModelFieldGroup) {
                rowspan -= ((ModelFieldGroup)fieldGroup).getChildrenRowspan();
            }
            fieldGroup.setRowspan(rowspan);
        }
    }

    private void addFieldGroupsRecursively(IModelFieldGroup[] upper, int level, Map<String, Integer> fieldPosIndex) {
        this.fieldGroups.add(upper);
        int x = 0;
        int posX = 0;
        ArrayList<IModelFieldGroup> current = new ArrayList<IModelFieldGroup>();
        for (IModelFieldGroup fieldGroup : upper) {
            boolean groupFinished;
            int rowspan = fieldGroup.getRowspan();
            String identifier = fieldGroup.getIdentifier();
            int[] prev = this.fieldGroupsIndex.get(identifier);
            boolean bl = groupFinished = rowspan == 1;
            if (prev == null) {
                this.fieldGroupsIndex.put(identifier, new int[]{x, level});
                fieldPosIndex.put(identifier, posX);
            } else {
                int prevX = fieldPosIndex.get(identifier);
                if (prevX != posX) {
                    throw new IllegalArgumentException("Field group should be unbroken: " + fieldGroup);
                }
                if (!groupFinished) {
                    boolean bl2 = groupFinished = rowspan == 1 + level - prev[1];
                }
            }
            if (groupFinished) {
                if (fieldGroup instanceof ModelFieldGroup) {
                    ModelFieldGroup group = (ModelFieldGroup)fieldGroup;
                    current.addAll(group.getChildren());
                }
            } else {
                current.add(fieldGroup);
            }
            ++x;
            posX += fieldGroup.getColspan();
        }
        if (!current.isEmpty()) {
            this.addFieldGroupsRecursively(current.toArray(new IModelFieldGroup[current.size()]), level + 1, fieldPosIndex);
        }
    }

    public String getHeaderString() {
        int maxIdentifierLength = 0;
        for (String identifier : this.fieldGroupsIndex.keySet()) {
            if (identifier.length() <= maxIdentifierLength) continue;
            maxIdentifierLength = identifier.length();
        }
        if (maxIdentifierLength == 0) {
            maxIdentifierLength = 1;
        }
        ++maxIdentifierLength;
        int maxX = this.fields.length;
        StringBuilder sb = new StringBuilder();
        for (IModelFieldGroup[] groups : this.fieldGroups) {
            if (sb.length() > 0) {
                sb.append('\n');
            } else {
                sb.append(Utils.rpad("", '+', maxX * (maxIdentifierLength + 3))).append('\n');
            }
            for (IModelFieldGroup group : groups) {
                sb.append("+ ").append(Utils.rpad(group.getIdentifier(), (maxIdentifierLength + 3) * group.getColspan() - 3)).append('+');
            }
            sb.append('\n').append(Utils.rpad("", '+', maxX * (maxIdentifierLength + 3)));
        }
        return sb.toString();
    }

    public Iterable<IModelFieldGroup> getAllFieldGroupsFromBottom(final boolean depthFirst) {
        return new Iterable<IModelFieldGroup>(){
            private final Deque<IModelFieldGroup> list;
            private final Set<String> visited;
            {
                this.list = new ArrayDeque<ModelField>(Arrays.asList(ModelData.this.fields));
                this.visited = new HashSet<String>();
            }

            @Override
            public Iterator<IModelFieldGroup> iterator() {
                return new Iterator<IModelFieldGroup>(){

                    @Override
                    public boolean hasNext() {
                        return !list.isEmpty();
                    }

                    @Override
                    public IModelFieldGroup next() {
                        IModelFieldGroup ret = (IModelFieldGroup)list.pollFirst();
                        ModelFieldGroup parent = ret.getParent();
                        if (parent != null && visited.add(parent.getIdentifier())) {
                            if (depthFirst) {
                                list.addFirst(parent);
                            } else {
                                list.addLast(parent);
                            }
                        }
                        return ret;
                    }
                };
            }
        };
    }

    public Iterable<IModelFieldGroup> getAllFieldGroupsFromTop(final boolean depthFirst) {
        return new Iterable<IModelFieldGroup>(){
            private final Deque<IModelFieldGroup> list;
            {
                this.list = new ArrayDeque<IModelFieldGroup>(ModelData.this.fieldGroups.isEmpty() ? Collections.EMPTY_LIST : Arrays.asList((Object[])ModelData.this.fieldGroups.get(0)));
            }

            @Override
            public Iterator<IModelFieldGroup> iterator() {
                return new Iterator<IModelFieldGroup>(){

                    @Override
                    public boolean hasNext() {
                        return !list.isEmpty();
                    }

                    @Override
                    public IModelFieldGroup next() {
                        IModelFieldGroup ret;
                        block4: {
                            ret = (IModelFieldGroup)list.pollFirst();
                            if (!(ret instanceof ModelFieldGroup)) break block4;
                            if (depthFirst) {
                                List<IModelFieldGroup> children = ((ModelFieldGroup)ret).getChildren();
                                for (int i = children.size() - 1; i >= 0; --i) {
                                    list.addFirst(children.get(i));
                                }
                            } else {
                                for (IModelFieldGroup child : ((ModelFieldGroup)ret).getChildren()) {
                                    list.addLast(child);
                                }
                            }
                        }
                        return ret;
                    }
                };
            }
        };
    }

    public ModelData withField(String addTo, IModelFieldGroup field) throws IllegalArgumentException, ClassCastException {
        IModelFieldGroup[] newFields;
        IModelFieldGroup[] newGroups;
        int[] idx;
        if (field == null) {
            throw new IllegalArgumentException("Field cannot be null");
        }
        int[] nArray = idx = addTo == null ? null : this.getIndexOfModelFieldGroup(addTo);
        if (idx != null && idx[0] == -1) {
            throw new IllegalArgumentException("Parent group \"" + addTo + "\" not found");
        }
        if (idx == null) {
            IModelFieldGroup[] groups = ModelFieldGroup.getUpperFieldGroups(this.getFields());
            newGroups = new IModelFieldGroup[groups.length + 1];
            System.arraycopy(groups, 0, newGroups, 0, groups.length);
            newGroups[groups.length] = field;
        } else {
            newFields = ModelField.copyOfModelFields(this.getFields());
            ModelData idxData = new ModelData((ModelField[])newFields);
            ModelFieldGroup group = (ModelFieldGroup)idxData.getFieldGroups().get(idx[1])[idx[0]];
            group.withChild(field);
            newGroups = ModelFieldGroup.getUpperFieldGroups(newFields);
        }
        newFields = ModelFieldGroup.getBottomFields(newGroups);
        ModelData newData = new ModelData((ModelField[])newFields);
        if (this.rows != null) {
            newFields = ModelFieldGroup.getBottomFields(new IModelFieldGroup[]{field});
            if (newFields.length == 0) {
                throw new IllegalArgumentException("No columns found in column group \"" + field.getIdentifier() + '\"');
            }
            int colFromIncl = newData.getIndexOfModelField(((ModelField)newFields[0]).getIdentifier());
            int colToExcl = colFromIncl + field.getColspan();
            int newLength = newData.getFieldsCount();
            ModelRow[] newRows = new ModelRow[this.rows.length];
            for (int i = 0; i < this.rows.length; ++i) {
                ModelRow newRow;
                newRows[i] = newRow = new ModelRow(newLength);
                Object[] values = this.rows[i].getValues();
                if (values == null || values.length == 0) continue;
                Object[] newValues = newRow.getValues();
                if (colFromIncl > 0) {
                    System.arraycopy(values, 0, newValues, 0, colFromIncl);
                }
                if (colFromIncl >= values.length) continue;
                System.arraycopy(values, colFromIncl, newValues, colToExcl, values.length - colFromIncl);
            }
            newData.setRows(newRows);
        }
        return newData;
    }

    public ModelData withoutField(String id) throws IllegalArgumentException {
        IModelFieldGroup[] newFields;
        IModelFieldGroup[] newGroups;
        ModelField[] groupFields;
        ModelFieldGroup parent;
        int[] idx = this.getIndexOfModelFieldGroup(id);
        if (idx[0] == -1) {
            throw new IllegalArgumentException("Group \"" + id + "\" not found");
        }
        IModelFieldGroup group = this.getFieldGroups().get(idx[1])[idx[0]];
        while ((parent = group.getParent()) != null && parent.getChildren().size() == 1) {
            group = parent;
        }
        id = group.getIdentifier();
        idx = this.getIndexOfModelFieldGroup(id);
        ModelRow[] newRows = null;
        if (this.rows != null && (groupFields = ModelFieldGroup.getBottomFields(new IModelFieldGroup[]{group})).length > 0) {
            int colToExcl = this.getIndexOfModelField(groupFields[0].getIdentifier());
            int colFromIncl = colToExcl + group.getColspan();
            int newLength = this.getFieldsCount() - group.getColspan();
            newRows = new ModelRow[this.rows.length];
            for (int i = 0; i < this.rows.length; ++i) {
                ModelRow newRow;
                newRows[i] = newRow = new ModelRow(newLength);
                Object[] values = this.rows[i].getValues();
                if (values == null || values.length == 0) continue;
                Object[] newValues = newRow.getValues();
                if (colToExcl > 0) {
                    System.arraycopy(values, 0, newValues, 0, colToExcl);
                }
                if (colFromIncl >= values.length) continue;
                System.arraycopy(values, colFromIncl, newValues, colToExcl, values.length - colFromIncl);
            }
        }
        if (idx[1] == 0) {
            IModelFieldGroup[] groups = ModelFieldGroup.getUpperFieldGroups(this.getFields());
            newGroups = new IModelFieldGroup[groups.length - 1];
            if (idx[0] > 0) {
                System.arraycopy(groups, 0, newGroups, 0, idx[0]);
            }
            if (idx[0] < newGroups.length) {
                System.arraycopy(groups, idx[0] + 1, newGroups, idx[0], newGroups.length - idx[0]);
            }
        } else {
            newFields = ModelField.copyOfModelFields(this.getFields());
            ModelData idxData = new ModelData((ModelField[])newFields);
            group = idxData.getFieldGroups().get(idx[1])[idx[0]];
            ModelFieldGroup parent2 = group.getParent();
            parent2.removeChild(group);
            newGroups = ModelFieldGroup.getUpperFieldGroups(newFields);
        }
        newFields = ModelFieldGroup.getBottomFields(newGroups);
        ModelData newData = new ModelData((ModelField[])newFields);
        if (newRows != null) {
            newData.setRows(newRows);
        }
        return newData;
    }

    public void removeRow(int row) throws IndexOutOfBoundsException {
        ModelRow[] newRows = new ModelRow[this.getRowsCount() - 1];
        if (row > 0) {
            System.arraycopy(this.rows, 0, newRows, 0, row);
        }
        if (row < newRows.length) {
            System.arraycopy(this.rows, row + 1, newRows, row, newRows.length - row);
        }
        this.setRows(newRows);
    }

    public void addRow(Object[] rowData) {
        int row = this.getRowsCount();
        ModelRow[] newRows = new ModelRow[row + 1];
        if (row > 0) {
            System.arraycopy(this.rows, 0, newRows, 0, row);
        }
        newRows[row] = new ModelRow(this.getFieldsCount());
        newRows[row].setValues(rowData);
        newRows[row].setLength(this.getFieldsCount());
        this.setRows(newRows);
    }
}

