/*
 * Decompiled with CFR 0.152.
 */
package org.quinto.swing.table.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.quinto.swing.table.model.IModelFieldGroup;
import org.quinto.swing.table.model.ModelField;
import org.quinto.swing.table.model.Utils;

public class ModelFieldGroup
implements IModelFieldGroup,
Serializable {
    private static final long serialVersionUID = 4L;
    private String identifier;
    private String caption;
    private ModelFieldGroup parent;
    private int rowspan;
    private boolean fixed;
    private boolean manageable;
    private transient int colspan;
    private transient int childrenRowspan;
    private List<IModelFieldGroup> children = new ArrayList<IModelFieldGroup>();

    public ModelFieldGroup() {
        this(null, null);
    }

    public ModelFieldGroup(String identifier, String caption) {
        this.identifier = identifier;
        this.caption = caption;
        this.manageable = true;
        this.childrenRowspan = -1;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.childrenRowspan = -1;
    }

    @Override
    public String getCaption() {
        return this.caption;
    }

    @Override
    public void setCaption(String caption) {
        this.caption = caption;
    }

    public ModelFieldGroup withCaption(String caption) {
        this.setCaption(caption);
        return this;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public ModelFieldGroup withIdentifier(String identifier) {
        this.setIdentifier(identifier);
        return this;
    }

    @Override
    public ModelFieldGroup getParent() {
        return this.parent;
    }

    private void setParent(ModelFieldGroup parent) {
        this.parent = parent;
    }

    private ModelFieldGroup withParent(ModelFieldGroup parent) {
        this.setParent(parent);
        return this;
    }

    public IModelFieldGroup getChild(String identifier) {
        if (identifier == null) {
            for (IModelFieldGroup child : this.children) {
                if (child.getIdentifier() != null) continue;
                return child;
            }
        } else {
            for (IModelFieldGroup child : this.children) {
                if (!identifier.equals(child.getIdentifier())) continue;
                return child;
            }
        }
        return null;
    }

    public List<IModelFieldGroup> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    void removeChild(IModelFieldGroup child) {
        this.children.remove(child);
        int childColspan = child.getColspan();
        for (ModelFieldGroup ancestor = this; ancestor != null; ancestor = ancestor.getParent()) {
            ancestor.colspan -= childColspan;
            ancestor.childrenRowspan = -1;
        }
    }

    public ModelFieldGroup withChild(IModelFieldGroup child) {
        if (child != null) {
            this.children.add(child);
            int childColspan = child.getColspan();
            for (ModelFieldGroup ancestor = this; ancestor != null; ancestor = ancestor.getParent()) {
                ancestor.colspan += childColspan;
                ancestor.childrenRowspan = -1;
            }
            if (child instanceof ModelField) {
                ((ModelField)child).setParent(this);
            } else {
                ((ModelFieldGroup)child).setParent(this);
            }
            if (!child.isManageable()) {
                this.setManageable(false);
            } else if (!this.isManageable()) {
                child.setManageable(false);
            }
            if (child.isFixed()) {
                this.setFixed(true);
            } else if (this.isFixed()) {
                child.setFixed(true);
            }
        }
        return this;
    }

    @Override
    public int getColspan() {
        if (this.colspan == 0) {
            for (IModelFieldGroup child : this.children) {
                this.colspan += child.getColspan();
            }
        }
        return this.colspan;
    }

    @Override
    public int getRowspan() {
        return this.rowspan;
    }

    @Override
    public void setRowspan(int rowspan) {
        this.rowspan = rowspan;
    }

    public ModelFieldGroup withRowspan(int rowspan) {
        this.setRowspan(rowspan);
        return this;
    }

    public int getChildrenRowspan() {
        return this.childrenRowspan;
    }

    void setChildrenRowspan(int childrenRowspan) {
        this.childrenRowspan = childrenRowspan;
    }

    @Override
    public ModelFieldGroup clone() {
        ModelFieldGroup ret;
        try {
            ret = (ModelFieldGroup)super.clone();
            ret.childrenRowspan = -1;
            ret.colspan = 0;
            ret.children = new ArrayList<IModelFieldGroup>();
        }
        catch (CloneNotSupportedException e) {
            ret = new ModelFieldGroup();
        }
        ret.withIdentifier(this.identifier).withCaption(this.caption).withRowspan(this.rowspan).withFixed(this.fixed).withManageable(this.manageable).withParent(this.parent);
        for (IModelFieldGroup child : this.getChildren()) {
            ret = ret.withChild(child.clone());
        }
        return ret;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + (this.caption == null ? 0 : this.caption.hashCode());
        hash = 59 * hash + (this.identifier == null ? 0 : this.identifier.hashCode());
        return hash;
    }

    public boolean equals(Object obj) {
        return this.equals(obj, true);
    }

    @Override
    public boolean equals(Object obj, boolean withParent) {
        if (!(obj instanceof ModelFieldGroup)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ModelFieldGroup other = (ModelFieldGroup)obj;
        if (!Utils.equals(this.caption, other.caption) || !Utils.equals(this.identifier, other.identifier) || withParent && !Utils.equals(this.parent, other.parent) || this.children.size() != other.children.size()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.get(i).equals(other.children.get(i), false)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getIdentifier();
    }

    public static ModelField[] getBottomFields(IModelFieldGroup[] fieldGroups) {
        if (fieldGroups == null) {
            return null;
        }
        LinkedHashMap<String, ModelField> ret = new LinkedHashMap<String, ModelField>();
        ModelFieldGroup.getBottomFields(Arrays.asList(fieldGroups), ret);
        return ret.values().toArray(new ModelField[ret.size()]);
    }

    private static void getBottomFields(List<IModelFieldGroup> fieldGroups, Map<String, ModelField> ret) {
        for (IModelFieldGroup fieldGroup : fieldGroups) {
            ModelField field;
            ModelField prevField;
            if (fieldGroup instanceof ModelFieldGroup) {
                ModelFieldGroup group = (ModelFieldGroup)fieldGroup;
                ModelFieldGroup.getBottomFields(group.getChildren(), ret);
                continue;
            }
            if (!(fieldGroup instanceof ModelField) || (prevField = ret.put((field = (ModelField)fieldGroup).getIdentifier(), field)) == null) continue;
            throw new IllegalArgumentException("Non-unique DB field name: " + field + " VS " + prevField);
        }
    }

    public static IModelFieldGroup[] getUpperFieldGroups(IModelFieldGroup[] fields) {
        if (fields == null) {
            return null;
        }
        LinkedHashMap<String, Integer> uniqueGroups = new LinkedHashMap<String, Integer>();
        ArrayList<IModelFieldGroup> ret = new ArrayList<IModelFieldGroup>();
        for (IModelFieldGroup field : fields) {
            ModelFieldGroup parent = field.getParent();
            while (parent != null) {
                field = parent;
                parent = field.getParent();
            }
            Integer prev = uniqueGroups.put(field.getIdentifier(), uniqueGroups.size());
            if (prev == null) {
                uniqueGroups.put(field.getIdentifier(), uniqueGroups.size());
                ret.add(field);
                continue;
            }
            if (prev.equals(uniqueGroups.size())) continue;
            throw new IllegalArgumentException("Field groups should be unbroken and should have unique DB field names. Repeated: " + field.getIdentifier());
        }
        return ret.toArray(new IModelFieldGroup[ret.size()]);
    }

    @Override
    public boolean isFixed() {
        return this.fixed;
    }

    @Override
    public void setFixed(boolean fixed) {
        this.fixed = fixed;
        if (!fixed) {
            for (IModelFieldGroup child : this.children) {
                child.setFixed(fixed);
            }
        } else if (this.parent != null) {
            this.parent.setFixed(fixed);
        }
    }

    public ModelFieldGroup withFixed(boolean fixed) {
        this.setFixed(fixed);
        return this;
    }

    @Override
    public boolean isManageable() {
        return this.manageable;
    }

    @Override
    public void setManageable(boolean manageable) {
        this.manageable = manageable;
        if (manageable) {
            for (IModelFieldGroup child : this.children) {
                child.setManageable(manageable);
            }
        } else if (this.parent != null) {
            this.parent.setManageable(manageable);
        }
    }

    public ModelFieldGroup withManageable(boolean manageable) {
        this.setManageable(manageable);
        return this;
    }
}

