/*
 * Decompiled with CFR 0.152.
 */
package org.quinto.swing.table.view;

import javax.swing.RowSorter;
import javax.swing.SortOrder;
import org.quinto.swing.table.model.ModelData;
import org.quinto.swing.table.model.ModelField;
import org.quinto.swing.table.view.JBroTable;
import org.quinto.swing.table.view.PredefinedRowSorter;

public class JBroPredefinedRowSorter<This extends JBroPredefinedRowSorter<This>>
extends PredefinedRowSorter<This> {
    private static final SortKey[] EMPTY_ARRAY = new SortKey[0];

    public JBroPredefinedRowSorter(JBroTable table) {
        super(table);
    }

    private RowSorter.SortKey[] toNumericKeys(SortKey ... modelColumns) {
        if (modelColumns != null && modelColumns.length != 0) {
            JBroTable table = this.getTable();
            ModelData data = table.getData();
            RowSorter.SortKey[] keys = new RowSorter.SortKey[modelColumns.length];
            for (int i = 0; i < modelColumns.length; ++i) {
                RowSorter.SortKey key;
                SortKey modelColumn = modelColumns[i];
                int col = data.getIndexOfModelField(modelColumn.getColumn());
                if (col < 0) {
                    throw new IllegalArgumentException("Field \"" + modelColumn.getColumn() + "\" not found");
                }
                keys[i] = key = new RowSorter.SortKey(col, modelColumn.getSortOrder());
            }
            return keys;
        }
        return null;
    }

    private SortKey[] toStringKeys(RowSorter.SortKey ... modelColumns) {
        if (modelColumns != null && modelColumns.length != 0) {
            JBroTable table = this.getTable();
            ModelData data = table.getData();
            ModelField[] fields = data.getFields();
            SortKey[] keys = new SortKey[modelColumns.length];
            for (int i = 0; i < modelColumns.length; ++i) {
                SortKey key;
                RowSorter.SortKey modelColumn = modelColumns[i];
                ModelField col = fields[modelColumn.getColumn()];
                keys[i] = key = new SortKey(col.getIdentifier(), modelColumn.getSortOrder());
            }
            return keys;
        }
        return EMPTY_ARRAY;
    }

    public This withPostColumnsByName(SortKey ... modelColumns) {
        return (This)((JBroPredefinedRowSorter)super.withPostColumns(this.toNumericKeys(modelColumns)));
    }

    public This withPreColumnsByName(SortKey ... modelColumns) {
        return (This)((JBroPredefinedRowSorter)super.withPreColumns(this.toNumericKeys(modelColumns)));
    }

    @Override
    public JBroTable getTable() {
        return (JBroTable)super.getTable();
    }

    public SortKey[] getPostColumnsWithNames() {
        return this.toStringKeys(super.getPostColumns());
    }

    public SortKey[] getPreColumnsWithNames() {
        return this.toStringKeys(super.getPreColumns());
    }

    public static class SortKey {
        private final String column;
        private final SortOrder sortOrder;

        public SortKey(String column, SortOrder sortOrder) {
            if (column == null) {
                throw new IllegalArgumentException("column must be non-null");
            }
            if (sortOrder == null) {
                throw new IllegalArgumentException("sort order must be non-null");
            }
            this.column = column;
            this.sortOrder = sortOrder;
        }

        public String getColumn() {
            return this.column;
        }

        public SortOrder getSortOrder() {
            return this.sortOrder;
        }

        public int hashCode() {
            int hash = 5;
            hash = 53 * hash + this.column.hashCode();
            hash = 53 * hash + this.sortOrder.hashCode();
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SortKey)) {
                return false;
            }
            SortKey other = (SortKey)obj;
            return this.sortOrder == other.sortOrder && this.column.equals(other.column);
        }
    }
}

