/*
 * Decompiled with CFR 0.152.
 */
package Util;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicReference;

public class IOUtils {
    public static final int CLOSE_NEITHER = 1;
    public static final int CLOSE_INPUT = 2;
    public static final int CLOSE_OUTPUT = 4;
    public static final int CLOSE_BOTH = 6;
    public static final int DEFAULT_READ_BUFFER_SIZE = 8192;

    public static void collectProcessStreams(final Process p, final ByteArrayOutputStream stdout, final ByteArrayOutputStream stderr) {
        Thread runStdout = new Thread(){

            @Override
            public void run() {
                IOUtils.copyStream(p.getInputStream(), stdout);
            }
        };
        runStdout.start();
        Thread runStderr = new Thread(){

            @Override
            public void run() {
                IOUtils.copyStream(p.getErrorStream(), stderr);
            }
        };
        runStderr.start();
        try {
            runStdout.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            runStderr.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void collectProcessStreams(final Process p, final StringBuilder stdout, final StringBuilder stderr) {
        Thread runStdout = new Thread(){

            @Override
            public void run() {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IOUtils.copyStream(p.getInputStream(), out);
                stdout.append(new String(out.toByteArray()));
            }
        };
        runStdout.start();
        Thread runStderr = new Thread(){

            @Override
            public void run() {
                ByteArrayOutputStream err = new ByteArrayOutputStream();
                IOUtils.copyStream(p.getErrorStream(), err);
                stderr.append(new String(err.toByteArray()));
            }
        };
        runStderr.start();
        try {
            runStdout.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            runStderr.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String collectProcessText(final Process p) {
        final AtomicReference<Object> result = new AtomicReference<Object>(null);
        Thread runStdout = new Thread(){
            ByteArrayOutputStream stdout = new ByteArrayOutputStream();

            @Override
            public void run() {
                IOUtils.copyStream(p.getInputStream(), this.stdout);
                result.set(new String(this.stdout.toByteArray()));
            }
        };
        runStdout.start();
        Thread runStderr = new Thread(){

            @Override
            public void run() {
                IOUtils.copyStream(p.getErrorStream(), System.err);
            }
        };
        runStderr.start();
        try {
            runStdout.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            runStderr.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyReader(Reader in, Writer out) {
        try {
            char[] buffer = new char[8192];
            int charsRead = -1;
            while ((charsRead = in.read(buffer)) > -1) {
                out.write(buffer, 0, charsRead);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream in, OutputStream out) {
        try {
            byte[] buffer = new byte[8192];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) > -1) {
                out.write(buffer, 0, bytesRead);
                out.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream in, OutputStream out, int closeOptions) {
        try {
            byte[] buffer = new byte[8192];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) > -1) {
                out.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if ((closeOptions & 1) < 1) {
                try {
                    if ((closeOptions & 2) > 0) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if ((closeOptions & 4) > 0) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fileToByteArray(String fileName) {
        FilterInputStream in = null;
        byte[] result = null;
        try {
            File f = new File(fileName);
            int fileSize = (int)f.length();
            in = new DataInputStream(new FileInputStream(f));
            result = new byte[fileSize];
            ((DataInputStream)in).readFully(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static String fileToString(String file) {
        String result = null;
        FilterInputStream in = null;
        try {
            File f = new File(file);
            byte[] buffer = new byte[(int)f.length()];
            in = new DataInputStream(new FileInputStream(f));
            ((DataInputStream)in).readFully(buffer);
            result = new String(buffer);
        }
        catch (IOException e) {
            throw new RuntimeException("IO problem in fileToString", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    public static byte[] inputStreamToByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyStream(in, out, 6);
        byte[] result = out.toByteArray();
        return result;
    }

    public static String inputStreamToString(InputStream in) throws IOException {
        return new String(IOUtils.inputStreamToByteArray(in));
    }

    public static void outputProcessStreams(final Process p) {
        Thread runStdout = new Thread(){

            @Override
            public void run() {
                IOUtils.copyStream(p.getInputStream(), System.out);
            }
        };
        runStdout.start();
        Thread runStderr = new Thread(){

            @Override
            public void run() {
                IOUtils.copyStream(p.getErrorStream(), System.err);
            }
        };
        runStderr.start();
    }
}

