/*
 * Decompiled with CFR 0.152.
 */
package org.quinto.swing.table.model;

import java.io.Serializable;
import java.util.Arrays;

public class ModelRow
implements Serializable {
    private static final long serialVersionUID = 4L;
    private Object[] values;

    public ModelRow() {
        this(0);
    }

    public ModelRow(int length) {
        this.values = null;
        this.setLength(length);
    }

    public ModelRow(Object ... values) {
        this.values = values;
    }

    public int hashCode() {
        return Arrays.deepHashCode(this.values);
    }

    public boolean equals(Object obj) {
        return obj instanceof ModelRow && Arrays.deepEquals(this.values, ((ModelRow)obj).values);
    }

    public ModelRow clone() {
        return this.values == null ? new ModelRow() : new ModelRow((Object[])this.values.clone());
    }

    public Object getValue(int index) {
        if (this.values == null || index < 0 || index >= this.values.length) {
            return null;
        }
        return this.values[index];
    }

    public boolean setValue(int index, Object value) {
        if (this.values == null || index < 0 || index >= this.values.length) {
            return false;
        }
        this.values[index] = value;
        return true;
    }

    public void setLength(int length) {
        if (this.values != null && this.values.length == length) {
            return;
        }
        Object[] newValues = new Object[length];
        if (this.values != null && this.values.length != 0) {
            System.arraycopy(this.values, 0, newValues, 0, Math.min(this.values.length, length));
        }
        this.values = newValues;
    }

    public int getLength() {
        return this.values == null ? 0 : this.values.length;
    }

    public Object[] getValues() {
        return this.values;
    }

    public void setValues(Object[] values) {
        this.values = values;
    }
}

