/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.border.types;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public abstract class AbstractBorderEditor
extends JPanel {
    protected Border value;
    private String caption;
    private boolean changed;
    public static final String BORDER_EVENT_NAME = "border";

    public AbstractBorderEditor() {
        this.setCaption("");
        this.setChanged(false);
    }

    public void fireChange() {
        this.setChanged(true);
        this.firePropertyChange(BORDER_EVENT_NAME, null, null);
    }

    protected Border getCurrentBorder() {
        return this.value;
    }

    public void setCurrentBorder(Border border) {
        this.setValue(border);
        this.refreshInterface();
    }

    public Border getSelectedBorder() {
        if (this.isChanged()) {
            this.prepareSelection();
            this.setChanged(false);
        }
        return this.getCurrentBorder();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public String getCaption() {
        return this.caption;
    }

    protected void setCaption(String caption) {
        this.caption = caption;
    }

    public String toString() {
        return this.getCaption();
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 200);
    }

    protected JPanel getCenteredPane(Component component) {
        JPanel pane = new JPanel(new FlowLayout(1));
        if (component != null) {
            pane.add(component);
        }
        return pane;
    }

    public void initialize() {
        if (this.value == null) {
            this.value = this.getDefaultValue();
        }
    }

    public void reset() {
        this.setValue(this.getDefaultValue());
        this.refreshInterface();
        this.fireChange();
    }

    public void setValue(Border value) {
        this.value = value;
    }

    public JLabel getPreviewLabel() {
        JLabel label = new JLabel();
        label.setBorder(this.value);
        label.setText(this.getCaption());
        label.setOpaque(false);
        return label;
    }

    protected abstract Border getDefaultValue();

    protected abstract void prepareSelection();

    protected abstract void refreshInterface();
}

