/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.font;

import datechooser.beans.locale.LocaleUtils;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class FontSelectPane
extends JPanel {
    public static final String FONT_EVENT_NAME = "font";
    public static int MIN_FONT_SIZE = 3;
    public static int MAX_FONT_SIZE = 96;
    private Font font;
    private JComboBox selFont = new JComboBox<String>(new DefaultComboBoxModel<String>(this.getAllFonts()));
    private JCheckBox selStyleBold = new JCheckBox(LocaleUtils.getEditorLocaleString("Bold"));
    private JCheckBox selStyleItalic = new JCheckBox(LocaleUtils.getEditorLocaleString("Italic"));
    private SpinnerNumberModel selSize;
    private JSpinner selSizeSpinner;

    public FontSelectPane(Font font) {
        this.selSize = new SpinnerNumberModel(font.getSize(), MIN_FONT_SIZE, MAX_FONT_SIZE, 1);
        this.selSizeSpinner = new JSpinner(this.selSize);
        this.setLayout(new FlowLayout(1));
        JPanel style = new JPanel(new GridLayout(1, 2));
        style.add(this.selStyleBold);
        style.add(this.selStyleItalic);
        this.add(this.selFont);
        this.add(style);
        this.add(this.selSizeSpinner);
        OnChange changeHandler = new OnChange();
        this.selFont.addActionListener(changeHandler);
        this.selStyleBold.addActionListener(changeHandler);
        this.selStyleItalic.addActionListener(changeHandler);
        this.selSize.addChangeListener(changeHandler);
        this.setSelectedFont(font);
    }

    public Font getSelectedFont() {
        Font newFont = this.font;
        newFont = new Font((String)this.selFont.getSelectedItem(), this.getStyle(), this.selSize.getNumber().intValue());
        return newFont;
    }

    public void setSelectedFont(Font font) {
        this.font = font;
        this.selFont.setSelectedItem(font.getFamily());
        this.selStyleBold.setSelected(font.isBold());
        this.selStyleItalic.setSelected(font.isItalic());
        this.selSize.setValue(font.getSize());
    }

    private String[] getAllFonts() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }

    private int getStyle() {
        if (this.selStyleBold.isSelected() && this.selStyleItalic.isSelected()) {
            return 3;
        }
        if (this.selStyleBold.isSelected()) {
            return 1;
        }
        if (this.selStyleItalic.isSelected()) {
            return 2;
        }
        return 0;
    }

    public void fireChange() {
        this.firePropertyChange(FONT_EVENT_NAME, null, null);
    }

    class OnChange
    implements ActionListener,
    ChangeListener {
        OnChange() {
        }

        public void actionPerformed(ActionEvent e) {
            FontSelectPane.this.fireChange();
        }

        public void stateChanged(ChangeEvent e) {
            FontSelectPane.this.fireChange();
        }
    }
}

