/*
 * Decompiled with CFR 0.152.
 */
package datechooser.model;

import datechooser.beans.locale.LocaleUtils;
import datechooser.events.CommitEvent;
import datechooser.events.CommitListener;
import datechooser.events.CursorMoveEvent;
import datechooser.events.CursorMoveListener;
import datechooser.events.SelectionChangedEvent;
import datechooser.events.SelectionChangedListener;
import datechooser.model.CellState;
import datechooser.model.DateChoose;
import datechooser.model.DateUtils;
import datechooser.model.exeptions.IncompatibleDataExeption;
import datechooser.model.multiple.Period;
import datechooser.model.multiple.PeriodSet;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDateChooseModel
implements DateChoose {
    private int rowsCount;
    private int colsCount;
    private int selRow;
    private int selCol;
    private boolean isValid;
    private boolean enabled;
    private boolean autoScroll;
    private boolean showNeighbourMonth;
    private Locale locale;
    private int firstWeekDay;
    private PropertyChangeSupport changeSupport;
    protected boolean changeEventsOn;
    private EventListenerList listenerList = new EventListenerList();
    private Calendar first;
    private Calendar minConstraint;
    private Calendar maxConstraint;
    private Calendar current;
    private Calendar cursor;
    private Calendar defaultDate;
    private Calendar tempDate;
    private PeriodSet forbidden = null;
    private boolean locked;
    private boolean nothingAllowed;

    protected abstract void selectColumn(int var1);

    public AbstractDateChooseModel(Calendar current, int rowsCount, int colsCount) {
        this.changeSupport = new PropertyChangeSupport(this);
        this.setChangeEventsOn(false);
        this.current = (Calendar)current.clone();
        this.tempDate = (Calendar)current.clone();
        this.first = (Calendar)current.clone();
        this.defaultDate = (Calendar)current.clone();
        this.cursor = (Calendar)current.clone();
        this.forbidden = new PeriodSet();
        this.setAutoScroll(true);
        this.setShowNeighbourMonth(true);
        this.setEnabled(true);
        this.setLocked(false);
        this.setNothingAllowed(true);
        this.defaultDate = (Calendar)current.clone();
        this.rowsCount = rowsCount;
        this.colsCount = colsCount;
        this.setLocale(Locale.getDefault());
        this.initFirst();
        this.invalidate();
        this.setMinConstraint(null);
        this.setMaxConstraint(null);
        this.setChangeEventsOn(true);
    }

    @Override
    public int getRowsCount() {
        return this.rowsCount;
    }

    @Override
    public int getColsCount() {
        return this.colsCount;
    }

    @Override
    public boolean isCursor(int row, int column) {
        this.tempDate = this.getCellDate(row, column);
        return DateUtils.equals(this.tempDate, this.getCurrent());
    }

    @Override
    public CellState getCellState(int row, int column) {
        this.tempDate = this.getCellDate(row, column);
        if (this.tempDate.get(2) != this.getNextMonth(this.first.get(2))) {
            return CellState.NORMAL_SCROLL;
        }
        if (!this.isEnabled()) {
            return CellState.UNACCESSIBLE;
        }
        if (!this.checkConstraints(this.tempDate) || this.isDateForbidden(this.tempDate)) {
            return CellState.UNACCESSIBLE;
        }
        if (this.isSelected(this.tempDate)) {
            return CellState.SELECTED;
        }
        if (this.getDefaultDate() != null && DateUtils.equals(this.tempDate, this.getDefaultDate())) {
            return CellState.NOW;
        }
        return CellState.NORMAL;
    }

    @Override
    public String getCellCaption(int row, int column) {
        return this.getCellDate(row, column).get(5) + "";
    }

    @Override
    public Calendar getCellDate(int row, int column) {
        this.tempDate.setTime(this.first.getTime());
        this.tempDate.add(5, row * 7 + column);
        return this.tempDate;
    }

    @Override
    public void setConstraints(Calendar min, Calendar max) {
        this.setMinConstraint(min);
        this.setMaxConstraint(max);
    }

    @Override
    public boolean needsFullValidation() {
        if (this.isValid) {
            return false;
        }
        this.isValid = false;
        return true;
    }

    @Override
    public boolean select(int row, int column) {
        if (row < 0 && column >= 0) {
            this.selectColumn(column);
        }
        if (!this.isEnabled()) {
            return false;
        }
        this.tempDate = this.getCellDate(row, column);
        return this.select(this.tempDate);
    }

    private boolean isInVisibleMonth(Calendar aDate) {
        int visibleMonth = this.getNextMonth(this.first.get(2));
        return aDate.get(2) == visibleMonth && aDate.get(1) == this.first.get(1) + (visibleMonth == 0 ? 1 : 0);
    }

    @Override
    public boolean select(Calendar aDate) {
        if (aDate == null) {
            return true;
        }
        if (!this.isEnabled()) {
            return false;
        }
        this.tempDate.setTime(aDate.getTime());
        if (!this.isInVisibleMonth(this.tempDate) && !this.isAutoScroll()) {
            return false;
        }
        if (DateUtils.equals(this.tempDate, this.getCurrent())) {
            return false;
        }
        if (!this.checkConstraints(this.tempDate)) {
            return false;
        }
        this.getCurrent().setTime(this.tempDate.getTime());
        this.selRow = this.getSelectedRow();
        this.selCol = this.getSelectedColumn();
        if (!this.isInVisibleMonth(this.tempDate)) {
            this.initFirst();
            this.invalidate();
        }
        this.firePropertyChange("selected", null, aDate);
        this.fireCursorMove();
        return true;
    }

    private int getDaysPassed() {
        return this.first.getActualMaximum(5) - this.first.get(5) + 1 + this.getCurrent().get(5);
    }

    private int getSelectedRow() {
        return this.getDaysPassed() / this.getColsCount();
    }

    private int getSelectedColumn() {
        return this.getDaysPassed() % this.getColsCount();
    }

    protected void invalidate() {
        this.isValid = false;
    }

    private boolean checkConstraints(Calendar check) {
        if (this.getMinConstraint() != null && this.getMinConstraint().after(check)) {
            return false;
        }
        return this.getMaxConstraint() == null || !this.getMaxConstraint().before(check);
    }

    private int getDayOfWeek(int calendarConstant) {
        return calendarConstant >= this.getFirstWeekDay() ? calendarConstant - this.getFirstWeekDay() + 1 : 7 - this.getFirstWeekDay() + 1 + calendarConstant;
    }

    private int getNextMonth(int month) {
        if (month == 11) {
            return 0;
        }
        return month + 1;
    }

    private void initFirst() {
        this.initFirst(this.getCurrent());
    }

    private void initFirst(Calendar aDate) {
        this.first.set(aDate.get(1), aDate.get(2), 1);
        int cellsPassed = 0;
        int firstDayOfWeek = this.getDayOfWeek(this.first.get(7));
        cellsPassed = firstDayOfWeek == 1 ? 7 : firstDayOfWeek - 1;
        this.first.add(5, -cellsPassed);
        this.selRow = (cellsPassed += aDate.get(5)) / this.getColsCount();
        this.selCol = cellsPassed - this.getColsCount() * this.selRow - 1;
    }

    private static boolean equalsYearMonth(Calendar dat1, Calendar dat2) {
        return dat1.get(1) == dat2.get(1) && dat1.get(2) == dat2.get(2);
    }

    @Override
    public Calendar getCurrent() {
        return this.current;
    }

    @Override
    public void showMonthYear(int month, int year) {
        this.tempDate.set(year, month, 1);
        this.initFirst(this.tempDate);
        this.invalidate();
        this.firePropertyChange("year_month", null, null);
    }

    @Override
    public Calendar getVisibleDate() {
        this.tempDate.setTime(this.first.getTime());
        this.tempDate.set(5, 1);
        this.tempDate.add(2, 1);
        return this.tempDate;
    }

    @Override
    public Calendar getDefaultDate() {
        return this.defaultDate;
    }

    @Override
    public void setDefaultDate(Calendar aDate) throws IncompatibleDataExeption {
        if (this.isDateForbidden(aDate)) {
            throw new IncompatibleDataExeption(LocaleUtils.getErrorsLocaleString("Date_forbidden"));
        }
        this.defaultDate.setTime(aDate.getTime());
    }

    private void dateShift(int field, int shift) {
        this.tempDate.setTime(this.getCurrent().getTime());
        this.tempDate.add(field, shift);
        this.select(this.tempDate);
    }

    @Override
    public void shift(int rowShift, int columnShift) {
        if (rowShift == 0 && columnShift == 0) {
            return;
        }
        this.dateShift(5, rowShift * this.getColsCount() + columnShift);
    }

    @Override
    public void monthShift(int shift) {
        if (shift == 0) {
            return;
        }
        this.dateShift(2, shift);
    }

    @Override
    public void yearShift(int shift) {
        if (shift == 0) {
            return;
        }
        this.dateShift(1, shift);
    }

    @Override
    public boolean isAutoScroll() {
        return this.autoScroll;
    }

    @Override
    public void setAutoScroll(boolean autoScroll) {
        this.autoScroll = autoScroll;
    }

    @Override
    public boolean isShowNeighbourMonth() {
        return this.showNeighbourMonth;
    }

    @Override
    public void setShowNeighbourMonth(boolean showNeighbourMonth) {
        this.showNeighbourMonth = showNeighbourMonth;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.isEnabled();
        this.enabled = enabled;
        this.firePropertyChange("enabled", oldEnabled, enabled);
    }

    public PeriodSet getForbiddenSet() {
        return this.forbidden;
    }

    protected boolean isForbiddenDefault(PeriodSet forbiddenPeriods) {
        return forbiddenPeriods != null && forbiddenPeriods.contains(this.getDefaultDate());
    }

    public void setForbiddenSet(PeriodSet forbiddenPeriods) throws IncompatibleDataExeption {
        if (this.isForbiddenDefault(forbiddenPeriods)) {
            throw new IncompatibleDataExeption(LocaleUtils.getErrorsLocaleString("Forbidden_default"));
        }
        PeriodSet oldForbid = this.getForbiddenSet();
        this.forbidden.set(forbiddenPeriods);
        this.firePropertyChange("forbidDates", null, null);
    }

    @Override
    public Iterable<Period> getForbidden() {
        return this.forbidden.getPeriods();
    }

    @Override
    public void setForbidden(Iterable<Period> forbiddenPeriods) {
        this.forbidden.set(forbiddenPeriods);
        this.firePropertyChange("forbidDates", null, null);
    }

    protected boolean isPeriodForbidden(Period period) {
        return this.forbidden != null && this.forbidden.intersects(period);
    }

    protected boolean isDateForbidden(Calendar date) {
        return this.forbidden != null && this.forbidden.contains(date);
    }

    @Override
    public Calendar getMinConstraint() {
        return this.minConstraint;
    }

    @Override
    public void setMinConstraint(Calendar minConstraint) {
        this.minConstraint = minConstraint;
    }

    @Override
    public Calendar getMaxConstraint() {
        return this.maxConstraint;
    }

    @Override
    public void setMaxConstraint(Calendar maxConstraint) {
        this.maxConstraint = maxConstraint;
    }

    @Override
    public void setSelectedDate(Calendar aDate) {
        this.select(aDate);
        this.tryApplySelection();
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale == null) {
            return;
        }
        Locale oldLocale = this.getLocale();
        this.locale = locale;
        this.setFirstWeekDay(Calendar.getInstance(locale).getFirstDayOfWeek());
        this.initFirst();
        this.firePropertyChange("locale", oldLocale, locale);
    }

    private int getFirstWeekDay() {
        return this.firstWeekDay;
    }

    private void setFirstWeekDay(int firstWeekDay) {
        this.firstWeekDay = firstWeekDay;
    }

    @Override
    public void commit() {
        this.fireCommit();
    }

    @Override
    public final void tryApplySelection() {
        if (this.isLocked()) {
            return;
        }
        this.applySelection();
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Override
    public void setNothingAllowed(boolean allow) {
        if (this.isNothingSelected() && !allow) {
            return;
        }
        boolean wasAllowed = this.isNothingAllowed();
        this.nothingAllowed = allow;
        this.firePropertyChange("nothingAllowed", wasAllowed, this.isNothingAllowed());
    }

    @Override
    public boolean isNothingAllowed() {
        return this.nothingAllowed;
    }

    public boolean isChangeEventsOn() {
        return this.changeEventsOn;
    }

    public void setChangeEventsOn(boolean changeEventsOn) {
        this.changeEventsOn = changeEventsOn;
    }

    @Override
    public void selectNothing() {
        if (!this.isNothingAllowed()) {
            return;
        }
        this.applySelectNothing();
    }

    @Override
    public void addSelectionChangedListener(SelectionChangedListener listener) {
        this.listenerList.add(SelectionChangedListener.class, listener);
    }

    @Override
    public void removeSelectionChangedListener(SelectionChangedListener listener) {
        this.listenerList.remove(SelectionChangedListener.class, listener);
    }

    @Override
    public void fireSelectionChange() {
        SelectionChangedListener[] listeners;
        SelectionChangedEvent evt = new SelectionChangedEvent(this);
        for (SelectionChangedListener listener : listeners = (SelectionChangedListener[])this.listenerList.getListeners(SelectionChangedListener.class)) {
            listener.onSelectionChange(evt);
        }
    }

    @Override
    public void addCommitListener(CommitListener listener) {
        this.listenerList.add(CommitListener.class, listener);
    }

    @Override
    public void removeCommitListener(CommitListener listener) {
        this.listenerList.remove(CommitListener.class, listener);
    }

    private void fireCommit() {
        CommitListener[] listeners;
        CommitEvent evt = new CommitEvent(this);
        for (CommitListener listener : listeners = (CommitListener[])this.listenerList.getListeners(CommitListener.class)) {
            listener.onCommit(evt);
        }
    }

    @Override
    public void addCursorMoveListener(CursorMoveListener listener) {
        this.listenerList.add(CursorMoveListener.class, listener);
    }

    @Override
    public void removeCursorMoveListener(CursorMoveListener listener) {
        this.listenerList.remove(CursorMoveListener.class, listener);
    }

    protected void fireCursorMove() {
        CursorMoveListener[] listeners;
        CursorMoveEvent evt = new CursorMoveEvent(this);
        for (CursorMoveListener listener : listeners = (CursorMoveListener[])this.listenerList.getListeners(CursorMoveListener.class)) {
            listener.onCursorMove(evt);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void firePropertyChange(String name, Object oldValue, Object newValue) {
        if (!this.isChangeEventsOn()) {
            return;
        }
        this.changeSupport.firePropertyChange(name, oldValue, newValue);
    }

    protected abstract void applySelection();

    protected abstract void applySelectNothing();
}

