/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.odfdom.converter.xhtml;

import fr.opensagres.odfdom.converter.core.AbstractODFConverter;
import fr.opensagres.odfdom.converter.core.IURIResolver;
import fr.opensagres.odfdom.converter.core.ODFConverterException;
import fr.opensagres.odfdom.converter.internal.xhtml.ElementVisitorForXHTML;
import fr.opensagres.odfdom.converter.internal.xhtml.ODFXHTMLPage;
import fr.opensagres.odfdom.converter.internal.xhtml.StyleEngineForXHTML;
import fr.opensagres.odfdom.converter.xhtml.XHTMLOptions;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeMasterStyles;
import org.odftoolkit.odfdom.pkg.ElementVisitor;

public class XHTMLConverter
extends AbstractODFConverter<XHTMLOptions> {
    private static final XHTMLConverter INSTANCE = new XHTMLConverter();

    public static XHTMLConverter getInstance() {
        return INSTANCE;
    }

    @Override
    protected void doConvert(OdfDocument odfDocument, OutputStream out, Writer writer, XHTMLOptions options) throws ODFConverterException, IOException {
        boolean generateCSSComments = false;
        IURIResolver resolver = IURIResolver.DEFAULT;
        int indent = 0;
        if (options != null) {
            generateCSSComments = options.isGenerateCSSComments();
            resolver = options.getURIResolver();
            indent = options.getIndent();
        }
        StyleEngineForXHTML styleEngine = new StyleEngineForXHTML(odfDocument, generateCSSComments, indent, resolver);
        ODFXHTMLPage xhtml = new ODFXHTMLPage(styleEngine, indent);
        try {
            OdfStylesDom stylesDom = odfDocument.getStylesDom();
            OdfContentDom contentDom = odfDocument.getContentDom();
            stylesDom.getOfficeStyles().accept((ElementVisitor)styleEngine);
            stylesDom.getAutomaticStyles().accept((ElementVisitor)styleEngine);
            contentDom.getAutomaticStyles().accept((ElementVisitor)styleEngine);
            ElementVisitorForXHTML visitorForXHTML = new ElementVisitorForXHTML(xhtml, options, odfDocument, out, writer);
            OdfOfficeMasterStyles masterStyles = odfDocument.getOfficeMasterStyles();
            masterStyles.accept((ElementVisitor)visitorForXHTML);
            odfDocument.getContentRoot().accept((ElementVisitor)visitorForXHTML);
            if (writer != null) {
                xhtml.save(writer);
            } else {
                xhtml.save(out);
            }
        }
        catch (Exception e) {
            throw new ODFConverterException(e);
        }
    }
}

