/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.core.styles;

import fr.opensagres.poi.xwpf.converter.core.styles.TableCellInfo;
import fr.opensagres.poi.xwpf.converter.core.styles.XWPFStylesDocument;
import fr.opensagres.poi.xwpf.converter.core.utils.XWPFTableUtil;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtCell;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;

public class TableInfo {
    private final XWPFTable table;
    private final XWPFStylesDocument stylesDocument;
    private final Map<XWPFTableCell, TableCellInfo> cellInfos;
    private Integer nbColumns;
    private final boolean canApplyFirstRow;
    private final boolean canApplyLastRow;
    private boolean canApplyFirstCol;
    private final boolean canApplyLastCol;

    public TableInfo(XWPFTable table, XWPFStylesDocument stylesDocument) {
        this.table = table;
        this.cellInfos = new HashMap<XWPFTableCell, TableCellInfo>();
        this.stylesDocument = stylesDocument;
        this.nbColumns = null;
        int tblLookVal = XWPFTableUtil.getTblLookVal(table);
        this.canApplyFirstRow = XWPFTableUtil.canApplyFirstRow(tblLookVal);
        this.canApplyLastRow = XWPFTableUtil.canApplyLastRow(tblLookVal);
        this.canApplyFirstCol = XWPFTableUtil.canApplyFirstCol(tblLookVal);
        this.canApplyLastCol = XWPFTableUtil.canApplyLastCol(tblLookVal);
    }

    public TableCellInfo getCellInfo(XWPFTableCell cell) {
        TableCellInfo cellInfo = this.cellInfos.get(cell);
        if (cellInfo != null) {
            return cellInfo;
        }
        this.computeCellInfos(cell.getTableRow());
        return this.cellInfos.get(cell);
    }

    private void computeCellInfos(XWPFTableRow row) {
        int rowIndex;
        if (this.nbColumns == null) {
            this.nbColumns = XWPFTableUtil.computeColWidths(row.getTable()).length;
        }
        boolean firstRow = (rowIndex = this.table.getRows().indexOf(row)) == 0;
        boolean lastRow = rowIndex == this.table.getRows().size() - 1;
        boolean firstCol = true;
        boolean lastCol = false;
        int cellIndex = 0;
        CTRow ctRow = row.getCtRow();
        XmlCursor c = ctRow.newCursor();
        c.selectPath("./*");
        while (c.toNextSelection()) {
            XmlObject o = c.getObject();
            if (o instanceof CTTc) {
                CTTc tc = (CTTc)o;
                XWPFTableCell cell = row.getTableCell(tc);
                lastCol = (cellIndex = this.getCellIndex(cellIndex, cell)) == this.nbColumns - 1;
                this.addCellInfo(cell, firstRow, lastRow, firstCol, lastCol);
                firstCol = false;
                continue;
            }
            if (!(o instanceof CTSdtCell)) continue;
            CTSdtCell sdtCell = (CTSdtCell)o;
            List tcList = sdtCell.getSdtContent().getTcList();
            for (CTTc ctTc : tcList) {
                XWPFTableCell cell = new XWPFTableCell(ctTc, row, row.getTable().getBody());
                lastCol = (cellIndex = this.getCellIndex(cellIndex, cell)) == this.nbColumns - 1;
                this.addCellInfo(row.getTableCell(ctTc), firstRow, lastRow, firstCol, lastCol);
                firstCol = false;
            }
        }
        c.dispose();
    }

    public void addCellInfo(XWPFTableCell cell, boolean firstRow, boolean lastRow, boolean firstCol, boolean lastCol) {
        TableCellInfo cellInfo = new TableCellInfo(this, firstRow, lastRow, firstCol, lastCol);
        this.cellInfos.put(cell, cellInfo);
    }

    private int getCellIndex(int cellIndex, XWPFTableCell cell) {
        BigInteger gridSpan = this.stylesDocument.getTableCellGridSpan(cell.getCTTc().getTcPr());
        cellIndex = gridSpan != null ? (cellIndex += gridSpan.intValue()) : ++cellIndex;
        return cellIndex;
    }

    public boolean canApplyFirstRow() {
        return this.canApplyFirstRow;
    }

    public boolean canApplyLastRow() {
        return this.canApplyLastRow;
    }

    public boolean canApplyFirstCol() {
        return this.canApplyFirstCol;
    }

    public boolean canApplyLastCol() {
        return this.canApplyLastCol;
    }
}

