/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.xhtml;

import fr.opensagres.poi.xwpf.converter.core.AbstractXWPFConverter;
import fr.opensagres.poi.xwpf.converter.core.IXWPFConverter;
import fr.opensagres.poi.xwpf.converter.core.XWPFConverterException;
import fr.opensagres.poi.xwpf.converter.xhtml.DefaultContentHandlerFactory;
import fr.opensagres.poi.xwpf.converter.xhtml.IContentHandlerFactory;
import fr.opensagres.poi.xwpf.converter.xhtml.XHTMLOptions;
import fr.opensagres.poi.xwpf.converter.xhtml.internal.XHTMLMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.xml.sax.ContentHandler;

public class XHTMLConverter
extends AbstractXWPFConverter<XHTMLOptions> {
    private static final IXWPFConverter<XHTMLOptions> INSTANCE = new XHTMLConverter();

    public static IXWPFConverter<XHTMLOptions> getInstance() {
        return INSTANCE;
    }

    @Override
    protected void doConvert(XWPFDocument document, OutputStream out, Writer writer, XHTMLOptions options) throws XWPFConverterException, IOException {
        IContentHandlerFactory factory = (options = options != null ? options : XHTMLOptions.getDefault()).getContentHandlerFactory();
        if (factory == null) {
            factory = DefaultContentHandlerFactory.INSTANCE;
        }
        ContentHandler contentHandler = factory.create(out, writer, options);
        this.convert(document, contentHandler, options);
    }

    public void convert(XWPFDocument document, ContentHandler contentHandler, XHTMLOptions options) throws XWPFConverterException, IOException {
        try {
            options = options != null ? options : XHTMLOptions.getDefault();
            XHTMLMapper mapper = new XHTMLMapper(document, contentHandler, options);
            mapper.start();
        }
        catch (Exception e) {
            throw new XWPFConverterException(e);
        }
    }
}

