/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.core.registry;

import fr.opensagres.xdocreport.core.discovery.IBaseDiscovery;
import fr.opensagres.xdocreport.core.internal.JDKServiceLoader;
import fr.opensagres.xdocreport.core.logging.LogUtils;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractRegistry<Discovery extends IBaseDiscovery> {
    private static final Logger LOGGER = LogUtils.getLogger(AbstractRegistry.class.getName());
    private boolean initialized;
    private final Class<Discovery> registryType;

    public AbstractRegistry(Class<Discovery> registryType) {
        this.registryType = registryType;
    }

    public void initialize() {
        this.initializeIfNeeded();
    }

    protected void initializeIfNeeded() {
        if (!this.initialized) {
            this.onStartInitialization();
            Iterator<Discovery> discoveries = JDKServiceLoader.lookupProviders(this.registryType, this.getClass().getClassLoader());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("discoveries found ? " + discoveries.hasNext());
            }
            while (discoveries.hasNext()) {
                IBaseDiscovery instance = (IBaseDiscovery)discoveries.next();
                try {
                    boolean result = this.registerInstance(instance);
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.fine("Registered Discovery instance  " + instance + " " + result);
                }
                catch (Throwable e) {
                    LOGGER.log(Level.WARNING, "Error while registration of Discovery instance  " + instance, e);
                }
            }
            this.onEndInitialization();
            this.initialized = true;
        }
    }

    protected void onStartInitialization() {
    }

    protected void onEndInitialization() {
    }

    protected abstract boolean registerInstance(Discovery var1);

    public final void dispose() {
        this.doDispose();
        this.initialized = false;
    }

    protected abstract void doDispose();
}

