/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.dump.java;

import fr.opensagres.xdocreport.converter.MimeMapping;
import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.document.IXDocReport;
import fr.opensagres.xdocreport.document.dump.AbstractDumper;
import fr.opensagres.xdocreport.document.dump.DumpHelper;
import fr.opensagres.xdocreport.document.dump.DumperKind;
import fr.opensagres.xdocreport.document.dump.DumperOptions;
import fr.opensagres.xdocreport.document.dump.IDumper;
import fr.opensagres.xdocreport.template.IContext;
import fr.opensagres.xdocreport.template.ITemplateEngine;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;

public class JavaMainDumper
extends AbstractDumper {
    private static final IDumper INSTANCE = new JavaMainDumper();

    public static IDumper getInstance() {
        return INSTANCE;
    }

    @Override
    protected void doDump(IXDocReport report, InputStream documentIn, IContext context, DumperOptions option, ITemplateEngine templateEngine, OutputStream out) throws IOException, XDocReportException {
        IContext dumpContext = DumpHelper.createDumpContext(report, templateEngine, option);
        String documentAsBinaryB4 = DumpHelper.toDocumentAsBinary64(report);
        dumpContext.put("document", documentAsBinaryB4);
        String xmlFields = null;
        FieldsMetadata metadata = report.getFieldsMetadata();
        if (metadata != null) {
            StringWriter xmlFieldsWriter = new StringWriter();
            metadata.saveXML(xmlFieldsWriter, false, true);
            xmlFields = xmlFieldsWriter.toString();
        }
        dumpContext.put("xmlFields", xmlFields);
        boolean upperCaseFirstChar = templateEngine.isFieldNameStartsWithUpperCase();
        String json = DumpHelper.toJSON(context, upperCaseFirstChar, true);
        dumpContext.put("json", json);
        DumpHelper.generate(templateEngine, "JavaMainDump", dumpContext, out);
    }

    @Override
    public MimeMapping getMimeMapping() {
        return null;
    }

    public static class JavaMainDumperOptions
    extends DumperOptions {
        public JavaMainDumperOptions() {
            super(DumperKind.JavaMain);
        }
    }
}

