/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.preprocessor.sax;

import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.template.formatter.Directive;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import org.xml.sax.Attributes;

public class RowBufferedRegion
extends BufferedElement {
    private String itemNameList;

    public RowBufferedRegion(BufferedElement parent, String uri, String localName, String name, Attributes attributes) {
        super(parent, uri, localName, name, attributes);
    }

    public void setLoopTemplateDirective(String startLoopDirective, String endLoopDirective) {
        this.setStartLoopDirective(startLoopDirective);
        this.setEndLoopDirective(endLoopDirective);
    }

    public void setStartLoopDirective(String startLoopDirective) {
        this.startTagElement.setBefore(startLoopDirective);
    }

    public void setEndLoopDirective(String endLoopDirective) {
        this.endTagElement.setAfter(endLoopDirective);
    }

    public boolean isLoopTemplateDirectiveInitilalized() {
        return StringUtils.isNotEmpty(this.getStartLoopDirective()) && StringUtils.isNotEmpty(this.getEndLoopDirective());
    }

    public void initializeLoopTemplateDirective(String itemNameList, IDocumentFormatter formatter, String startNoParse, String endNoParse) {
        this.itemNameList = itemNameList;
        this.setStartLoopDirective(Directive.formatDirective(formatter.getStartLoopDirective(itemNameList), startNoParse, endNoParse));
        this.setEndLoopDirective(Directive.formatDirective(formatter.getEndLoopDirective(itemNameList), startNoParse, endNoParse));
    }

    public String getItemNameList() {
        return this.itemNameList;
    }

    public String getStartLoopDirective() {
        return this.startTagElement.getBefore();
    }

    public String getEndLoopDirective() {
        return this.endTagElement.getAfter();
    }
}

