/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.textstyling.html;

import fr.opensagres.xdocreport.core.logging.LogUtils;
import fr.opensagres.xdocreport.core.utils.StringEscapeUtils;
import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.textstyling.AbstractTextStylingTransformer;
import fr.opensagres.xdocreport.document.textstyling.IDocumentHandler;
import fr.opensagres.xdocreport.document.textstyling.ITextStylingTransformer;
import fr.opensagres.xdocreport.document.textstyling.html.HTMLTextStylingContentHandler;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class HTMLTextStylingTransformer
extends AbstractTextStylingTransformer {
    public static final ITextStylingTransformer INSTANCE = new HTMLTextStylingTransformer();
    private static final String START_XML = "<?xml version=\"1.0\" ?>" + StringEscapeUtils.Entities.HTML40.generateDocType("entities") + "<root>";
    private static final String END_XML = "</root>";
    private static final Logger LOGGER = LogUtils.getLogger(HTMLTextStylingTransformer.class.getName());
    private static final String[] searchList = new String[]{"\r", "\n", "\t", "&nbsp;"};
    private static final String[] replacementList = new String[]{"", "", "", " "};

    @Override
    protected void doTransform(String content, IDocumentHandler documentHandler) throws Exception {
        content = this.generateXhtmlFromContent(content);
        String xml = StringUtils.replaceEach(content, searchList, replacementList);
        xml = START_XML + xml + END_XML;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(xml);
        }
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        xmlReader.setContentHandler(new HTMLTextStylingContentHandler(documentHandler));
        xmlReader.parse(new InputSource(new StringReader(xml)));
    }

    protected String generateXhtmlFromContent(String content) throws Exception {
        return content;
    }
}

