/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.xhtml.extension;

import fr.opensagres.odfdom.converter.core.utils.StringUtils;
import fr.opensagres.xdocreport.xhtml.extension.CSSStyleSheet;
import fr.opensagres.xdocreport.xhtml.extension.XHTMLPage;
import fr.opensagres.xdocreport.xhtml.extension.XHTMLPageContentBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class XHTMLPageBeforeBody
extends XHTMLPageContentBuffer {
    private final XHTMLPage page;
    private String bodyClass = null;

    public XHTMLPageBeforeBody(XHTMLPage page, int indent) {
        super(indent);
        this.page = page;
        super.setText("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        super.startElement("html");
        super.startElement("head");
        super.setText("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />");
    }

    @Override
    public void save(Writer out) throws IOException {
        super.save(out);
        CSSStyleSheet styleSheet = this.page.getCSSStyleSheet();
        if (styleSheet != null && !styleSheet.isEmpty()) {
            this.startElement("style", true, out, this.indent + 1);
            styleSheet.save(out);
            this.endElement("style", out, this.indent + 1);
        }
        this.endElement("head", out, this.indent);
        super.startElement("body", false, out, 1);
        if (StringUtils.isNotEmpty(this.bodyClass)) {
            out.write(" ");
            out.write("class");
            out.write("=\"");
            out.write(this.bodyClass);
            out.write("\"");
        }
        out.write(">");
    }

    @Override
    public void save(OutputStream out) throws IOException {
        super.save(out);
        CSSStyleSheet styleSheet = this.page.getCSSStyleSheet();
        if (styleSheet != null && !styleSheet.isEmpty()) {
            this.startElement("style", true, out, this.indent + 1);
            styleSheet.save(out);
            this.endElement("style", out, this.indent + 1);
        }
        this.endElement("head", out, 1);
        super.startElement("body", false, out, 1);
        if (StringUtils.isNotEmpty(this.bodyClass)) {
            out.write(" ".getBytes());
            out.write("class".getBytes());
            out.write("=\"".getBytes());
            out.write(this.bodyClass.getBytes());
            out.write("\"".getBytes());
        }
        out.write(">".getBytes());
    }

    public void setBodyClass(String bodyClass) {
        this.bodyClass = bodyClass;
    }
}

