/*
 * Decompiled with CFR 0.152.
 */
package org.quinto.swing.table.view;

import java.beans.PropertyChangeEvent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.log4j.Logger;
import org.quinto.swing.table.model.IModelFieldGroup;
import org.quinto.swing.table.model.ModelData;
import org.quinto.swing.table.model.ModelField;
import org.quinto.swing.table.model.ModelFieldGroup;
import org.quinto.swing.table.view.JBroTable;
import org.quinto.swing.table.view.JBroTableColumn;
import org.quinto.swing.table.view.JBroTableHeader;
import org.quinto.swing.table.view.JBroTableHeaderUI;

public class JBroTableColumnModel
extends DefaultTableColumnModel {
    private static final Logger LOGGER = Logger.getLogger(JBroTableColumnModel.class);
    private final List<List<JBroTableColumn>> columns = new ArrayList<List<JBroTableColumn>>();
    private final Map<String, JBroTableColumn> columnsIndex = new HashMap<String, JBroTableColumn>();
    private final JBroTable table;
    private final List<TableColumnModel> delegates = new ArrayList<TableColumnModel>();

    public JBroTableColumnModel(JBroTable table) {
        this.table = table;
    }

    public JBroTable getTable() {
        return this.table;
    }

    public void clear() {
        this.columns.clear();
        this.columnsIndex.clear();
        this.delegates.clear();
        while (this.getColumnCount() > 0) {
            super.removeColumn(this.getColumn(0));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (("width".equals(name) || "preferredWidth".equals(name)) && this.table.getAutoResizeMode() != 4 && e.getSource() instanceof JBroTableColumn && e.getNewValue() instanceof Integer && e.getOldValue() instanceof Integer) {
            if (((Integer)e.getNewValue()).intValue() == ((Integer)e.getOldValue()).intValue()) {
                return;
            }
            this.totalColumnWidth = -1;
            Object[] listeners = this.listenerList.getListenerList();
            WidthChangeEvent changeEvent = new WidthChangeEvent(this, (JBroTableColumn)e.getSource(), (Integer)e.getOldValue(), (Integer)e.getNewValue(), "preferredWidth".equals(name));
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TableColumnModelListener.class) continue;
                ((TableColumnModelListener)listeners[i + 1]).columnMarginChanged(changeEvent);
            }
        } else {
            super.propertyChange(e);
        }
    }

    public JBroTableColumn addColumn(IModelFieldGroup group, int x, int y) {
        JBroTableHeaderUI ui;
        ModelData data = this.table.getData();
        JBroTableColumn ret = new JBroTableColumn(x, y, group instanceof ModelField ? data.getIndexOfModelField(group.getIdentifier()) : data.getFieldsCount() + x + (y << 16), group.getRowspan());
        String id = group.getIdentifier();
        ret.setIdentifier(id);
        ret.setHeaderValue(group.getCaption());
        int colspan = group instanceof ModelField ? 1 : 0;
        ret.setColspan(colspan);
        int rowspan = group.getRowspan() - 1;
        while (this.columns.size() <= y + rowspan) {
            this.columns.add(new ArrayList());
        }
        for (int level = 0; level <= rowspan; ++level) {
            List<JBroTableColumn> levelColumns = this.columns.get(y + level);
            levelColumns.add(ret);
        }
        if (group instanceof ModelField) {
            super.addColumn(ret);
        }
        this.columnsIndex.put(id, ret);
        JBroTableColumn parent = this.getColumnParent(ret);
        while (parent != null) {
            parent.setColspan(parent.getColspan() + colspan);
            parent = this.getColumnParent(parent);
        }
        if (this.table.getTableHeader() instanceof JBroTableHeader && (ui = this.table.getTableHeader().getUI()) != null) {
            ui.updateModel();
        }
        return ret;
    }

    @Override
    public void addColumn(TableColumn column) {
        if (column instanceof JBroTableColumn) {
            JBroTableColumn dtc = (JBroTableColumn)column;
            this.addColumn(this.getModelField(dtc), dtc.getX(), dtc.getY());
        } else {
            String id;
            Object identifier = column.getIdentifier();
            if (identifier instanceof String) {
                if (identifier.equals(column.getHeaderValue())) {
                    column.setHeaderValue(0);
                    if (column.getIdentifier() instanceof Number) {
                        column.setHeaderValue(identifier);
                        identifier = null;
                    } else {
                        column.setHeaderValue(identifier);
                    }
                }
            } else {
                identifier = null;
            }
            if (identifier instanceof String) {
                id = (String)column.getIdentifier();
            } else {
                ModelField field = this.table.getData().getFields()[column.getModelIndex()];
                id = field.getIdentifier();
                if (this.columnsIndex.containsKey(id)) {
                    throw new IllegalArgumentException("An attempt to add a second column with the ID already used: " + column + " (" + column.getHeaderValue() + "), ID = " + field.getIdentifier() + ", model index = " + column.getModelIndex());
                }
            }
            int[] index = this.table.getData().getIndexOfModelFieldGroup(id);
            int x = index[0];
            if (x >= 0) {
                int y = index[1];
                this.addColumn(this.table.getData().getFieldGroups().get(y)[x], x, y);
            }
        }
    }

    public IModelFieldGroup getModelField(JBroTableColumn column) {
        return column == null ? null : this.table.getData().getFieldGroups().get(column.getY())[column.getX()];
    }

    public JBroTableColumn getTableColumn(IModelFieldGroup modelField) {
        return modelField == null ? null : this.columnsIndex.get(modelField.getIdentifier());
    }

    public JBroTableColumn getColumnParent(JBroTableColumn column) {
        if (column == null) {
            return null;
        }
        IModelFieldGroup modelField = this.getModelField(column);
        ModelFieldGroup parent = modelField.getParent();
        return this.getTableColumn(parent);
    }

    public Collection<JBroTableColumn> getColumnParents(JBroTableColumn column, boolean includeThis) {
        JBroTableColumn col;
        ArrayDeque<JBroTableColumn> ret = new ArrayDeque<JBroTableColumn>();
        JBroTableColumn jBroTableColumn = includeThis ? column : (col = column == null ? null : this.getColumnParent(column));
        while (col != null) {
            ret.addFirst(col);
            col = this.getColumnParent(col);
        }
        return ret;
    }

    public List<JBroTableColumn> getColumnChildren(JBroTableColumn column) {
        IModelFieldGroup modelField = this.getModelField(column);
        if (modelField instanceof ModelFieldGroup) {
            int kidsLevel = column.getY() + column.getRowspan();
            if (kidsLevel >= this.columns.size()) {
                return Collections.EMPTY_LIST;
            }
            ModelFieldGroup group = (ModelFieldGroup)modelField;
            ArrayList<JBroTableColumn> ret = new ArrayList<JBroTableColumn>(group.getColspan());
            HashSet<String> ids = new HashSet<String>(group.getColspan());
            for (IModelFieldGroup child : group.getChildren()) {
                ids.add(child.getIdentifier());
            }
            List<JBroTableColumn> childrenCandidates = this.columns.get(kidsLevel);
            for (JBroTableColumn childColumn : childrenCandidates) {
                if (!ids.contains(childColumn.getIdentifier())) continue;
                ret.add(childColumn);
            }
            return ret;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void removeColumn(TableColumn column) {
        if (column instanceof JBroTableColumn) {
            JBroTableColumn dtc = (JBroTableColumn)column;
            int colspan = dtc.getColspan();
            for (JBroTableColumn child : this.getColumnChildren(dtc)) {
                this.removeColumn(child);
            }
            JBroTableColumn parent = this.getColumnParent(dtc);
            for (int level = 0; level < dtc.getRowspan(); ++level) {
                this.columns.get(dtc.getY() + level).remove(dtc);
            }
            this.columnsIndex.remove(dtc.getIdentifier());
            if (this.getColumnChildren(parent).isEmpty()) {
                this.removeColumn(parent);
            } else {
                while (parent != null) {
                    parent.setColspan(parent.getColspan() - colspan);
                    parent = this.getColumnParent(parent);
                }
            }
        }
        super.removeColumn(column);
    }

    @Override
    public int getColumnIndex(Object identifier) {
        if (identifier instanceof String) {
            return this.getColumnIndex((String)identifier);
        }
        return super.getColumnIndex(identifier);
    }

    public int getColumnIndex(String identifier) {
        JBroTableColumn column = this.columnsIndex.get(identifier);
        return this.getColumnAbsoluteIndex(column);
    }

    public int getColumnAbsoluteIndex(JBroTableColumn column) {
        if (column == null) {
            return -1;
        }
        int ret = 0;
        for (JBroTableColumn col : this.columns.get(column.getY())) {
            if (column.equals(col)) {
                return ret;
            }
            ret += col.getColspan();
        }
        return -1;
    }

    public int getColumnRelativeIndex(JBroTableColumn column) {
        if (column == null) {
            return -1;
        }
        return this.columns.get(column.getY()).indexOf(column);
    }

    public JBroTableColumn getColumnAtAbsolutePosition(int xWithColspans, int level) {
        if (xWithColspans < 0 || level < 0) {
            return null;
        }
        int ret = 0;
        for (JBroTableColumn column : this.columns.get(level)) {
            if ((ret += column.getColspan()) <= xWithColspans) continue;
            return column;
        }
        return null;
    }

    public int getRelativePosition(int xWithColspans, int level) {
        if (xWithColspans < 0 || level < 0) {
            return -1;
        }
        int ret = 0;
        List<JBroTableColumn> levelColumns = this.columns.get(level);
        for (int x = 0; x < levelColumns.size(); ++x) {
            JBroTableColumn column = levelColumns.get(x);
            if ((ret += column.getColspan()) <= xWithColspans) continue;
            return x;
        }
        return levelColumns.size();
    }

    public int getAbsolutePosition(int x, int level) {
        if (x < 0 || level < 0) {
            return -1;
        }
        int ret = 0;
        for (JBroTableColumn column : this.columns.get(level)) {
            if (x == 0) break;
            --x;
            ret += column.getColspan();
        }
        return ret;
    }

    public JBroTableColumn getColumnAtRelativePosition(int x, int level) {
        return x < 0 || level < 0 ? null : this.columns.get(level).get(x);
    }

    public void moveColumn(JBroTableColumn column, int newIndex) {
        this.moveColumn(column, newIndex, true);
    }

    private void moveColumn(JBroTableColumn column, int newIndex, boolean checkBounds) {
        List<JBroTableColumn> columnChildren;
        int direction;
        int startIndex = this.getColumnIndex(column.getIdentifier());
        if (checkBounds && (startIndex < 0 || newIndex < 0) || startIndex == newIndex) {
            return;
        }
        int colspan = column.getColspan() - 1;
        int endIndex = startIndex + colspan;
        if (checkBounds && (endIndex >= this.getColumnCount() || newIndex >= this.getColumnCount())) {
            return;
        }
        IModelFieldGroup modelField = this.getModelField(column);
        if (modelField == null || !modelField.isManageable()) {
            return;
        }
        JBroTableColumn peerAtNewIndex = this.getColumnAtAbsolutePosition(newIndex, column.getY());
        if (peerAtNewIndex == column) {
            return;
        }
        modelField = this.getModelField(peerAtNewIndex);
        if (modelField == null || !modelField.isManageable()) {
            return;
        }
        JBroTableColumn parent = this.getColumnParent(column);
        if (parent != null) {
            int parentStartIndex = this.getColumnIndex(parent.getIdentifier());
            if (checkBounds && newIndex < parentStartIndex) {
                return;
            }
            int parentEndIndex = parentStartIndex + parent.getColspan() - 1;
            if (checkBounds && newIndex > parentEndIndex) {
                return;
            }
        }
        int n = direction = newIndex < startIndex ? 1 : -1;
        if (checkBounds) {
            newIndex = this.getColumnAbsoluteIndex(peerAtNewIndex);
            if (direction == -1) {
                newIndex = newIndex + peerAtNewIndex.getColspan() - 1;
            }
        }
        if ((columnChildren = this.getColumnChildren(column)).isEmpty()) {
            super.moveColumn(startIndex, newIndex);
        } else {
            if (direction == -1) {
                Collections.reverse(columnChildren);
            }
            int childNewIndex = newIndex;
            for (JBroTableColumn child : columnChildren) {
                this.moveColumn(child, childNewIndex, false);
                childNewIndex += direction * child.getColspan();
            }
        }
        for (int level = column.getY(); level < column.getY() + column.getRowspan(); ++level) {
            List<JBroTableColumn> levelColumns = this.columns.get(level);
            int newRelativeIndex = this.getRelativePosition(newIndex, level);
            levelColumns.remove(this.getRelativePosition(startIndex, level));
            levelColumns.add(newRelativeIndex, column);
        }
    }

    @Override
    public void moveColumn(int columnIndex, int newIndex) {
        JBroTableColumn column = this.getColumn(columnIndex);
        if (column instanceof JBroTableColumn) {
            this.moveColumn(column, newIndex);
        } else {
            super.moveColumn(columnIndex, newIndex);
        }
    }

    public int getWidth(JBroTableColumn column) {
        int ret = 0;
        for (JBroTableColumn child : this.getColumnChildren(column)) {
            ret += this.getWidth(child);
        }
        if (ret == 0) {
            ret = column.getWidth();
        }
        return ret;
    }

    public int getLevelsQuantity() {
        return this.columns.size();
    }

    public List<List<JBroTableColumn>> getColumnGroups() {
        return this.columns;
    }

    @Override
    public JBroTableColumn getColumn(int columnIndex) {
        return (JBroTableColumn)super.getColumn(columnIndex);
    }

    public JBroTableColumn getColumn(String identifier) {
        return this.columnsIndex.get(identifier);
    }

    public TableColumnModel getDelegate(int level) {
        if (level < 0 || level >= this.columns.size()) {
            return null;
        }
        while (this.delegates.size() <= level) {
            this.delegates.add(new DelegateColumnModel(this.delegates.size()));
        }
        return this.delegates.get(level);
    }

    private class DelegateColumnModel
    implements TableColumnModel {
        private final int level;

        public DelegateColumnModel(int level) {
            this.level = level;
        }

        @Override
        public void addColumn(TableColumn aColumn) {
            JBroTableColumnModel.this.addColumn(aColumn);
        }

        @Override
        public void removeColumn(TableColumn column) {
            JBroTableColumnModel.this.removeColumn(column);
        }

        @Override
        public void moveColumn(int columnIndex, int newIndex) {
            JBroTableColumnModel.this.moveColumn(JBroTableColumnModel.this.getAbsolutePosition(columnIndex, this.level), JBroTableColumnModel.this.getAbsolutePosition(newIndex, this.level));
        }

        @Override
        public void setColumnMargin(int newMargin) {
            JBroTableColumnModel.this.setColumnMargin(newMargin);
        }

        @Override
        public int getColumnCount() {
            return ((List)JBroTableColumnModel.this.columns.get(this.level)).size();
        }

        @Override
        public Enumeration<TableColumn> getColumns() {
            return Collections.enumeration((List)JBroTableColumnModel.this.columns.get(this.level));
        }

        @Override
        public int getColumnIndex(Object columnIdentifier) {
            if (!(columnIdentifier instanceof String)) {
                return -1;
            }
            JBroTableColumn column = (JBroTableColumn)JBroTableColumnModel.this.columnsIndex.get((String)columnIdentifier);
            if (column == null || column.getY() > this.level || column.getY() + column.getRowspan() <= this.level) {
                return -1;
            }
            return JBroTableColumnModel.this.getColumnRelativeIndex(column);
        }

        @Override
        public TableColumn getColumn(int columnIndex) {
            return JBroTableColumnModel.this.getColumnAtRelativePosition(columnIndex, this.level);
        }

        @Override
        public int getColumnMargin() {
            return JBroTableColumnModel.this.getColumnMargin();
        }

        @Override
        public int getColumnIndexAtX(int x) {
            if (x < 0) {
                return -1;
            }
            int i = 0;
            for (JBroTableColumn column : (List)JBroTableColumnModel.this.columns.get(this.level)) {
                int width = JBroTableColumnModel.this.getWidth(column);
                if ((x -= width) < 0) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        @Override
        public int getTotalColumnWidth() {
            return JBroTableColumnModel.this.getTotalColumnWidth();
        }

        @Override
        public void setColumnSelectionAllowed(boolean flag) {
            JBroTableColumnModel.this.setColumnSelectionAllowed(flag);
        }

        @Override
        public boolean getColumnSelectionAllowed() {
            return JBroTableColumnModel.this.getColumnSelectionAllowed();
        }

        @Override
        public int[] getSelectedColumns() {
            int[] ret = JBroTableColumnModel.this.getSelectedColumns();
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = JBroTableColumnModel.this.getAbsolutePosition(i, this.level);
            }
            return ret;
        }

        @Override
        public int getSelectedColumnCount() {
            return JBroTableColumnModel.this.getSelectedColumnCount();
        }

        @Override
        public void setSelectionModel(ListSelectionModel newModel) {
            JBroTableColumnModel.this.setSelectionModel(newModel);
        }

        @Override
        public ListSelectionModel getSelectionModel() {
            return JBroTableColumnModel.this.getSelectionModel();
        }

        @Override
        public void addColumnModelListener(TableColumnModelListener x) {
            JBroTableColumnModel.this.addColumnModelListener(x);
        }

        @Override
        public void removeColumnModelListener(TableColumnModelListener x) {
            JBroTableColumnModel.this.removeColumnModelListener(x);
        }
    }

    public static class WidthChangeEvent
    extends ChangeEvent {
        private final JBroTableColumn column;
        private final int oldWidth;
        private final int newWidth;
        private final boolean preferred;

        public WidthChangeEvent(Object source, JBroTableColumn column, int oldWidth, int newWidth, boolean preferred) {
            super(source);
            this.column = column;
            this.oldWidth = oldWidth;
            this.newWidth = newWidth;
            this.preferred = preferred;
        }

        public JBroTableColumn getColumn() {
            return this.column;
        }

        public int getOldWidth() {
            return this.oldWidth;
        }

        public int getNewWidth() {
            return this.newWidth;
        }

        public boolean isPreferred() {
            return this.preferred;
        }
    }
}

