/*
 * Decompiled with CFR 0.152.
 */
package Modelos.Dao;

import Modelos.Dao.EstudianteRetiradoDao;
import Modelos.Entidades.PeriodoInactividad;
import Servicios.ConexionSQLite;
import Util.MsgLog;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.lang.exception.ExceptionUtils;

public class EstudianteRetiradoDaoImpl
extends ConexionSQLite
implements EstudianteRetiradoDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PeriodoInactividad buscarPorAsignacion(Integer idAsignacion, Integer idParaleloCenso) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(PeriodoInactividad.class);
        PeriodoInactividad estudiante = null;
        try {
            estudiante = (PeriodoInactividad)run.query(conn, " SELECT  r.id ,  r.id_aplicacion as idAplicacion,  r.id_asignacion as idAsignacion,  r.retiro as retirado, r.estado as estado, r.id_usuario_creacion as idUsuarioCreacion  FROM periodo_inactividad r  WHERE  r.id_asignacion = ? and r.id_paralelo_censo=?  ", (ResultSetHandler)handler, new Object[]{idAsignacion, idParaleloCenso});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return estudiante;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PeriodoInactividad buscarPorId(Integer id) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(PeriodoInactividad.class);
        PeriodoInactividad estudiante = null;
        try {
            estudiante = (PeriodoInactividad)run.query(conn, " SELECT  r.id ,  r.id_aplicacion as idAplicacion,  r.id_paralelo_censo as idParaleloCenso,  r.id_asignacion as idAsignacion,  r.codigo_error as codigoError,  r.retiro as retirado, r.estado as estado, r.id_usuario_creacion as idUsuarioCreacion  FROM periodo_inactividad r  WHERE  r.id = ?  ", (ResultSetHandler)handler, new Object[]{id});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return estudiante;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarEstudianteRetirado(PeriodoInactividad estudianteRetirado) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " INSERT INTO periodo_inactividad(id_asignacion, id_paralelo_censo, retiro, estado, id_usuario_creacion)  values(?,?,?,?,?)";
        try {
            run.update(conn, sql, new Object[]{estudianteRetirado.getIdAsignacion(), estudianteRetirado.getIdParaleloCenso(), estudianteRetirado.getRetirado(), estudianteRetirado.getEstado(), estudianteRetirado.getIdUsuarioCreacion()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarEstudianteRetirado(PeriodoInactividad estudianteRetirado) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " UPDATE periodo_inactividad set  retiro = ?  where id_aplicacion= ? ";
        try {
            run.update(conn, sql, new Object[]{estudianteRetirado.getRetirado(), estudianteRetirado.getIdAplicacion()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarEstudianteRetiradoSincronizacion(PeriodoInactividad estudianteRetirado) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " UPDATE periodo_inactividad set id = ?,codigo_error = ? where id_aplicacion =? ";
        try {
            run.update(conn, sql, new Object[]{estudianteRetirado.getId(), estudianteRetirado.getCodigoError(), estudianteRetirado.getIdAplicacion()});
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PeriodoInactividad> obtenerPorParalelo(Integer idParalelo) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(PeriodoInactividad.class);
        List<PeriodoInactividad> estudiante = new ArrayList<PeriodoInactividad>();
        try {
            estudiante = (List)run.query(conn, " SELECT  r.id ,  r.id_aplicacion as idAplicacion,  r.id_asignacion as idAsignacion,  r.id_paralelo_censo as idParaleloCenso,  r.retiro as retirado, r.estado as estado, r.id_usuario_creacion as idUsuarioCreacion  FROM periodo_inactividad r  WHERE  r.id_paralelo_censo=?  ", (ResultSetHandler)handler, new Object[]{idParalelo});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return estudiante;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PeriodoInactividad> buscarTodo() {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(PeriodoInactividad.class);
        ArrayList<PeriodoInactividad> estudiante = new ArrayList();
        try {
            estudiante = (List)run.query(conn, " SELECT  r.id ,  r.id_aplicacion as idAplicacion,  r.id_asignacion as idAsignacion,  r.retiro as retirado, r.estado as estado, r.id_usuario_creacion as idUsuarioCreacion  FROM periodo_inactividad r ", (ResultSetHandler)handler);
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return estudiante;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarEstudianteRetirado(List<PeriodoInactividad> listaPeriodoInactividad) throws Exception {
        if (null != listaPeriodoInactividad && !listaPeriodoInactividad.isEmpty()) {
            try {
                String sql = " INSERT INTO periodo_inactividad(id_asignacion, id_paralelo_censo, retiro, estado, id_usuario_creacion)  values(?,?,?,?,?)";
                this.Conectar();
                PreparedStatement ps = this.getConexion().prepareStatement(sql);
                for (PeriodoInactividad periodo : listaPeriodoInactividad) {
                    if (null == periodo) continue;
                    ps.setInt(1, periodo.getIdAsignacion());
                    ps.setInt(2, periodo.getIdParaleloCenso());
                    ps.setObject(3, (Object)periodo.getRetirado(), 16);
                    ps.setObject(4, (Object)periodo.getEstado(), 4);
                    ps.setObject(5, (Object)periodo.getIdUsuarioCreacion(), 4);
                    ps.addBatch();
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (Exception e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
            finally {
                this.cerrar();
            }
        }
    }
}

