/*
 * Decompiled with CFR 0.152.
 */
package Vistas;

import Enumeradores.NivelEnum;
import Modelos.Dao.AsistenciaBachilleratoDaoImpl;
import Modelos.Dao.InstructorDao;
import Modelos.Dao.InstructorDaoImpl;
import Modelos.Dao.RegistroAnioLectivoDaoImpl;
import Modelos.Dao.ResgistroAnioLectivoDao;
import Modelos.Entidades.Asignacion;
import Modelos.Entidades.Instructor;
import Modelos.Entidades.RegistroAnioLectivo;
import Util.Grado;
import Util.Paralelo;
import Vistas.FuncionesAuxiliar;
import Vistas.model.JusticarAsistenciaTableJbroModel;
import Vistas.model.JustificarAsistenciaEGBTableJbroModel;
import com.toedter.calendar.JDateChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class VistaJustificarAsistencia
extends JPanel {
    private Integer codigoParaleloSeleccionado;
    private List<Asignacion> asignacion = new ArrayList<Asignacion>();
    private final JDateChooser dateChooserMesInicio = new JDateChooser();
    private final JDateChooser dateChooserMesFin = new JDateChooser();
    private final JComboBox<Grado> comboCurso = new JComboBox();
    private JComboBox<Paralelo> comboParalelo = new JComboBox();
    private final JPanel panelParalelo = new JPanel();
    private final AsistenciaBachilleratoDaoImpl asistenciaBachilleratoDaoImpl = new AsistenciaBachilleratoDaoImpl();
    private final ResgistroAnioLectivoDao registroAnioLectivoDao = new RegistroAnioLectivoDaoImpl();
    private final InstructorDao instructorDao = new InstructorDaoImpl();
    private RegistroAnioLectivo regAniLec;
    private Paralelo paraleloSeleccionado = new Paralelo();
    private String identificacion;
    private Instructor instructor;
    private Grado grado = new Grado();
    private Panel panel1;
    private JPanel panelCombo;
    private JPanel panelTablaAsistencia;

    public VistaJustificarAsistencia() {
        this.initComponents();
        Calendar maxDate = Calendar.getInstance();
        maxDate.setTime(new Date());
        JPanel panelAgrupadoComboLabel = new JPanel();
        panelAgrupadoComboLabel.setLayout(new BoxLayout(panelAgrupadoComboLabel, 3));
        JPanel panelGrado = new JPanel();
        JLabel etiquetaGrado = new JLabel("* Grado:");
        this.comboCurso.setPreferredSize(new Dimension(200, 25));
        panelGrado.add(etiquetaGrado);
        panelGrado.add(this.comboCurso);
        panelGrado.setBorder(new EmptyBorder(20, 54, 0, 0));
        panelGrado.setBackground(new Color(245, 245, 245));
        panelAgrupadoComboLabel.add(panelGrado);
        JLabel etiquetaParalelo = new JLabel("* Paralelo:");
        this.comboParalelo.setPreferredSize(new Dimension(200, 25));
        this.panelParalelo.add(etiquetaParalelo);
        this.panelParalelo.add(this.comboParalelo);
        this.panelParalelo.setBorder(new EmptyBorder(0, 43, 0, 0));
        this.panelParalelo.setBackground(new Color(245, 245, 245));
        panelAgrupadoComboLabel.add(this.panelParalelo);
        JPanel panelFechaInicio = new JPanel();
        this.dateChooserMesInicio.setPreferredSize(new Dimension(200, 25));
        this.dateChooserMesInicio.setDateFormatString("dd/MM/yyyy");
        this.dateChooserMesInicio.setMaxSelectableDate(maxDate.getTime());
        JLabel etiquetaMesInicial = new JLabel("* Fecha Inicio:");
        panelFechaInicio.add(etiquetaMesInicial);
        panelFechaInicio.add((Component)this.dateChooserMesInicio);
        panelFechaInicio.setBorder(new EmptyBorder(0, 25, 0, 0));
        panelFechaInicio.setBackground(new Color(245, 245, 245));
        panelAgrupadoComboLabel.add(panelFechaInicio);
        JPanel panelFechaFin = new JPanel();
        this.dateChooserMesFin.setPreferredSize(new Dimension(200, 25));
        this.dateChooserMesFin.setDateFormatString("dd/MM/yyyy");
        this.dateChooserMesFin.setMaxSelectableDate(maxDate.getTime());
        JLabel etiquetaMesFinal = new JLabel("* Fecha Fin:");
        panelFechaFin.add(etiquetaMesFinal);
        panelFechaFin.add((Component)this.dateChooserMesFin);
        panelFechaFin.setBorder(new EmptyBorder(0, 37, 40, 0));
        panelFechaFin.setBackground(new Color(245, 245, 245));
        panelAgrupadoComboLabel.add(panelFechaFin);
        this.panelCombo.setLayout(new BorderLayout());
        this.panelCombo.setBackground(new Color(245, 245, 245));
        this.panelCombo.add((Component)panelAgrupadoComboLabel, "Before");
        this.cargarEventoInicial();
        this.cargarEvento();
        this.panelTablaAsistencia.setLayout(new BorderLayout());
        JPanel panelInformacion = new JPanel();
        JPanel panelAuxiliar = new JPanel();
        JLabel informacionInicial = new JLabel("Estimado docente, seleccione un grado, paralelo y un rango de fechas. ");
        informacionInicial.setFont(new FuncionesAuxiliar().establecerFont(4));
        panelInformacion.add((Component)informacionInicial, "Center");
        panelInformacion.setBackground(new Color(252, 248, 227));
        panelInformacion.setBorder(new EmptyBorder(10, 10, 10, 10));
        panelAuxiliar.add(panelInformacion);
        panelAuxiliar.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.panelTablaAsistencia.add((Component)panelAuxiliar, "First");
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelCombo, "First");
        this.add((Component)this.panelTablaAsistencia, "Center");
    }

    private void initComponents() {
        this.panel1 = new Panel();
        this.panelTablaAsistencia = new JPanel();
        this.panelCombo = new JPanel();
        this.setPreferredSize(new Dimension(452, 402));
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelTablaAsistencia, "Center");
        this.add((Component)this.panelCombo, "First");
    }

    private void cargarEvento() {
        this.dateChooserMesFin.getDateEditor().addPropertyChangeListener(e -> {
            if ("date".equals(e.getPropertyName())) {
                this.getRangoSeleccionado();
                this.panelTablaAsistencia.updateUI();
                this.updateUI();
            }
        });
    }

    private void cargarEventoInicial() {
        this.dateChooserMesInicio.getDateEditor().addPropertyChangeListener(e -> {
            if ("date".equals(e.getPropertyName()) && this.dateChooserMesFin.getDate() != null) {
                this.getRangoSeleccionado();
                this.panelTablaAsistencia.updateUI();
                this.updateUI();
            }
        });
    }

    public void iniciarCarga(Integer idRegistrAnioLectivo, String identificacion, Instructor instructor) {
        this.identificacion = identificacion;
        this.instructor = instructor;
        this.cargarGrados();
        try {
            this.regAniLec = this.registroAnioLectivoDao.buscarPorId(idRegistrAnioLectivo);
            SimpleDateFormat formatoFecha = new SimpleDateFormat("yyy-MM-dd");
            Calendar minDate = Calendar.getInstance();
            minDate.setTime(formatoFecha.parse(this.regAniLec.getFechaInicioClases()));
            Calendar maxDate = Calendar.getInstance();
            maxDate.setTime(formatoFecha.parse(this.regAniLec.getFechaFinClases()));
            Calendar nowDate = Calendar.getInstance();
            nowDate.setTime(formatoFecha.parse(formatoFecha.format(new Date())));
            this.dateChooserMesInicio.setMinSelectableDate(minDate.getTime());
            if (maxDate.compareTo(nowDate) == 0 || maxDate.compareTo(nowDate) == -1) {
                this.dateChooserMesInicio.setMaxSelectableDate(maxDate.getTime());
            } else {
                this.dateChooserMesInicio.setMaxSelectableDate(nowDate.getTime());
            }
            this.dateChooserMesFin.setMinSelectableDate(minDate.getTime());
            if (maxDate.compareTo(nowDate) == 0 || maxDate.compareTo(nowDate) == -1) {
                this.dateChooserMesFin.setMaxSelectableDate(maxDate.getTime());
            } else {
                this.dateChooserMesFin.setMaxSelectableDate(nowDate.getTime());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.asignacion = new ArrayList<Asignacion>();
        }
    }

    private void cargarGrados() {
        Grado gradoSeleccione = new Grado();
        gradoSeleccione.setDescripcion("Seleccione...");
        this.comboCurso.addItem(gradoSeleccione);
        List<Grado> grados = this.instructorDao.obtenerGradosInstructor(this.identificacion);
        grados.forEach(item -> this.comboCurso.addItem((Grado)item));
        this.comboCurso.addActionListener(e -> {
            this.cargarParalelo();
            this.panelCombo.updateUI();
        });
    }

    private void cargarParalelo() {
        this.comboParalelo.removeAllItems();
        this.comboParalelo.updateUI();
        this.grado = (Grado)this.comboCurso.getSelectedItem();
        Paralelo paraleloSeleccione = new Paralelo();
        paraleloSeleccione.setDescripcion("Seleccione...");
        this.comboParalelo.addItem(paraleloSeleccione);
        List<Paralelo> paralelos = this.instructorDao.obtenerParalelosInstructor(this.grado.getCodigo(), this.identificacion);
        paralelos.forEach(item -> this.comboParalelo.addItem((Paralelo)item));
    }

    public void paraleloIngreso() {
    }

    public void getRangoSeleccionado() {
        this.paraleloSeleccionado = (Paralelo)this.comboParalelo.getSelectedItem();
        this.codigoParaleloSeleccionado = this.paraleloSeleccionado.getCodigo();
        this.panelTablaAsistencia.removeAll();
        if (this.dateChooserMesInicio.getDate().before(this.dateChooserMesFin.getDate())) {
            SimpleDateFormat formatoFecha = new SimpleDateFormat("dd/MM/yyyy");
            if (this.grado.getNemonico().equals(NivelEnum.BASICA_SUPERIOR.getNemonico()) || this.grado.getNemonico().equals(NivelEnum.TECNICO.getNemonico()) || this.grado.getNemonico().equals(NivelEnum.CIENCIAS.getNemonico()) || this.grado.getNemonico().equals(NivelEnum.INTERNACIONAL.getNemonico())) {
                this.asignacion = this.asistenciaBachilleratoDaoImpl.buscarInasistenciaPorParalelo(this.codigoParaleloSeleccionado);
                if (this.asignacion.isEmpty()) {
                    this.panelTablaAsistencia.removeAll();
                    JPanel panelInformacion = new JPanel();
                    JPanel panelAuxiliar = new JPanel();
                    JLabel informacionInicial = new JLabel("El paralelo no tiene faltas por justificar.");
                    informacionInicial.setFont(new FuncionesAuxiliar().establecerFont(4));
                    panelInformacion.add((Component)informacionInicial, "Center");
                    panelInformacion.setBackground(new Color(252, 248, 227));
                    panelInformacion.setBorder(new EmptyBorder(10, 10, 10, 10));
                    panelAuxiliar.add(panelInformacion);
                    panelAuxiliar.setBorder(new EmptyBorder(15, 15, 15, 15));
                    this.panelTablaAsistencia.add((Component)panelAuxiliar, "First");
                } else {
                    this.panelTablaAsistencia.add((Component)new JusticarAsistenciaTableJbroModel(this.codigoParaleloSeleccionado, this.asignacion, formatoFecha.format(this.dateChooserMesInicio.getDate()), formatoFecha.format(this.dateChooserMesFin.getDate()), this.instructor, this.grado).getScroll(), "Center");
                }
            } else {
                this.asignacion = this.asistenciaBachilleratoDaoImpl.buscarInasistenciaEGBPorParalelo(this.codigoParaleloSeleccionado);
                if (this.asignacion.isEmpty()) {
                    this.panelTablaAsistencia.removeAll();
                    JPanel panelInformacion = new JPanel();
                    JPanel panelAuxiliar = new JPanel();
                    JLabel informacionInicial = new JLabel("El paralelo no tiene faltas por justificar.");
                    informacionInicial.setFont(new FuncionesAuxiliar().establecerFont(4));
                    panelInformacion.add((Component)informacionInicial, "Center");
                    panelInformacion.setBackground(new Color(252, 248, 227));
                    panelInformacion.setBorder(new EmptyBorder(10, 10, 10, 10));
                    panelAuxiliar.add(panelInformacion);
                    panelAuxiliar.setBorder(new EmptyBorder(15, 15, 15, 15));
                    this.panelTablaAsistencia.add((Component)panelAuxiliar, "First");
                } else {
                    this.panelTablaAsistencia.add((Component)new JustificarAsistenciaEGBTableJbroModel(this.codigoParaleloSeleccionado, this.asignacion, formatoFecha.format(this.dateChooserMesInicio.getDate()), formatoFecha.format(this.dateChooserMesFin.getDate()), this.instructor).getScroll(), "Center");
                }
            }
        } else {
            JPanel panelInformacion = new JPanel();
            JPanel panelAuxiliar = new JPanel();
            JLabel informacionInicial = new JLabel("Rango incorrecto. La fecha inicial debe ser menor que la fecha final");
            informacionInicial.setFont(new FuncionesAuxiliar().establecerFont(4));
            panelInformacion.add((Component)informacionInicial, "Center");
            panelInformacion.setBackground(new Color(252, 248, 227));
            panelInformacion.setBorder(new EmptyBorder(10, 10, 10, 10));
            panelAuxiliar.add(panelInformacion);
            panelAuxiliar.setBorder(new EmptyBorder(15, 15, 15, 15));
            this.panelTablaAsistencia.add((Component)panelAuxiliar, "First");
        }
    }

    public Integer getCodigoParaleloSeleccionado() {
        return this.codigoParaleloSeleccionado;
    }

    public void setCodigoParaleloSeleccionado(Integer codigoParaleloSeleccionado) {
        this.codigoParaleloSeleccionado = codigoParaleloSeleccionado;
    }

    public Grado getGrado() {
        return this.grado;
    }

    public void setGrado(Grado grado) {
        this.grado = grado;
    }
}

