/*
 * Decompiled with CFR 0.152.
 */
package org.quinto.swing.table.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.TableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.quinto.swing.table.model.IModelFieldGroup;
import org.quinto.swing.table.model.ModelData;
import org.quinto.swing.table.model.ModelField;
import org.quinto.swing.table.model.Utils;
import org.quinto.swing.table.view.JBroTableColumn;
import org.quinto.swing.table.view.JBroTableColumnModel;
import org.quinto.swing.table.view.JBroTableHeader;
import org.quinto.swing.table.view.JBroTableHeaderUI;
import org.quinto.swing.table.view.JBroTableModel;
import org.quinto.swing.table.view.JBroTableUI;

public class JBroTable
extends JTable {
    private static final Logger LOGGER = Logger.getLogger(JBroTable.class);
    private Integer currentLevel;
    private JScrollPane scrollPane;
    private boolean scrollPaneFixed;
    private JBroTable masterTable;

    public JBroTable() {
        this((ModelData)null);
    }

    public JBroTable(ModelData data) {
        super(new JBroTableModel(data));
        super.setUI(new JBroTableUI());
        this.checkFieldWidths();
        this.refresh();
    }

    @Override
    public void setUI(TableUI ui) {
        JBroTableUI oldUI = this.getUI();
        if (oldUI != null || ui instanceof JBroTableUI) {
            super.setUI(ui);
            if (!(ui instanceof JBroTableUI)) {
                if (ui != null) {
                    ui.uninstallUI(this);
                }
                this.ui = oldUI;
                oldUI.setNoDefaults(true);
                oldUI.installUI(this);
                oldUI.setNoDefaults(false);
                this.firePropertyChange("UI", ui, oldUI);
                this.refresh();
            }
        }
    }

    @Override
    public JBroTableUI getUI() {
        return (JBroTableUI)super.getUI();
    }

    private void refresh() {
        if (this.getUI() != null) {
            this.getUI().clearCellImagesCache();
        }
        this.revalidate();
        this.repaint(this.getVisibleRect());
    }

    @Override
    public JBroTableModel getModel() {
        return (JBroTableModel)super.getModel();
    }

    public ModelData getData() {
        return this.getModel().getData();
    }

    private void checkFieldWidths() {
        ModelData data = this.getData();
        if (data == null) {
            return;
        }
        ModelField[] fields = data.getFields();
        if (fields == null) {
            return;
        }
        boolean changed = false;
        boolean tableIsJustAFixedPart = this.getMasterTable() != null;
        for (int i = this.columnModel.getColumnCount() - 1; i >= 0; --i) {
            TableColumn column = this.columnModel.getColumn(i);
            int modelIndex = column.getModelIndex();
            ModelField field = fields[modelIndex];
            if (field.isVisible() && field.isFixed() == tableIsJustAFixedPart) {
                Integer defaultWidth;
                String headerValue = field.getCaption();
                if (!Utils.equals(headerValue, column.getHeaderValue())) {
                    column.setHeaderValue(headerValue);
                    changed = true;
                }
                if ((defaultWidth = field.getDefaultWidth()) == null || defaultWidth < 0 || (defaultWidth = Integer.valueOf(Math.min(Math.max(defaultWidth, column.getMinWidth()), column.getMaxWidth()))).intValue() == column.getPreferredWidth()) continue;
                column.setPreferredWidth(defaultWidth);
                changed = true;
                continue;
            }
            changed = true;
            this.removeColumn(column);
        }
        if (changed) {
            this.tableStructureChanged();
        }
    }

    public void setData(ModelData data) {
        this.getModel().setData(data);
        this.checkFieldWidths();
        this.refresh();
    }

    @Override
    public void setModel(TableModel dataModel) {
        super.setModel(dataModel);
        this.checkFieldWidths();
        this.refresh();
    }

    public void reorderFields(String[] newFields) {
        Object field;
        ModelData data = this.getData();
        ModelField[] modelFields = data.getFields();
        LinkedHashMap<String, Integer> modelPositions = ModelField.getIndexes(modelFields);
        LinkedHashSet<Integer> iold = new LinkedHashSet<Integer>(modelFields.length);
        for (int i = 0; i < this.columnModel.getColumnCount(); ++i) {
            String[] column = this.columnModel.getColumn(i);
            iold.add(column.getModelIndex());
        }
        LinkedHashSet<Integer> inew = new LinkedHashSet<Integer>(modelFields.length);
        for (String fieldName : newFields) {
            if (fieldName == null) continue;
            Integer n = modelPositions.get(fieldName);
            if (n == null) {
                LOGGER.warn((Object)"reorderFields called on obsolete data model. Call setData first.");
                return;
            }
            inew.add(n);
        }
        ArrayList<Object> manageable = null;
        Iterator it = iold.iterator();
        while (it.hasNext()) {
            Integer pos = (Integer)it.next();
            if (inew.contains(pos)) continue;
            field = modelFields[pos];
            if (((ModelField)field).isManageable()) {
                it.remove();
                ((ModelField)field).setVisible(false);
                this.removeColumn(this.columnModel.getColumn(this.convertColumnIndexToView(pos)));
                continue;
            }
            ((ModelField)field).setManageable(true);
            if (manageable == null) {
                manageable = new ArrayList<Object>();
            }
            manageable.add(field);
            ArrayList<Integer> arrayList = new ArrayList<Integer>(inew.size() + 1);
            arrayList.addAll(inew);
            for (int i = 0; i < arrayList.size(); ++i) {
                Integer p = (Integer)arrayList.get(i);
                if (p.compareTo(pos) <= 0) continue;
                arrayList.add(i, pos);
                break;
            }
            if (arrayList.size() <= inew.size()) {
                arrayList.add(pos);
            }
            inew.clear();
            inew.addAll(arrayList);
        }
        it = inew.iterator();
        while (it.hasNext()) {
            Integer pos = (Integer)it.next();
            if (iold.contains(pos)) continue;
            field = modelFields[pos];
            if (((ModelField)field).isManageable()) {
                iold.add(pos);
                ((ModelField)field).setVisible(true);
                int[] nArray = data.getIndexOfModelFieldGroup(((ModelField)field).getIdentifier());
                this.addColumn(new JBroTableColumn(nArray[0], nArray[1], pos, ((ModelField)field).getRowspan()));
                continue;
            }
            it.remove();
        }
        int[] newVisibleIndexes = new int[inew.size()];
        int n = 0;
        for (Integer n2 : inew) {
            newVisibleIndexes[n++] = this.convertColumnIndexToView(n2);
        }
        for (int i = 0; i < newVisibleIndexes.length; ++i) {
            int n3;
            int n4 = newVisibleIndexes[i];
            while (n3 != i) {
                int posPos = newVisibleIndexes[n3];
                this.swapColumns(posPos, n3);
                newVisibleIndexes[n3] = n3;
                newVisibleIndexes[i] = posPos;
                n3 = posPos;
            }
        }
        if (manageable != null) {
            for (ModelField modelField : manageable) {
                modelField.setManageable(false);
            }
        }
        this.checkFieldWidths();
    }

    public void swapColumns(int first, int second) {
        if (first > second) {
            int t = first;
            first = second;
            second = t;
        } else if (first == second) {
            return;
        }
        this.moveColumn(first, second);
        this.moveColumn(second - 1, first);
    }

    public String getFieldsOrder() {
        ModelData data = this.getData();
        if (data == null) {
            return "";
        }
        ModelField[] fields = data.getFields();
        if (fields == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.columnModel.getColumnCount(); ++i) {
            result.append(fields[this.columnModel.getColumn(i).getModelIndex()].getIdentifier()).append(';');
        }
        return result.toString();
    }

    public void setFieldsOrder(String fieldsOrder) {
        if (fieldsOrder == null) {
            fieldsOrder = "";
        }
        this.reorderFields(fieldsOrder.split(";"));
    }

    public String getFieldsOrderAndWidths() {
        ModelData data = this.getData();
        if (data == null) {
            return "";
        }
        ModelField[] fields = data.getFields();
        if (fields == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.columnModel.getColumnCount(); ++i) {
            TableColumn column = this.columnModel.getColumn(i);
            if (result.length() != 0) {
                result.append(';');
            }
            result.append(fields[column.getModelIndex()].getIdentifier()).append(':').append(column.getPreferredWidth());
        }
        return result.toString();
    }

    public void setFieldsOrderAndWidths(String colWidths) {
        this.reorderFields(this.setColumnsWidths(colWidths, true));
    }

    public String getColumnsWidths() {
        StringBuilder result = new StringBuilder();
        TableColumnModel colModel = this.getColumnModel();
        ModelField[] fields = this.getData().getFields();
        for (int a = 0; a < fields.length; ++a) {
            int idx = this.convertColumnIndexToView(a);
            if (idx < 0) continue;
            if (result.length() != 0) {
                result.append(';');
            }
            result.append(fields[a].getIdentifier()).append(':').append(colModel.getColumn(idx).getPreferredWidth());
        }
        return result.toString();
    }

    public void setColumnsWidths(String colWidths) {
        this.setColumnsWidths(colWidths, false);
    }

    private String[] setColumnsWidths(String colWidths, boolean addIfAbsent) {
        if (colWidths == null || colWidths.isEmpty()) {
            return new String[0];
        }
        String[] widths = colWidths.split(";");
        if (widths == null || widths.length == 0) {
            return new String[0];
        }
        Pattern pattern = Pattern.compile("(\\S+):(\\d+)");
        ModelField[] fields = this.getData().getFields();
        LinkedHashMap<String, Integer> fieldIndexes = ModelField.getIndexes(fields);
        ArrayList<String> ret = new ArrayList<String>();
        for (String width : widths) {
            Matcher matcher = pattern.matcher(width);
            if (!matcher.matches()) continue;
            String colName = matcher.group(1);
            int colWidth = Integer.parseInt(matcher.group(2));
            Integer origIdx = fieldIndexes.get(colName);
            if (origIdx == null) continue;
            ret.add(colName);
            int fIdx = this.convertColumnIndexToView(origIdx);
            if (fIdx < 0) {
                if (!addIfAbsent) continue;
                this.addColumn(new TableColumn(origIdx));
                ModelField field = fields[origIdx];
                if (field.isManageable()) {
                    field.setVisible(true);
                }
                fIdx = this.convertColumnIndexToView(origIdx);
            }
            TableColumn column = this.columnModel.getColumn(fIdx);
            column.setPreferredWidth(colWidth);
        }
        return ret.toArray(new String[ret.size()]);
    }

    public int convertColumnIndexToView(String identifier) {
        return this.convertColumnIndexToView(this.getData().getIndexOfModelField(identifier));
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
    }

    public Object getValueAt(int row, String identifier) {
        return this.getData().getValue(row, identifier);
    }

    @Override
    protected JBroTableColumnModel createDefaultColumnModel() {
        return new JBroTableColumnModel(this);
    }

    @Override
    public void createDefaultColumnsFromModel() {
        TableColumnModel m = this.getColumnModel();
        if (!(m instanceof JBroTableColumnModel)) {
            super.createDefaultColumnsFromModel();
            return;
        }
        JBroTableColumnModel gcm = (JBroTableColumnModel)m;
        gcm.clear();
        ModelData data = this.getData();
        if (data == null) {
            return;
        }
        Iterable<IModelFieldGroup> groups = data.getAllFieldGroupsFromTop(true);
        for (IModelFieldGroup fieldGroup : groups) {
            int[] groupCoords = data.getIndexOfModelFieldGroup(fieldGroup.getIdentifier());
            int groupLevel = groupCoords[1];
            int groupX = groupCoords[0];
            gcm.addColumn(fieldGroup, groupX, groupLevel);
        }
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        TableColumnModel m = this.getColumnModel();
        if (!(m instanceof JBroTableColumnModel)) {
            return super.createDefaultTableHeader();
        }
        JBroTableColumnModel gcm = (JBroTableColumnModel)m;
        return new JBroTableHeader(gcm);
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
        int leadRow;
        if (this.getRowSelectionAllowed() && (leadRow = this.selectionModel.getLeadSelectionIndex()) >= 0 && leadRow < this.getRowCount()) {
            Rectangle first = this.getUI().getSpanCoordinates(e.getFirstIndex(), leadRow);
            Rectangle last = this.getUI().getSpanCoordinates(e.getLastIndex(), leadRow);
            Rectangle rectangle = first.x < 0 || first.y < 0 ? last : (first = last.x < 0 || last.y < 0 ? first : first.union(last));
            if (first.x >= 0 && first.width > 1) {
                e = new ListSelectionEvent(e.getSource(), first.x, first.x + first.width - 1, e.getValueIsAdjusting());
            }
        }
        super.columnSelectionChanged(e);
    }

    void setCurrentLevel(Integer currentLevel) {
        this.currentLevel = currentLevel;
    }

    @Override
    public TableColumnModel getColumnModel() {
        return this.currentLevel == null ? super.getColumnModel() : this.getTableHeader().getColumnModel(this.currentLevel);
    }

    @Override
    public JBroTableHeader getTableHeader() {
        return (JBroTableHeader)super.getTableHeader();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        this.getUI().onRowsSelected(e.getFirstIndex(), e.getLastIndex());
    }

    public JScrollPane getScrollPane() {
        if (this.scrollPane != null || this.getMasterTable() != null) {
            return this.scrollPane;
        }
        this.scrollPane = new JScrollPane(this);
        this.updateScrollPane();
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                JViewport viewport = JBroTable.this.scrollPane.getRowHeader();
                if (viewport == null) {
                    return;
                }
                Component comp = viewport.getView();
                if (!(comp instanceof JBroTable)) {
                    return;
                }
                JBroTable fixed = (JBroTable)comp;
                String property = e.getPropertyName();
                if ("selectionModel".equals(property)) {
                    fixed.setSelectionModel(JBroTable.this.getSelectionModel());
                } else if ("rowSorter".equals(property)) {
                    fixed.setRowSorter(JBroTable.this.getRowSorter());
                } else if ("model".equals(property)) {
                    fixed.setModel(JBroTable.this.getModel());
                } else if ("showVerticalLines".equals(property)) {
                    fixed.setShowVerticalLines(JBroTable.this.getShowVerticalLines());
                } else if ("rowMargin".equals(property)) {
                    fixed.setRowMargin(JBroTable.this.getRowMargin());
                } else if ("rowHeight".equals(property)) {
                    fixed.setRowHeight(JBroTable.this.getRowHeight());
                } else if ("fillsViewportHeight".equals(property)) {
                    fixed.setFillsViewportHeight(JBroTable.this.getFillsViewportHeight());
                }
            }
        });
        JScrollBar scrollBar = this.scrollPane.getVerticalScrollBar();
        if (scrollBar != null) {
            scrollBar.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    if (e.getAdjustmentType() == 5) {
                        JBroTable.this.getUI().setRowsScrolling(e.getValueIsAdjusting());
                    }
                }
            });
        }
        return this.scrollPane;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.getUI() != null) {
            this.getUI().clearCellImagesCache();
        }
        super.tableChanged(e);
        if (e == null || e.getFirstRow() == -1) {
            this.tableStructureChanged();
        }
    }

    private void tableStructureChanged() {
        if (this.getTableHeader() != null && this.getTableHeader().getUI() != null) {
            this.getTableHeader().getUI().clearCellImagesCache();
        }
        this.updateScrollPane();
        JBroTableHeader header = this.getTableHeader();
        if (header != null) {
            header.updateUI();
            header.repaint();
        }
    }

    @Override
    public void sorterChanged(RowSorterEvent e) {
        if (this.getTableHeader() != null && this.getTableHeader().getUI() != null) {
            this.getTableHeader().getUI().clearCellImagesCache();
        }
        super.sorterChanged(e);
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        Container parent;
        Set<String> spannedColumns;
        TableColumn col;
        if (!(e instanceof JBroTableColumnModel.WidthChangeEvent)) {
            super.columnMarginChanged(e);
            return;
        }
        JBroTableColumnModel.WidthChangeEvent we = (JBroTableColumnModel.WidthChangeEvent)e;
        JBroTableColumn column = we.getColumn();
        JBroTableHeader header = this.getTableHeader();
        TableColumnModel columnModel = header == null ? this.getColumnModel() : header.getColumnModel();
        Enumeration<TableColumn> cols = columnModel.getColumns();
        int x = 0;
        int idx = 0;
        while (cols.hasMoreElements() && (col = cols.nextElement()) != column) {
            x += col.getWidth();
            ++idx;
        }
        if (this.getUI() != null && (spannedColumns = this.getUI().getSpannedColumns()).contains(column.getIdentifier())) {
            TableColumn col2;
            while (idx >= 0 && spannedColumns.contains((String)(col2 = columnModel.getColumn(idx)).getIdentifier())) {
                x -= col2.getWidth();
                --idx;
            }
        }
        if (this.isEditing() && !this.getCellEditor().stopCellEditing()) {
            this.getCellEditor().cancelCellEditing();
        }
        Container container = parent = this.getParent() == null ? null : this.getParent().getParent();
        if (this.getAutoResizeMode() == 0 && header != null && header.getResizingColumn() == column && (parent == null || parent instanceof JScrollPane)) {
            if (column.getPreferredWidth() != column.getWidth()) {
                Dimension size = this.getPreferredSize();
                int oldW = column.getPreferredWidth();
                column.setPreferredWidth(column.getWidth());
                int newW = column.getPreferredWidth();
                size.width += newW - oldW;
                this.setPreferredSize(size);
                if (this.getParent() instanceof JViewport) {
                    ((JViewport)this.getParent()).setViewSize(size);
                }
                if (parent != null) {
                    JScrollPane scrollPane = (JScrollPane)parent;
                    scrollPane.getHorizontalScrollBar().getModel().setMaximum(size.width);
                }
            }
        } else {
            this.revalidate();
        }
        if (header == null) {
            this.repaint(x, 0, this.getWidth() - x, this.getHeight());
        } else if (columnModel instanceof JBroTableColumnModel) {
            header.repaintHeaderAndTable(x, 0, header.getWidth() - x);
            JBroTableHeaderUI ui = header.getUI();
            JBroTableColumnModel gcm = (JBroTableColumnModel)columnModel;
            while ((column = gcm.getColumnParent(column)) != null) {
                header.repaint(ui.getGroupHeaderBoundsFor(column));
            }
        } else {
            this.repaint(x, 0, this.getWidth() - x, this.getHeight());
            header.repaint();
        }
    }

    public JBroTable getMasterTable() {
        return this.masterTable;
    }

    public JBroTable getSlaveTable() {
        if (this.getScrollPane() == null) {
            return null;
        }
        JViewport viewport = this.getScrollPane().getRowHeader();
        if (viewport == null) {
            return null;
        }
        Component ret = viewport.getView();
        if (!(ret instanceof JBroTable)) {
            return null;
        }
        return (JBroTable)ret;
    }

    @Override
    public boolean hasFocus() {
        return this.masterTable == null ? super.hasFocus() : this.masterTable.hasFocus();
    }

    @Override
    public void setRowHeight(int row, int rowHeight) {
        super.setRowHeight(row, rowHeight);
        JBroTable fixed = this.getSlaveTable();
        if (fixed != null) {
            fixed.setRowHeight(row, rowHeight);
        }
    }

    private void updateScrollPane() {
        if (this.scrollPane == null || this.getMasterTable() != null) {
            return;
        }
        ModelData data = this.getData();
        boolean hasFixed = false;
        if (data != null) {
            for (ModelField field : data.getFields()) {
                if (!field.isFixed() || !field.isVisible()) continue;
                hasFixed = true;
                break;
            }
        }
        if (!hasFixed) {
            if (this.scrollPaneFixed && this.scrollPane.getRowHeader() != null) {
                this.scrollPane.setCorner("UPPER_LEFT_CORNER", null);
                this.scrollPane.setRowHeader(null);
                this.scrollPaneFixed = false;
            }
            return;
        }
        if (this.scrollPane.getRowHeader() == null) {
            this.scrollPaneFixed = true;
            JBroTable fixed = this.newInstance();
            fixed.masterTable = this;
            fixed.setModel(this.getModel());
            fixed.setSelectionModel(this.getSelectionModel());
            fixed.setRowSorter(this.getRowSorter());
            fixed.setAutoResizeMode(this.getAutoResizeMode());
            fixed.setFocusable(false);
            fixed.setUpdateSelectionOnSort(false);
            fixed.setFillsViewportHeight(this.getFillsViewportHeight());
            fixed.setRowHeight(this.getRowHeight());
            fixed.setRowMargin(this.getRowMargin());
            fixed.setShowVerticalLines(this.getShowVerticalLines());
            fixed.setPreferredScrollableViewportSize(fixed.getPreferredSize());
            MouseAdapter ma = new MouseAdapter(){
                private TableColumn column;
                private int columnWidth;
                private int pressedX;

                @Override
                public void mousePressed(MouseEvent e) {
                    JTableHeader header = (JTableHeader)e.getComponent();
                    TableColumnModel tcm = header.getColumnModel();
                    int columnIndex = tcm.getColumnIndexAtX(e.getX() - 3);
                    if (columnIndex == tcm.getColumnCount() - 1 && header.getCursor() == JBroTableHeaderUI.RESIZE_CURSOR && header.getTable().getAutoResizeMode() != 0) {
                        this.column = tcm.getColumn(columnIndex);
                        this.columnWidth = this.column.getWidth();
                        this.pressedX = e.getX();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.column = null;
                    this.columnWidth = 0;
                    this.pressedX = 0;
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    JTableHeader header = (JTableHeader)e.getComponent();
                    JTable table = header.getTable();
                    if (this.column != null) {
                        int width = this.columnWidth - this.pressedX + e.getX();
                        this.column.setPreferredWidth(width);
                    }
                    table.setPreferredScrollableViewportSize(table.getPreferredSize());
                }
            };
            JBroTableHeader header = fixed.getTableHeader();
            header.addMouseListener(ma);
            header.addMouseMotionListener(ma);
            this.scrollPane.setRowHeaderView(fixed);
            this.scrollPane.setCorner("UPPER_LEFT_CORNER", fixed.getTableHeader());
            this.scrollPane.getRowHeader().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JViewport viewport = (JViewport)e.getSource();
                    JBroTable.this.scrollPane.getVerticalScrollBar().setValue(viewport.getViewPosition().y);
                }
            });
        }
    }

    protected JBroTable newInstance() {
        return new JBroTable();
    }
}

