/*
 * Decompiled with CFR 0.152.
 */
package org.quinto.swing.table.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.quinto.swing.table.model.IModelFieldGroup;
import org.quinto.swing.table.model.LRUCache;
import org.quinto.swing.table.model.ModelData;
import org.quinto.swing.table.view.CustomTableHeaderRenderer;
import org.quinto.swing.table.view.JBroTable;
import org.quinto.swing.table.view.JBroTableColumn;
import org.quinto.swing.table.view.JBroTableColumnModel;
import org.quinto.swing.table.view.JBroTableHeader;
import org.quinto.swing.table.view.ReverseBorder;

public class JBroTableHeaderUI
extends BasicTableHeaderUI {
    private static final Logger LOGGER = Logger.getLogger(JBroTableHeaderUI.class);
    private static final Map<String, Boolean> EXISTING_PARENT_UIS = new HashMap<String, Boolean>();
    static final Cursor RESIZE_CURSOR = Cursor.getPredefinedCursor(11);
    private JBroTableColumn selectedColumn;
    private final JBroTable table;
    private List<ComponentUI> delegates;
    private List<CellRendererPane> rendererPanes;
    private List<JTableHeader> headers;
    private List<Integer> rowHeights;
    private boolean updating;
    private ComponentUI headerDelegate;
    private ReverseBorder lastBorder;
    private CustomTableHeaderRenderer customRenderer;
    private int[] heightsCache;
    private boolean cacheUsed = true;
    private final LRUCache<List<Object>, Image> cellImagesCache = new LRUCache(1000);

    public JBroTableHeaderUI(JBroTable table) {
        this.table = table;
        this.updateLookAndFeel();
    }

    void updateLookAndFeel() {
        if (this.updating) {
            return;
        }
        this.updating = true;
        if (this.header != null) {
            this.uninstallUI(this.header);
            this.installUI(this.header);
        }
        this.updating = false;
    }

    public void clearCellImagesCache() {
        if (!this.cellImagesCache.isEmpty()) {
            this.cellImagesCache.clear();
        }
    }

    public boolean isCacheUsed() {
        return this.cacheUsed;
    }

    public void setCacheUsed(boolean cacheUsed) {
        this.cacheUsed = cacheUsed;
        if (!cacheUsed) {
            this.clearCellImagesCache();
        }
    }

    public CustomTableHeaderRenderer getCustomRenderer() {
        return this.customRenderer;
    }

    public void setCustomRenderer(CustomTableHeaderRenderer customRenderer) {
        this.customRenderer = customRenderer;
    }

    public JBroTableHeader getHeader() {
        return (JBroTableHeader)this.header;
    }

    public JTableHeader getHeader(int level) {
        return this.headers.get(level);
    }

    private CellRendererPane getRendererPane(ComponentUI ui) {
        Object o = this.getField("rendererPane", ui);
        if (o instanceof CellRendererPane) {
            return (CellRendererPane)o;
        }
        return null;
    }

    private Object getField(String fieldName, ComponentUI ui) {
        if (ui == null) {
            return null;
        }
        try {
            Field field = BasicTableHeaderUI.class.getDeclaredField(fieldName);
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            Object ret = field.get(ui);
            if (!accessible) {
                field.setAccessible(false);
            }
            return ret;
        }
        catch (IllegalAccessException e) {
            LOGGER.error(null, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(null, (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            LOGGER.error(null, (Throwable)e);
        }
        catch (SecurityException e) {
            LOGGER.error(null, (Throwable)e);
        }
        return null;
    }

    private void setField(String fieldName, Object value, ComponentUI ui) {
        if (ui == null) {
            return;
        }
        try {
            Field field = BasicTableHeaderUI.class.getDeclaredField(fieldName);
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            field.set(ui, value);
            if (!accessible) {
                field.setAccessible(false);
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.error(null, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(null, (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            LOGGER.error(null, (Throwable)e);
        }
        catch (SecurityException e) {
            LOGGER.error(null, (Throwable)e);
        }
    }

    private Object call(String methodName, ComponentUI ui) {
        return this.call(methodName, null, ui, null);
    }

    private Object call(String methodName, Class[] parameters, ComponentUI ui, Object[] args) {
        return this.call(BasicTableHeaderUI.class, methodName, parameters, ui, args);
    }

    private Object call(Class clazz, String methodName, Class[] parameters, ComponentUI ui, Object[] args) {
        if (ui == null) {
            return null;
        }
        try {
            Method method = parameters == null ? clazz.getDeclaredMethod(methodName, new Class[0]) : clazz.getDeclaredMethod(methodName, parameters);
            boolean accessible = method.isAccessible();
            if (!accessible) {
                method.setAccessible(true);
            }
            return args == null ? method.invoke((Object)ui, new Object[0]) : method.invoke((Object)ui, args);
        }
        catch (IllegalAccessException e) {
            LOGGER.error(null, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(null, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error(null, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error(null, (Throwable)e);
            LOGGER.error(null, e.getCause());
        }
        return null;
    }

    @Override
    protected void rolloverColumnUpdated(int oldColumn, int newColumn) {
        for (ComponentUI delegate : this.delegates) {
            this.call("rolloverColumnUpdated", new Class[]{Integer.TYPE, Integer.TYPE}, delegate, new Object[]{oldColumn, newColumn});
        }
        super.rolloverColumnUpdated(oldColumn, newColumn);
    }

    private void rolloverColumnUpdated(int oldColumn, int newColumn, int level) {
        this.call("rolloverColumnUpdated", new Class[]{Integer.TYPE, Integer.TYPE}, this.delegates.get(level), new Object[]{oldColumn, newColumn});
    }

    @Override
    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
        for (ComponentUI delegate : this.delegates) {
            this.call("uninstallKeyboardActions", delegate);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        for (ComponentUI delegate : this.delegates) {
            this.call("uninstallListeners", delegate);
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        for (ComponentUI delegate : this.delegates) {
            this.call("uninstallDefaults", delegate);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        for (int i = 0; i < this.delegates.size(); ++i) {
            this.call("uninstallUI", new Class[]{JComponent.class}, this.delegates.get(i), new Object[]{this.headers.get(i)});
        }
        this.call("uninstallUI", new Class[]{JComponent.class}, this.headerDelegate, new Object[]{this.header});
        super.uninstallDefaults();
        super.uninstallListeners();
        super.uninstallKeyboardActions();
        this.header.removeAll();
        this.rendererPane = null;
        this.delegates.clear();
        this.headers.clear();
        this.rendererPanes.clear();
        this.clearCellImagesCache();
    }

    @Override
    protected void installKeyboardActions() {
        for (ComponentUI delegate : this.delegates) {
            this.call("installKeyboardActions", delegate);
        }
        super.installKeyboardActions();
    }

    @Override
    protected void installListeners() {
        for (ComponentUI delegate : this.delegates) {
            this.call("installListeners", delegate);
        }
        super.installListeners();
        for (MouseListener mouseListener : this.header.getMouseListeners()) {
            if (!(mouseListener instanceof BasicTableHeaderUI.MouseInputHandler)) continue;
            this.header.removeMouseListener(mouseListener);
        }
        for (EventListener eventListener : this.header.getMouseMotionListeners()) {
            if (!(eventListener instanceof BasicTableHeaderUI.MouseInputHandler)) continue;
            this.header.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
    }

    @Override
    protected void installDefaults() {
        for (ComponentUI delegate : this.delegates) {
            this.call("installDefaults", delegate);
        }
        super.installDefaults();
    }

    public void updateModel() {
        int levelsCnt;
        int n = levelsCnt = this.table.getData() == null ? 0 : this.table.getData().getFieldGroups().size();
        if (levelsCnt <= this.delegates.size()) {
            return;
        }
        JBroTableHeader header = this.getHeader();
        try {
            Class<? extends ComponentUI> uiClass = UIManager.getLookAndFeelDefaults().getUIClass("TableHeaderUI");
            Method createUImethod = uiClass.getMethod("createUI", JComponent.class);
            this.headerDelegate = (ComponentUI)createUImethod.invoke(null, header);
            this.call("installUI", new Class[]{JComponent.class}, this.headerDelegate, new Object[]{header});
            Arrays.fill(this.heightsCache, -1);
            for (int level = this.delegates.size(); level < levelsCnt; ++level) {
                ComponentUI delegate = (ComponentUI)createUImethod.invoke(null, header);
                this.delegates.add(delegate);
                JTableHeader levelHeader = header.createDelegateForLevel(level);
                this.call("installUI", new Class[]{JComponent.class}, delegate, new Object[]{levelHeader});
                this.headers.add(levelHeader);
                CellRendererPane delegateRendererPane = this.getRendererPane(delegate);
                this.rendererPanes.add(delegateRendererPane);
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.error(null, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error(null, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error(null, (Throwable)e);
            LOGGER.error(null, e.getCause());
        }
    }

    @Override
    public void installUI(JComponent c) {
        if (!(c instanceof JBroTableHeader)) {
            throw new IllegalArgumentException("Not a groupable header: " + c);
        }
        JBroTableHeader header = (JBroTableHeader)c;
        this.header = header;
        int levelsCnt = this.table.getData() == null ? 0 : this.table.getData().getFieldGroups().size();
        this.delegates = new ArrayList<ComponentUI>(levelsCnt);
        this.headers = new ArrayList<JTableHeader>(levelsCnt);
        this.rendererPanes = new ArrayList<CellRendererPane>(levelsCnt);
        if (this.heightsCache == null || this.heightsCache.length < levelsCnt) {
            this.heightsCache = new int[levelsCnt];
        }
        this.updateModel();
        super.installUI(c);
        SwingUtilities.updateComponentTreeUI(header);
        for (JTableHeader delegateHeader : this.headers) {
            SwingUtilities.updateComponentTreeUI(delegateHeader);
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        for (ComponentUI delegate : this.delegates) {
            this.call(ComponentUI.class, "update", new Class[]{Graphics.class, JComponent.class}, delegate, new Object[]{g, c});
        }
        super.update(g, c);
    }

    private TableCellRenderer getRenderer(TableColumn column) {
        TableCellRenderer renderer = column.getHeaderRenderer();
        if (renderer == null) {
            if (column instanceof JBroTableColumn) {
                JBroTableColumn dtc = (JBroTableColumn)column;
                renderer = this.headers.get(dtc.getY()).getDefaultRenderer();
            } else {
                renderer = this.header.getDefaultRenderer();
            }
        }
        return renderer;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        JBroTableColumnModel groupModel = this.getTableColumnModel();
        if (groupModel == null) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        Point left = clip.getLocation();
        Point right = new Point(clip.x + clip.width - 1, clip.y);
        int rMin = this.getRowAtPoint(left);
        int cMin = this.header.columnAtPoint(left);
        int cMax = this.header.columnAtPoint(right);
        int columnCount = groupModel.getColumnCount();
        if ((cMax < 0 || cMax >= columnCount) && cMin > (cMax = columnCount - 1)) {
            cMin = cMax;
        }
        if (cMin < 0) {
            cMin = 0;
        }
        JBroTableHeader header = this.getHeader();
        int headerHeight = this.calculateHeaderHeight();
        Rectangle cellRect = new Rectangle();
        JBroTableColumn draggedColumn = header.getDraggedGroup();
        ArrayList<JBroTableColumn> currentColumns = new ArrayList<JBroTableColumn>();
        ArrayList<Integer> coords = new ArrayList<Integer>();
        currentColumns.add(null);
        boolean draggedColumnMet = false;
        int calcStartXFrom = 0;
        for (int cIdx = cMin; cIdx <= cMax; ++cIdx) {
            JBroTableColumn column = groupModel.getColumn(cIdx);
            Collection<JBroTableColumn> columnParents = groupModel.getColumnParents(column, true);
            int level = 0;
            boolean addAbsent = false;
            boolean doNotPaintCells = draggedColumnMet && columnParents.contains(draggedColumn);
            boolean firstColumnParentsNeedToBeRepainted = cIdx == cMin && cMin > 0;
            for (JBroTableColumn columnParent : columnParents) {
                if (firstColumnParentsNeedToBeRepainted) {
                    int calcStartXTo = groupModel.getColumnAbsoluteIndex(columnParent);
                    for (int i = calcStartXFrom; i < calcStartXTo; ++i) {
                        JBroTableColumn col = groupModel.getColumn(i);
                        cellRect.x += col.getWidth();
                    }
                    calcStartXFrom = calcStartXTo;
                }
                if (!addAbsent) {
                    JBroTableColumn currentColumn = (JBroTableColumn)currentColumns.get(level);
                    if (columnParent != currentColumn) {
                        while (currentColumns.size() > level) {
                            currentColumns.remove(level);
                        }
                        while (coords.size() > level) {
                            coords.remove(level);
                        }
                        addAbsent = true;
                    }
                    ++level;
                }
                if (!addAbsent) continue;
                currentColumns.add(columnParent);
                cellRect.y = coords.isEmpty() ? 0 : (Integer)coords.get(coords.size() - 1);
                cellRect.width = this.getGroupWidth(columnParent);
                cellRect.height = columnParent == column ? headerHeight - cellRect.y : this.getGroupHeight(columnParent);
                if (draggedColumn == columnParent) {
                    g.setColor(header.getParent().getBackground());
                    g.fillRect(cellRect.x, cellRect.y, cellRect.width, headerHeight - cellRect.y);
                    draggedColumnMet = true;
                    doNotPaintCells = true;
                } else if (!(doNotPaintCells || columnParent.getY() < rMin && level < rMin)) {
                    this.paintCell(g, cellRect, columnParent);
                }
                if (columnParent == column) continue;
                cellRect.y += cellRect.height;
                coords.add(cellRect.y);
            }
            cellRect.x += cellRect.width;
        }
        if (draggedColumn != null) {
            Rectangle bounds = this.getGroupHeaderBoundsFor(draggedColumn);
            bounds.x += header.getDraggedDistance();
            this.paintWithChildren(g, groupModel, draggedColumn, bounds);
        }
        this.rendererPane.removeAll();
    }

    private void paintWithChildren(Graphics g, JBroTableColumnModel groupModel, JBroTableColumn parent, Rectangle initial) {
        Rectangle bounds = new Rectangle(initial);
        g.setColor(this.header.getParent().getBackground());
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        this.paintCell(g, bounds, parent);
        bounds.y += bounds.height;
        for (JBroTableColumn child : groupModel.getColumnChildren(parent)) {
            bounds.setSize(this.getGroupSize(child));
            this.paintWithChildren(g, groupModel, child, bounds);
            bounds.x += bounds.width;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void htmlHack(Graphics g, Component component, Rectangle cellRect) {
        String text = component instanceof JLabel ? ((JLabel)component).getText() : (component instanceof AbstractButton ? ((AbstractButton)component).getText() : (component instanceof JToolTip ? ((JToolTip)component).getTipText() : null));
        if (!BasicHTML.isHTMLString(text)) {
            return;
        }
        component.setBounds(cellRect);
        Graphics gg = g.create(-cellRect.width, -cellRect.height, cellRect.width, cellRect.height);
        try {
            component.paint(gg);
        }
        catch (NullPointerException e) {
        }
        finally {
            gg.dispose();
        }
    }

    private void paintCell(Graphics g, Component component, Rectangle cellRect) {
        JBroTableHeaderUI.htmlHack(g, component, cellRect);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    public boolean isLeaf(JBroTableColumn column) {
        return column.getY() + column.getRowspan() == this.headers.size();
    }

    private void paintCell(Graphics g, Rectangle cellRect, JBroTableColumn group) {
        Border border;
        TableCellRenderer renderer;
        boolean parentUIdeterminesRolloverColumnItself;
        List<Object> key;
        Object value = group.getHeaderValue();
        int row = group.getY();
        if (this.isCacheUsed()) {
            key = Arrays.asList(String.valueOf(value), row, group.getIdentifier(), group == this.getHeader().getDraggedGroup(), group == this.selectedColumn, cellRect.width, cellRect.height);
            Image image = (Image)this.cellImagesCache.get(key);
            if (image != null) {
                g.drawImage(image, cellRect.x, cellRect.y, null);
                return;
            }
        } else {
            key = null;
        }
        boolean rollover = (parentUIdeterminesRolloverColumnItself = JBroTableHeaderUI.hasParentUI(renderer = this.getRenderer(group))) ? group == this.getHeader().getDraggedGroup() : group == this.selectedColumn;
        this.table.setCurrentLevel(group.getY());
        JBroTableColumnModel tcm = this.getTableColumnModel();
        int viewColumn = tcm.getColumnRelativeIndex(group);
        Component comp = renderer.getTableCellRendererComponent(this.table, value, rollover, rollover, row, viewColumn);
        this.table.setCurrentLevel(null);
        if (!parentUIdeterminesRolloverColumnItself && comp instanceof JComponent && group == this.getHeader().getDraggedGroup() && (border = ((JComponent)comp).getBorder()) != null) {
            if (this.lastBorder == null || this.lastBorder.getDelegate() != border) {
                this.lastBorder = new ReverseBorder(border);
            }
            ((JComponent)comp).setBorder(this.lastBorder);
        }
        if (this.customRenderer != null) {
            IModelFieldGroup dataField = null;
            int modelColumn = group.getModelIndex();
            ModelData data = this.table.getData();
            if (data != null) {
                if (modelColumn >= 0 && data.getFields() != null && modelColumn < data.getFields().length) {
                    dataField = data.getFields()[modelColumn];
                } else {
                    IModelFieldGroup[] levelFields;
                    List<IModelFieldGroup[]> fields;
                    int[] coords = data.getIndexOfModelFieldGroup(String.valueOf(group.getIdentifier()));
                    int level = coords[1];
                    int col = coords[0];
                    if (level >= 0 && col >= 0 && (fields = data.getFieldGroups()).size() > level && (levelFields = fields.get(level)).length > col) {
                        dataField = levelFields[col];
                    }
                }
            }
            comp = this.customRenderer.getTableCellRendererComponent(comp, this.table, value, rollover, rollover, group == this.getHeader().getDraggedGroup(), row, viewColumn, modelColumn, dataField);
        }
        if (this.isCacheUsed()) {
            BufferedImage image = new BufferedImage(cellRect.width, cellRect.height, 1);
            Graphics gg = ((Image)image).getGraphics();
            gg.setColor(this.header.getParent().getBackground());
            gg.fillRect(0, 0, cellRect.width, cellRect.height);
            gg.translate(-cellRect.x, -cellRect.y);
            this.paintCell(gg, comp, cellRect);
            g.drawImage(image, cellRect.x, cellRect.y, null);
            this.cellImagesCache.put(key, image);
        } else {
            this.paintCell(g, comp, cellRect);
        }
    }

    public int getGroupHeight(JBroTableColumn group) {
        if (group == null) {
            return 0;
        }
        int height = 0;
        int from = group.getY();
        int to = from + group.getRowspan();
        for (int level = from; level < to; ++level) {
            height += this.getRowHeight(level);
        }
        return height;
    }

    public int getGroupWidth(JBroTableColumn group) {
        int width = 0;
        JBroTableColumnModel groupModel = this.getTableColumnModel();
        List<JBroTableColumn> children = groupModel.getColumnChildren(group);
        if (children.isEmpty()) {
            width = group == null ? 0 : group.getWidth();
        } else {
            for (JBroTableColumn column : children) {
                width += groupModel.getWidth(column);
            }
        }
        return width;
    }

    public Dimension getGroupSize(JBroTableColumn group) {
        return new Dimension(this.getGroupWidth(group), this.getGroupHeight(group));
    }

    private int calculateHeaderHeight() {
        int height = 0;
        int levelsCnt = this.table.getData() == null ? 0 : this.table.getData().getFieldGroups().size();
        for (int level = 0; level < levelsCnt; ++level) {
            height += this.getRowHeight(level);
        }
        return height;
    }

    public int getRowHeight(int level) {
        Integer height;
        int ret = this.heightsCache[level];
        if (ret >= 0) {
            return ret;
        }
        if (this.rowHeights != null && this.rowHeights.size() > level && (height = this.rowHeights.get(level)) != null) {
            this.heightsCache[level] = height;
            return this.heightsCache[level];
        }
        int mHeight = 0;
        JBroTableColumnModel groupModel = this.getTableColumnModel();
        for (int column = 0; column < groupModel.getColumnCount(); ++column) {
            JBroTableColumn parent = groupModel.getColumn(column);
            while (parent != null) {
                if (parent.getY() <= level && level < parent.getY() + parent.getRowspan()) {
                    TableCellRenderer renderer = this.headers.get(level).getDefaultRenderer();
                    Component comp = renderer.getTableCellRendererComponent(this.header.getTable(), parent.getHeaderValue(), false, false, -1, column);
                    mHeight = Math.max(mHeight, comp.getPreferredSize().height);
                }
                parent = groupModel.getColumnParent(parent);
            }
        }
        this.heightsCache[level] = mHeight;
        return this.heightsCache[level];
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int width = 0;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            JBroTableColumn aColumn = (JBroTableColumn)enumeration.nextElement();
            width += aColumn.getPreferredWidth();
        }
        return new Dimension(width, this.calculateHeaderHeight());
    }

    private void selectColumn(JBroTableColumn newSelectedColumn) {
        if (this.selectedColumn != newSelectedColumn) {
            int level;
            JBroTableColumn oldSelectedColumn = this.selectedColumn;
            this.selectedColumn = newSelectedColumn;
            Rectangle repaintRect = null;
            if (oldSelectedColumn != null) {
                repaintRect = this.getGroupHeaderBoundsFor(oldSelectedColumn);
            }
            if (newSelectedColumn != null) {
                Rectangle rect = this.getGroupHeaderBoundsFor(newSelectedColumn);
                if (repaintRect == null) {
                    repaintRect = rect;
                } else if (rect != null && repaintRect.intersects(rect)) {
                    repaintRect = repaintRect.union(rect);
                } else {
                    this.header.repaint(rect);
                }
            }
            if (repaintRect != null) {
                this.header.repaint(repaintRect);
            }
            JBroTableColumnModel columnModel = this.getTableColumnModel();
            int oldAbs = columnModel.getColumnAbsoluteIndex(oldSelectedColumn);
            int newAbs = columnModel.getColumnAbsoluteIndex(newSelectedColumn);
            if (oldSelectedColumn == null) {
                level = newSelectedColumn == null ? -1 : newSelectedColumn.getY();
            } else if (newSelectedColumn == null) {
                level = oldSelectedColumn.getY();
            } else {
                int oldY = oldSelectedColumn.getY();
                int oldYR = oldY + oldSelectedColumn.getRowspan() - 1;
                int newY = newSelectedColumn.getY();
                int newYR = newY + newSelectedColumn.getRowspan() - 1;
                if (oldY <= newY && newY <= oldYR) {
                    level = newY;
                } else if (newY <= oldY && oldY <= newYR) {
                    level = oldY;
                } else {
                    level = newY;
                    this.rolloverColumnUpdated(oldAbs, newAbs, oldY);
                }
            }
            if (level >= 0) {
                this.rolloverColumnUpdated(oldAbs, newAbs, level);
            }
            super.rolloverColumnUpdated(oldAbs, newAbs);
            if (oldSelectedColumn != null && newSelectedColumn != null && oldSelectedColumn.getY() != newSelectedColumn.getY()) {
                BasicTableHeaderUI parentUI = JBroTableHeaderUI.getParentUI(this.getRenderer(oldSelectedColumn));
                this.setField("rolloverColumn", -1, parentUI);
            }
            if (oldSelectedColumn != null || newSelectedColumn != null) {
                BasicTableHeaderUI parentUI = JBroTableHeaderUI.getParentUI(this.getRenderer(newSelectedColumn == null ? oldSelectedColumn : newSelectedColumn));
                this.setField("rolloverColumn", columnModel.getColumnRelativeIndex(newSelectedColumn), parentUI);
            }
        }
    }

    protected static boolean hasParentUI(TableCellRenderer renderer) {
        if (renderer == null) {
            return false;
        }
        Class<?> clazz = renderer.getClass();
        String className = clazz.getName();
        Boolean parentUIexists = EXISTING_PARENT_UIS.get(className);
        if (parentUIexists != null) {
            return parentUIexists;
        }
        JBroTableHeaderUI.getParentUI(renderer);
        parentUIexists = EXISTING_PARENT_UIS.get(className);
        if (parentUIexists != null) {
            return parentUIexists;
        }
        return false;
    }

    private static BasicTableHeaderUI getParentUI(TableCellRenderer renderer) {
        if (renderer == null) {
            return null;
        }
        Class<?> clazz = renderer.getClass();
        String className = clazz.getName();
        try {
            Boolean parentUIexists = EXISTING_PARENT_UIS.get(className);
            if (parentUIexists != null && !parentUIexists.booleanValue()) {
                return null;
            }
            Field field = clazz.getDeclaredField("this$0");
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            Object ret = field.get(renderer);
            if (!accessible) {
                field.setAccessible(false);
            }
            if (ret instanceof BasicTableHeaderUI) {
                EXISTING_PARENT_UIS.put(className, Boolean.TRUE);
                return (BasicTableHeaderUI)ret;
            }
        }
        catch (NoSuchFieldException e) {
        }
        catch (SecurityException e) {
            LOGGER.error(null, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(null, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error(null, (Throwable)e);
        }
        EXISTING_PARENT_UIS.put(className, Boolean.FALSE);
        return null;
    }

    private JBroTableColumnModel getTableColumnModel() {
        return (JBroTableColumnModel)this.header.getColumnModel();
    }

    private boolean canResize(Point p, JBroTableColumn column, JTableHeader header) {
        Rectangle bounds = this.getGroupHeaderBoundsFor(column);
        bounds.grow(-3, 0);
        return column != null && !bounds.contains(p) && header.getResizingAllowed() && column.getResizable();
    }

    private void updateRolloverColumn(MouseEvent e) {
        Point point = e.getPoint();
        if (this.getHeader().getDraggedGroup() == null && this.header.contains(point)) {
            JBroTableColumn column = this.getColumnAtPoint(point);
            this.selectColumn(column);
        }
    }

    public JBroTableColumn getColumnAtPoint(Point point) {
        int col = this.header.columnAtPoint(point);
        int level = this.getRowAtPoint(point);
        return this.getTableColumnModel().getColumnAtAbsolutePosition(col, level);
    }

    private int changeColumnWidth(JBroTableColumn resizingColumn, JTableHeader th, int oldWidth, int newWidth) {
        JTable table;
        Container container;
        resizingColumn.setWidth(newWidth);
        if (th.getParent() == null || !((container = th.getParent().getParent()) instanceof JScrollPane) || (table = th.getTable()) == null) {
            return 0;
        }
        if (!container.getComponentOrientation().isLeftToRight() && !th.getComponentOrientation().isLeftToRight()) {
            JViewport viewport = ((JScrollPane)container).getViewport();
            int viewportWidth = viewport.getWidth();
            int diff = newWidth - oldWidth;
            int newHeaderWidth = table.getWidth() + diff;
            Dimension tableSize = table.getSize();
            tableSize.width += diff;
            table.setSize(tableSize);
            if (newHeaderWidth >= viewportWidth && table.getAutoResizeMode() == 0) {
                Point p = viewport.getViewPosition();
                p.x = Math.max(0, Math.min(newHeaderWidth - viewportWidth, p.x + diff));
                viewport.setViewPosition(p);
                return diff;
            }
        }
        return 0;
    }

    private int viewIndexForColumn(JBroTableColumn aColumn) {
        JBroTableColumnModel cm = this.getHeader().getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    public void setRowHeight(int level, Integer height) {
        if (this.rowHeights == null) {
            this.rowHeights = new ArrayList<Integer>(level + 1);
        }
        while (this.rowHeights.size() <= level) {
            this.rowHeights.add(null);
        }
        this.rowHeights.set(level, height);
        this.heightsCache[level] = -1;
    }

    public Rectangle getGroupHeaderBoundsFor(JBroTableColumn group) {
        return new Rectangle(this.getGroupX(group), this.getGroupY(group), this.getGroupWidth(group), this.getGroupHeight(group));
    }

    public Point getGroupLocation(JBroTableColumn group) {
        return new Point(this.getGroupX(group), this.getGroupY(group));
    }

    public int getGroupY(JBroTableColumn group) {
        int level;
        int y = 0;
        int n = level = group == null ? -1 : group.getY() - 1;
        while (level >= 0) {
            y += this.getRowHeight(level);
            --level;
        }
        return y;
    }

    public int getGroupX(JBroTableColumn group) {
        JBroTableColumnModel columnModel = this.getTableColumnModel();
        int x = 0;
        int lastColumnIndex = group == null ? -1 : columnModel.getColumnIndex(group.getIdentifier());
        for (int index = 0; index < lastColumnIndex; ++index) {
            JBroTableColumn tc = columnModel.getColumn(index);
            x += tc.getWidth();
        }
        return x;
    }

    public int getRowAtPoint(Point point) {
        int y = 0;
        for (int level = 0; level < this.headers.size(); ++level) {
            if ((y += this.getRowHeight(level)) <= point.y) continue;
            return level;
        }
        return -1;
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private int mouseXOffset;
        private int prevMouseX;
        private Cursor otherCursor = RESIZE_CURSOR;

        @Override
        public void mouseClicked(MouseEvent e) {
            int columnIndex;
            RowSorter<? extends TableModel> sorter;
            JBroTable table;
            JBroTableHeader header = JBroTableHeaderUI.this.getHeader();
            if (!header.isEnabled()) {
                return;
            }
            Point point = e.getPoint();
            JBroTableColumn column = JBroTableHeaderUI.this.getColumnAtPoint(point);
            if (column == null) {
                return;
            }
            if (JBroTableHeaderUI.this.isLeaf(column) && e.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(e) && (table = header.getTable()) != null && (sorter = table.getRowSorter()) != null && (columnIndex = column.getModelIndex()) != -1) {
                sorter.toggleSortOrder(columnIndex);
                header.repaint();
            }
        }

        private JBroTableColumn getResizingColumn(Point p) {
            int row = JBroTableHeaderUI.this.getRowAtPoint(p);
            if (row == -1) {
                return null;
            }
            int column = this.getResizingColumnIndex(p);
            if (column == -1) {
                return null;
            }
            JBroTableColumnModel columnModel = JBroTableHeaderUI.this.getTableColumnModel();
            return columnModel.getColumnAtAbsolutePosition(column, row);
        }

        private int getResizingColumnIndex(Point p) {
            int row = JBroTableHeaderUI.this.getRowAtPoint(p);
            if (row == -1) {
                return -1;
            }
            int column = JBroTableHeaderUI.this.header.columnAtPoint(p);
            if (column == -1) {
                return -1;
            }
            JBroTableHeader header = JBroTableHeaderUI.this.getHeader();
            JBroTableColumnModel columnModel = JBroTableHeaderUI.this.getTableColumnModel();
            JBroTableColumn dtc = columnModel.getColumnAtAbsolutePosition(column, row);
            Rectangle r = JBroTableHeaderUI.this.getGroupHeaderBoundsFor(dtc);
            r.grow(-3, 0);
            if (r.contains(p)) {
                return -1;
            }
            int midPoint = r.x + r.width / 2;
            int columnIndex = header.getComponentOrientation().isLeftToRight() ? (p.x < midPoint ? column - 1 : column) : (p.x < midPoint ? column : column - 1);
            return columnIndex;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JBroTableColumn column;
            JBroTableColumn resizingColumn;
            if (!JBroTableHeaderUI.this.header.isEnabled()) {
                return;
            }
            JBroTableHeaderUI.this.header.setDraggedColumn(null);
            JBroTableHeaderUI.this.header.setResizingColumn(null);
            JBroTableHeaderUI.this.header.setDraggedDistance(0);
            Point point = e.getPoint();
            int idx = this.getResizingColumnIndex(point);
            JBroTableColumn jBroTableColumn = resizingColumn = idx < 0 ? null : JBroTableHeaderUI.this.getTableColumnModel().getColumn(idx);
            if (JBroTableHeaderUI.this.canResize(point, resizingColumn, JBroTableHeaderUI.this.header)) {
                JBroTableHeaderUI.this.header.setResizingColumn(resizingColumn);
                this.mouseXOffset = JBroTableHeaderUI.this.header.getComponentOrientation().isLeftToRight() ? point.x - JBroTableHeaderUI.this.getGroupWidth(resizingColumn) : point.x + JBroTableHeaderUI.this.getGroupWidth(resizingColumn);
            } else if (JBroTableHeaderUI.this.header.getReorderingAllowed() && (column = JBroTableHeaderUI.this.getColumnAtPoint(point)) != null) {
                JBroTableHeaderUI.this.header.setDraggedColumn(column);
                this.prevMouseX = this.mouseXOffset = point.x;
                JBroTableHeaderUI.this.selectColumn(null);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!JBroTableHeaderUI.this.header.isEnabled()) {
                return;
            }
            Point point = e.getPoint();
            JBroTableColumn selectedColumn = JBroTableHeaderUI.this.getColumnAtPoint(point);
            JBroTableHeaderUI.this.selectColumn(selectedColumn);
            JBroTableColumn resizingColumn = this.getResizingColumn(point);
            Cursor cursor = JBroTableHeaderUI.this.header.getCursor();
            if (JBroTableHeaderUI.this.canResize(point, resizingColumn, JBroTableHeaderUI.this.header)) {
                if (cursor != RESIZE_CURSOR) {
                    JBroTableHeaderUI.this.header.setCursor(RESIZE_CURSOR);
                    this.otherCursor = cursor;
                }
            } else if (cursor == RESIZE_CURSOR) {
                JBroTableHeaderUI.this.header.setCursor(this.otherCursor == RESIZE_CURSOR ? null : this.otherCursor);
            }
            JBroTableHeaderUI.this.updateRolloverColumn(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            JBroTableHeader header = JBroTableHeaderUI.this.getHeader();
            if (!header.isEnabled()) {
                return;
            }
            int mouseX = e.getX();
            JBroTableColumn resizingColumn = header.getResizingColumn();
            JBroTableColumn draggedColumn = header.getDraggedGroup();
            boolean headerLeftToRight = header.getComponentOrientation().isLeftToRight();
            JBroTableColumnModel groupModel = JBroTableHeaderUI.this.getTableColumnModel();
            if (draggedColumn != null) {
                Set<String> spannedColumns;
                int x;
                int width;
                boolean calcNewPosition = true;
                int draggedDistance = mouseX - this.mouseXOffset;
                boolean moved = false;
                int minCol = Integer.MAX_VALUE;
                int maxCol = Integer.MIN_VALUE;
                JBroTableColumn parent = null;
                while (calcNewPosition) {
                    IModelFieldGroup modelField;
                    IModelFieldGroup modelField2;
                    int startIndex = groupModel.getColumnAbsoluteIndex(draggedColumn);
                    int endIndex = startIndex + draggedColumn.getColspan() - 1;
                    int direction = draggedDistance < 0 ? -1 : 1;
                    int newColumnIndex = direction < 0 ? startIndex - 1 : endIndex + 1;
                    boolean shouldMove = true;
                    if (newColumnIndex < 0) {
                        newColumnIndex = 0;
                        shouldMove = false;
                    } else if (newColumnIndex >= groupModel.getColumnCount()) {
                        newColumnIndex = groupModel.getColumnCount() - 1;
                        shouldMove = false;
                    }
                    if (shouldMove && (modelField2 = groupModel.getModelField(draggedColumn)) != null && !modelField2.isManageable()) {
                        newColumnIndex = direction < 0 ? startIndex : endIndex;
                        shouldMove = false;
                    }
                    if (shouldMove && (parent = groupModel.getColumnParent(draggedColumn)) != null) {
                        int parentStartIndex = groupModel.getColumnAbsoluteIndex(parent);
                        int parentEndIndex = parentStartIndex + parent.getColspan() - 1;
                        if (newColumnIndex < parentStartIndex) {
                            newColumnIndex = parentStartIndex;
                            shouldMove = false;
                        } else if (newColumnIndex > parentEndIndex) {
                            newColumnIndex = parentEndIndex;
                            shouldMove = false;
                        }
                    }
                    JBroTableColumn newGroup = null;
                    if (shouldMove && (modelField = groupModel.getModelField(newGroup = groupModel.getColumnAtAbsolutePosition(newColumnIndex, draggedColumn.getY()))) != null && !modelField.isManageable()) {
                        shouldMove = false;
                    }
                    if (shouldMove) {
                        width = JBroTableHeaderUI.this.getGroupWidth(newGroup);
                        int groupStartIndex = groupModel.getColumnAbsoluteIndex(newGroup);
                        int groupEndIndex = newGroup.getColspan() + groupStartIndex - 1;
                        newColumnIndex = direction < 0 ? groupStartIndex : groupEndIndex;
                        if (Math.abs(draggedDistance) > width / 2) {
                            if (newColumnIndex >= 0 && newColumnIndex < groupModel.getColumnCount()) {
                                this.mouseXOffset += direction * width;
                                draggedDistance = mouseX - this.mouseXOffset;
                                groupModel.moveColumn(draggedColumn, newColumnIndex);
                                moved = true;
                            } else {
                                calcNewPosition = false;
                            }
                        } else {
                            calcNewPosition = false;
                        }
                    } else {
                        draggedDistance = 0;
                        calcNewPosition = false;
                    }
                    if (minCol > startIndex) {
                        minCol = startIndex;
                    }
                    if (minCol > newColumnIndex) {
                        minCol = newColumnIndex;
                    }
                    if (maxCol < startIndex) {
                        maxCol = startIndex;
                    }
                    if (maxCol >= newColumnIndex) continue;
                    maxCol = newColumnIndex;
                }
                header.setDraggedDistance(draggedDistance);
                int y = JBroTableHeaderUI.this.getGroupY(draggedColumn);
                int diff = this.prevMouseX - mouseX;
                int addition = JBroTableHeaderUI.this.table.getShowVerticalLines() ? 1 : 0;
                int draggedWidth = JBroTableHeaderUI.this.getGroupWidth(draggedColumn) + Math.abs(diff) + addition;
                int draggedX = JBroTableHeaderUI.this.getGroupX(draggedColumn) + draggedDistance + Math.min(0, diff) - addition;
                if (JBroTableHeaderUI.this.isCacheUsed()) {
                    if ((diff *= 2) > 0) {
                        if (diff > 30) {
                            diff = 30;
                        }
                        draggedX -= diff;
                        draggedWidth += diff;
                    } else {
                        if (diff < -30) {
                            diff = -30;
                        }
                        draggedWidth -= diff;
                    }
                }
                if (moved) {
                    int draggedEnd;
                    int i;
                    if (maxCol >= 0) {
                        if ((maxCol += draggedColumn.getColspan() - 1) >= groupModel.getColumnCount() && minCol > (maxCol = groupModel.getColumnCount() - 1)) {
                            minCol = maxCol;
                        }
                    } else {
                        minCol = 0;
                        maxCol = groupModel.getColumnCount() - 1;
                    }
                    x = 0;
                    for (i = 0; i < minCol; ++i) {
                        x += groupModel.getColumn(i).getWidth();
                    }
                    width = 0;
                    for (i = minCol; i <= maxCol; ++i) {
                        width += groupModel.getColumn(i).getWidth();
                    }
                    int end = x + width;
                    if (x > draggedX) {
                        x = draggedX;
                    }
                    if (end < (draggedEnd = draggedX + draggedWidth)) {
                        end = draggedEnd;
                    }
                    width = end - x;
                } else {
                    x = draggedX;
                    width = draggedWidth;
                }
                if (parent != null) {
                    int end;
                    int px = JBroTableHeaderUI.this.getGroupX(parent);
                    int pw = JBroTableHeaderUI.this.getGroupWidth(parent);
                    int pend = px + pw;
                    if (x < px) {
                        width -= px - x;
                        x = px;
                    }
                    if ((end = x + width) > pend) {
                        width -= end - pend;
                    }
                }
                if (!(spannedColumns = JBroTableHeaderUI.this.table.getUI().getSpannedColumns()).isEmpty()) {
                    JBroTableColumn col;
                    int i;
                    int tableX = x;
                    int tableWidth = width;
                    int cMin = groupModel.getColumnIndexAtX(x);
                    int cMax = groupModel.getColumnIndexAtX(x + width - 1);
                    int cCnt = groupModel.getColumnCount();
                    boolean containsSpans = false;
                    int n = i = cMin < 0 ? cCnt : cMin;
                    while (i <= cMax && i < cCnt) {
                        col = groupModel.getColumn(i);
                        if (spannedColumns.contains(col.getIdentifier())) {
                            containsSpans = true;
                            break;
                        }
                        ++i;
                    }
                    if (containsSpans) {
                        for (i = cMin - 1; i >= 0 && spannedColumns.contains((col = groupModel.getColumn(i)).getIdentifier()); --i) {
                            if (i == cMin - 1) {
                                int gx = JBroTableHeaderUI.this.getGroupX(col);
                                tableWidth += tableX - gx;
                                tableX = gx;
                                continue;
                            }
                            tableX -= col.getWidth();
                            tableWidth += col.getWidth();
                        }
                        int n2 = i = cMax < 0 ? cCnt : cMax + 1;
                        while (i < cCnt && spannedColumns.contains((col = groupModel.getColumn(i)).getIdentifier())) {
                            tableWidth = i == cMax + 1 ? JBroTableHeaderUI.this.getGroupX(col) + col.getWidth() - tableX : (tableWidth += col.getWidth());
                            ++i;
                        }
                        if (tableWidth > width) {
                            x = tableX;
                            width = tableWidth;
                            y = 0;
                        }
                    }
                }
                if (width > 0) {
                    header.repaintHeaderAndTable(x, y, width);
                }
                this.prevMouseX = mouseX;
            } else if (resizingColumn != null) {
                int oldWidth = JBroTableHeaderUI.this.getGroupWidth(resizingColumn);
                int newWidth = headerLeftToRight ? mouseX - this.mouseXOffset : this.mouseXOffset - mouseX;
                this.mouseXOffset += JBroTableHeaderUI.this.changeColumnWidth(resizingColumn, header, oldWidth, newWidth);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JBroTableHeader header = JBroTableHeaderUI.this.getHeader();
            if (!header.isEnabled()) {
                return;
            }
            JBroTableColumn draggedColumn = header.getDraggedGroup();
            int y = JBroTableHeaderUI.this.getGroupY(draggedColumn);
            int addition = JBroTableHeaderUI.this.table.getShowVerticalLines() ? 1 : 0;
            int draggedDistance = header.getDraggedDistance();
            int draggedWidth = JBroTableHeaderUI.this.getGroupWidth(draggedColumn) + addition;
            int draggedX = JBroTableHeaderUI.this.getGroupX(draggedColumn) - addition;
            header.setDraggedDistance(0);
            header.setResizingColumn(null);
            header.setDraggedColumn(null);
            JBroTableHeaderUI.this.table.getUI().clearDraggedAreaCache();
            JBroTableHeaderUI.this.updateRolloverColumn(e);
            if (draggedDistance > draggedWidth || draggedDistance < -draggedWidth) {
                header.repaintHeaderAndTable(draggedX + draggedDistance, y, draggedWidth);
                header.repaintHeaderAndTable(draggedX, y, draggedWidth);
            } else if (draggedDistance < 0) {
                header.repaintHeaderAndTable(draggedX + draggedDistance, y, draggedWidth - draggedDistance);
            } else {
                header.repaintHeaderAndTable(draggedX, y, draggedWidth + draggedDistance);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!JBroTableHeaderUI.this.header.isEnabled()) {
                return;
            }
            JBroTableHeaderUI.this.updateRolloverColumn(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!JBroTableHeaderUI.this.header.isEnabled()) {
                return;
            }
            JBroTableHeaderUI.this.selectColumn(null);
        }
    }
}

