/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor;

import datechooser.beans.editor.descriptor.DescriptionManager;
import datechooser.beans.locale.LocaleUtils;
import datechooser.view.WeekDaysStyle;
import java.beans.PropertyEditorSupport;

public class WeekDaysStyleEditor
extends PropertyEditorSupport {
    private String[] tagsText = new String[]{LocaleUtils.getEditorLocaleString("WeekStyle_Full"), LocaleUtils.getEditorLocaleString("WeekStyle_Normal"), LocaleUtils.getEditorLocaleString("WeekStyle_Short")};
    private WeekDaysStyle[] tags = new WeekDaysStyle[]{WeekDaysStyle.FULL, WeekDaysStyle.NORMAL, WeekDaysStyle.SHORT};

    private int getValueIndex() {
        if (this.getValue() == null) {
            return -1;
        }
        WeekDaysStyle style = (WeekDaysStyle)((Object)this.getValue());
        switch (style) {
            case FULL: {
                return 0;
            }
            case NORMAL: {
                return 1;
            }
            case SHORT: {
                return 2;
            }
        }
        return -1;
    }

    public String[] getTags() {
        return this.tagsText;
    }

    public String getAsText() {
        return this.tagsText[this.getValueIndex()];
    }

    public void setAsText(String text) throws IllegalArgumentException {
        for (int i = 0; i < this.tagsText.length; ++i) {
            if (!this.tagsText[i].equals(text)) continue;
            this.setValue((Object)this.tags[i]);
            return;
        }
        throw new IllegalArgumentException();
    }

    public String getJavaInitializationString() {
        return DescriptionManager.describeJava(this.getValue(), WeekDaysStyle.class);
    }
}

