/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.cell;

import datechooser.beans.editor.cell.CellDraw;
import datechooser.beans.editor.utils.SpinPane;
import datechooser.beans.locale.LocaleUtils;
import datechooser.view.appearance.CellAppearance;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class CellPreview
extends JPanel {
    private static final int MIN_SIZE = 25;
    private CellDraw drawer;
    private SpinnerNumberModel width;
    private SpinnerNumberModel height;
    private boolean autoEdit;

    public CellPreview(CellAppearance look) {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createEtchedBorder()));
        this.drawer = new CellDraw(look);
        this.setAutoEdit(false);
        this.width = new SpinnerNumberModel(25, 25, 10000, 1);
        this.height = new SpinnerNumberModel(25, 25, 10000, 1);
        JPanel spinnersPane = new JPanel(new FlowLayout(1));
        SpinPane spinWidth = new SpinPane(this.width, LocaleUtils.getEditorLocaleString("Width"));
        SpinPane spinHeight = new SpinPane(this.height, LocaleUtils.getEditorLocaleString("Height"));
        this.initListeners();
        spinnersPane.add(spinWidth);
        spinnersPane.add(spinHeight);
        this.setLayout(new BorderLayout());
        this.add((Component)spinnersPane, "North");
        this.add((Component)this.drawer, "Center");
        this.updateCellSize();
    }

    public void setLook(CellAppearance look) {
        this.drawer.setLook(look);
        this.drawer.repaint();
    }

    private void initListeners() {
        this.width.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (CellPreview.this.isAutoEdit()) {
                    return;
                }
                CellPreview.this.setAutoValue(CellPreview.this.width, CellPreview.this.drawer.setCellWidth(CellPreview.this.width.getNumber().intValue()));
                CellPreview.this.drawer.repaint();
            }
        });
        this.height.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (CellPreview.this.isAutoEdit()) {
                    return;
                }
                CellPreview.this.setAutoValue(CellPreview.this.height, CellPreview.this.drawer.setCellHeight(CellPreview.this.height.getNumber().intValue()));
                CellPreview.this.drawer.repaint();
            }
        });
        this.drawer.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
                CellPreview.this.updateCellSize();
            }

            public void componentShown(ComponentEvent e) {
            }
        });
    }

    private void updateCellSize() {
        this.drawer.processCurrentSize();
        this.setAutoValue(this.width, this.drawer.getCellWidth());
        this.setAutoValue(this.height, this.drawer.getCellHeight());
    }

    private void setAutoValue(SpinnerNumberModel model, Integer value) {
        this.setAutoEdit(true);
        model.setValue(value);
        this.setAutoEdit(false);
    }

    public boolean isAutoEdit() {
        return this.autoEdit;
    }

    public void setAutoEdit(boolean autoEdit) {
        this.autoEdit = autoEdit;
    }
}

