/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.descriptor;

import datechooser.beans.editor.descriptor.ClassDescriptor;
import datechooser.beans.locale.LocaleUtils;
import java.awt.Font;

public class FontDescriptor
extends ClassDescriptor {
    public Class getDescriptedClass() {
        return Font.class;
    }

    public String getDescription(Object value) {
        StringBuffer buf = new StringBuffer();
        Font selFont = (Font)value;
        buf.append(selFont.getFamily());
        buf.append(", ");
        if (selFont.isItalic()) {
            buf.append(LocaleUtils.getEditorLocaleString("italic") + ", ");
        }
        if (selFont.isBold()) {
            buf.append(LocaleUtils.getEditorLocaleString("bold") + ", ");
        }
        buf.append(selFont.getSize());
        return buf.toString();
    }

    public String getJavaDescription(Object value) {
        StringBuffer buf = new StringBuffer();
        Font selFont = (Font)value;
        buf.append("new " + this.getClassName() + "(");
        buf.append('\"' + selFont.getFamily() + '\"');
        buf.append(", ");
        if (selFont.isBold() && selFont.isItalic()) {
            buf.append(this.getClassName() + ".BOLD + " + this.getClassName() + ".ITALIC");
        } else if (selFont.isBold()) {
            buf.append(this.getClassName() + ".BOLD");
        } else if (selFont.isItalic()) {
            buf.append(this.getClassName() + ".ITALIC");
        } else {
            buf.append(this.getClassName() + ".PLAIN");
        }
        buf.append(", ");
        buf.append(selFont.getSize());
        buf.append(")");
        return buf.toString();
    }
}

