/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.dimension;

import datechooser.beans.locale.LocaleUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class SimpleDimensionEditorPane
extends JPanel {
    private PropertyEditorSupport editor;
    private Preview preview;
    private JPanel controls;

    public SimpleDimensionEditorPane(PropertyEditorSupport editor) {
        this.editor = editor;
        final Dimension dim = this.getValue();
        final SpinnerNumberModel width = new SpinnerNumberModel(dim.width, 10, 20000, 1);
        final SpinnerNumberModel height = new SpinnerNumberModel(dim.height, 10, 20000, 1);
        this.controls = new JPanel(new GridLayout(1, 2));
        JPanel widthPane = new JPanel(new FlowLayout(1));
        JPanel heightPane = new JPanel(new FlowLayout(1));
        widthPane.add(new JLabel(LocaleUtils.getEditorLocaleString("Width")));
        widthPane.add(new JSpinner(width));
        heightPane.add(new JLabel(LocaleUtils.getEditorLocaleString("Height")));
        heightPane.add(new JSpinner(height));
        this.controls.add(widthPane);
        this.controls.add(heightPane);
        this.controls.revalidate();
        this.preview = new Preview();
        this.setLayout(new BorderLayout());
        this.add((Component)this.preview, "Center");
        this.add((Component)this.controls, "South");
        this.revalidate();
        ChangeListener onChange = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                dim.setSize(width.getNumber().intValue(), height.getNumber().intValue());
                SimpleDimensionEditorPane.this.setValue(dim);
                SimpleDimensionEditorPane.this.repaint();
            }
        };
        width.addChangeListener(onChange);
        height.addChangeListener(onChange);
    }

    private Dimension getValue() {
        return (Dimension)this.editor.getValue();
    }

    private void setValue(Dimension value) {
        this.editor.setValue(value);
    }

    private class Preview
    extends JPanel {
        private Point startRec = new Point();

        private Preview() {
        }

        protected void paintComponent(Graphics g) {
            Rectangle rec = this.getBounds();
            Dimension dim = SimpleDimensionEditorPane.this.getValue();
            this.startRec.x = dim.width < rec.width ? (rec.width - dim.width) / 2 : 0;
            this.startRec.y = dim.height < rec.height ? (rec.height - dim.height) / 2 : 0;
            g.setColor(Color.BLUE);
            g.fillRect(this.startRec.x, this.startRec.y, dim.width, dim.height);
        }

        public Dimension getPreferredSize() {
            return new Dimension(100, 200);
        }
    }
}

