/*
 * Decompiled with CFR 0.152.
 */
package datechooser.model;

import java.util.Calendar;

public class DateUtils {
    private static Calendar calendarCash = null;

    public static int getDay(Calendar date) {
        return date.get(5);
    }

    public static int getMonth(Calendar date) {
        return date.get(2);
    }

    public static int getYear(Calendar date) {
        return date.get(1);
    }

    public static boolean equals(Calendar dat1, Calendar dat2) {
        return DateUtils.getDay(dat1) == DateUtils.getDay(dat2) && DateUtils.getMonth(dat1) == DateUtils.getMonth(dat2) && DateUtils.getYear(dat1) == DateUtils.getYear(dat2);
    }

    public static boolean before(Calendar dat1, Calendar dat2) {
        if (DateUtils.getYear(dat1) < DateUtils.getYear(dat2)) {
            return true;
        }
        if (DateUtils.getYear(dat1) > DateUtils.getYear(dat2)) {
            return false;
        }
        if (DateUtils.getMonth(dat1) < DateUtils.getMonth(dat2)) {
            return true;
        }
        if (DateUtils.getMonth(dat1) > DateUtils.getMonth(dat2)) {
            return false;
        }
        return DateUtils.getDay(dat1) < DateUtils.getDay(dat2);
    }

    public static boolean after(Calendar dat1, Calendar dat2) {
        if (!DateUtils.before(dat1, dat2)) {
            return !DateUtils.equals(dat1, dat2);
        }
        return false;
    }

    public static void assign(Calendar target, Calendar source) {
        target.setTime(source.getTime());
    }

    public static boolean isNear(Calendar dat1, Calendar dat2) {
        Calendar before = null;
        Calendar after = null;
        if (DateUtils.before(dat1, dat2)) {
            before = dat1;
            after = dat2;
        } else {
            before = dat2;
            after = dat1;
        }
        DateUtils.initializeCash(before);
        calendarCash.add(5, 1);
        return DateUtils.equals(calendarCash, after);
    }

    private static void initializeCash(Calendar date) {
        if (calendarCash == null) {
            calendarCash = (Calendar)date.clone();
        } else {
            calendarCash.setTime(date.getTime());
        }
    }
}

