/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.pdf.internal.elements;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import fr.opensagres.poi.xwpf.converter.core.MasterPageManager;
import fr.opensagres.poi.xwpf.converter.core.PageOrientation;
import fr.opensagres.poi.xwpf.converter.core.XWPFConverterException;
import fr.opensagres.poi.xwpf.converter.core.utils.DxaUtil;
import fr.opensagres.poi.xwpf.converter.core.utils.XWPFUtils;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableDocumentSection;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableHeaderFooter;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableMasterPage;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableParagraph;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableTable;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableTableCell;
import fr.opensagres.xdocreport.itext.extension.ExtendedDocument;
import fr.opensagres.xdocreport.itext.extension.ExtendedHeaderFooter;
import fr.opensagres.xdocreport.itext.extension.ExtendedPdfPTable;
import fr.opensagres.xdocreport.itext.extension.IITextContainer;
import fr.opensagres.xdocreport.itext.extension.IMasterPage;
import fr.opensagres.xdocreport.itext.extension.IMasterPageHeaderFooter;
import fr.opensagres.xdocreport.itext.extension.IPdfWriterConfiguration;
import java.io.OutputStream;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageMar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageSz;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;

public class StylableDocument
extends ExtendedDocument {
    private StylableMasterPage activeMasterPage;
    private boolean masterPageJustChanged;
    private boolean documentEmpty = true;
    private PdfPTable layoutTable;
    private ColumnText text;
    private int colIdx;
    private MasterPageManager masterPageManager;

    public StylableDocument(OutputStream out, IPdfWriterConfiguration configuration) throws DocumentException {
        super(out, configuration);
    }

    @Override
    public void addElement(Element element) {
        if (!super.isOpen()) {
            super.open();
        }
        if (this.masterPageJustChanged) {
            this.pageBreak();
        }
        this.text.addElement(element);
        StylableDocumentSection.getCell(this.layoutTable, this.colIdx).getColumn().addElement(element);
        this.simulateText();
        this.documentEmpty = false;
    }

    public void columnBreak() {
        if (this.colIdx + 1 < this.layoutTable.getNumberOfColumns()) {
            this.setColIdx(this.colIdx + 1);
            this.simulateText();
        } else {
            this.pageBreak();
        }
    }

    public void pageBreak() {
        if (!this.documentEmpty) {
            if (this.masterPageJustChanged) {
                this.masterPageJustChanged = false;
                super.newPage();
            } else {
                this.flushTable();
                super.newPage();
                this.layoutTable = StylableDocumentSection.cloneAndClearTable(this.layoutTable, false);
                this.setColIdx(0);
                this.simulateText();
            }
        }
    }

    public boolean newPage() {
        throw new XWPFConverterException("internal error - do not call newPage directly");
    }

    public void close() {
        this.flushTable();
        super.close();
    }

    public float getWidthLimit() {
        PdfPCell cell = StylableDocumentSection.getCell(this.layoutTable, this.colIdx);
        return cell.getRight() - cell.getPaddingRight() - cell.getLeft() - cell.getPaddingLeft();
    }

    public float getHeightLimit() {
        return StylableDocumentSection.getCell(this.layoutTable, this.colIdx).getFixedHeight() + this.text.getYLine();
    }

    public float getPageWidth() {
        return this.right() - this.left();
    }

    private float getAdjustedPageHeight() {
        return this.top() - this.bottom() - 0.001f;
    }

    private void setColIdx(int idx) {
        this.colIdx = idx;
        PdfPCell cell = StylableDocumentSection.getCell(this.layoutTable, this.colIdx);
        this.text.setSimpleColumn(cell.getLeft() + cell.getPaddingLeft(), -this.getAdjustedPageHeight(), cell.getRight() - cell.getPaddingRight(), 0.0f);
        cell.setColumn(ColumnText.duplicate((ColumnText)this.text));
    }

    private void simulateText() {
        int res = 0;
        try {
            res = this.text.go(true);
        }
        catch (DocumentException e) {
            throw new XWPFConverterException(e);
        }
        if (ColumnText.hasMoreText((int)res)) {
            this.columnBreak();
        }
    }

    public StylableParagraph createParagraph(IITextContainer parent) {
        return new StylableParagraph(this, parent);
    }

    public Paragraph createParagraph() {
        return this.createParagraph((IITextContainer)null);
    }

    public Paragraph createParagraph(Paragraph title) {
        return new StylableParagraph(this, title, null);
    }

    public StylableTable createTable(IITextContainer parent, int numColumns) {
        return new StylableTable(this, parent, numColumns);
    }

    public StylableTableCell createTableCell(IITextContainer parent) {
        return new StylableTableCell(this, parent);
    }

    public StylableTableCell createTableCell(IITextContainer parent, ExtendedPdfPTable table) {
        return new StylableTableCell(this, parent, table);
    }

    @Override
    public void setActiveMasterPage(IMasterPage m) {
        StylableMasterPage masterPage = (StylableMasterPage)m;
        if (this.activeMasterPage != null && XWPFUtils.isContinuousSection(masterPage.getSectPr())) {
            return;
        }
        this.flushTable();
        this.applySectPr(masterPage.getSectPr());
        super.setActiveMasterPage(masterPage);
        if (this.activeMasterPage != null) {
            this.masterPageJustChanged = true;
        }
        this.activeMasterPage = masterPage;
        this.layoutTable = StylableDocumentSection.createLayoutTable(this.getPageWidth(), this.getAdjustedPageHeight());
        this.text = StylableDocumentSection.createColumnText();
        this.setColIdx(0);
    }

    private void applySectPr(CTSectPr sectPr) {
        CTPageMar pageMar;
        CTPageSz pageSize = sectPr.getPgSz();
        Rectangle pdfPageSize = new Rectangle(DxaUtil.dxa2points(pageSize.getW()), DxaUtil.dxa2points(pageSize.getH()));
        super.setPageSize(pdfPageSize);
        PageOrientation orientation = XWPFUtils.getPageOrientation(pageSize.getOrient());
        if (orientation != null) {
            switch (orientation) {
                case Landscape: {
                    super.setOrientation(fr.opensagres.xdocreport.itext.extension.PageOrientation.Landscape);
                    break;
                }
                case Portrait: {
                    super.setOrientation(fr.opensagres.xdocreport.itext.extension.PageOrientation.Portrait);
                }
            }
        }
        if ((pageMar = sectPr.getPgMar()) != null) {
            super.setOriginalMargins(DxaUtil.dxa2points(pageMar.getLeft()), DxaUtil.dxa2points(pageMar.getRight()), DxaUtil.dxa2points(pageMar.getTop()), DxaUtil.dxa2points(pageMar.getBottom()));
        }
    }

    private void flushTable() {
        if (this.layoutTable != null) {
            this.layoutTable.calculateHeights(true);
            try {
                super.add((Element)this.layoutTable);
            }
            catch (DocumentException e) {
                throw new XWPFConverterException(e);
            }
        }
    }

    @Override
    protected ExtendedHeaderFooter createExtendedHeaderFooter() {
        return new ExtendedHeaderFooter(this){

            @Override
            public void onStartPage(PdfWriter writer, Document doc) {
                super.onStartPage(writer, doc);
                StylableDocument.this.onStartPage();
            }

            @Override
            protected float getHeaderY(IMasterPageHeaderFooter header) {
                Float headerY = ((StylableHeaderFooter)header).getY();
                if (headerY != null) {
                    return this.document.getPageSize().getHeight() - headerY.floatValue();
                }
                return super.getHeaderY(header);
            }

            @Override
            protected float getFooterY(IMasterPageHeaderFooter footer) {
                Float footerY = ((StylableHeaderFooter)footer).getY();
                if (footerY != null) {
                    return ((StylableHeaderFooter)footer).getTotalHeight();
                }
                return super.getFooterY(footer);
            }

            @Override
            protected float adjustMargin(float margin, IMasterPageHeaderFooter headerFooter) {
                if (((StylableHeaderFooter)headerFooter).getY() != null) {
                    if (headerFooter.getTotalHeight() > margin) {
                        return headerFooter.getTotalHeight();
                    }
                    return margin;
                }
                return super.adjustMargin(margin, headerFooter);
            }
        };
    }

    protected void onStartPage() {
        this.masterPageManager.onNewPage();
    }

    public void setMasterPageManager(MasterPageManager masterPageManager) {
        this.masterPageManager = masterPageManager;
    }
}

