/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx.preprocessor.sax;

import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.core.utils.XMLUtils;
import fr.opensagres.xdocreport.document.docx.DocxUtils;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.BookmarkBufferedRegion;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.DocXBufferedDocumentContentHandler;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.FldSimpleBufferedRegion;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.MergefieldBufferedRegion;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.PBufferedRegion;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.RBufferedRegion;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.hyperlinks.HyperlinkBufferedRegion;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.notes.endnotes.EndnoteReferenceBufferedRegion;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.notes.footnotes.FootnoteReferenceBufferedRegion;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.document.preprocessor.sax.TransformedBufferedDocument;
import fr.opensagres.xdocreport.template.formatter.FieldMetadata;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DocxBufferedDocument
extends TransformedBufferedDocument {
    protected final DocXBufferedDocumentContentHandler handler;
    private PBufferedRegion currentPRegion;
    private FldSimpleBufferedRegion currentFldSimpleRegion;
    private RBufferedRegion currentRRegion;
    private BookmarkBufferedRegion currentBookmark;
    private HyperlinkBufferedRegion currentHyperlink;

    public DocxBufferedDocument(DocXBufferedDocumentContentHandler handler) {
        this.handler = handler;
    }

    @Override
    protected BufferedElement createElement(BufferedElement parent, String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (DocxUtils.isFldChar(uri, localName, name) && this.currentRRegion != null) {
            String fldCharType = attributes.getValue("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "fldCharType");
            this.currentRRegion.setFldCharType(fldCharType);
            return super.createElement(parent, uri, localName, name, attributes);
        }
        if (DocxUtils.isP(uri, localName, name)) {
            this.currentPRegion = new PBufferedRegion(this, this.getCurrentElement(), uri, localName, name, attributes);
            return this.currentPRegion;
        }
        if (DocxUtils.isR(uri, localName, name) && this.currentFldSimpleRegion == null) {
            this.currentRRegion = new RBufferedRegion(this.handler, parent, uri, localName, name, attributes);
            HyperlinkBufferedRegion hyperlink = this.getCurrentHyperlink();
            if (hyperlink != null) {
                hyperlink.addRegion(this.currentRRegion);
            } else {
                PBufferedRegion pRegion = this.getCurrentPRegion();
                if (pRegion != null) {
                    pRegion.addRegion(this.currentRRegion);
                }
            }
            return this.currentRRegion;
        }
        if (DocxUtils.isFldSimple(uri, localName, name)) {
            String instrText = attributes.getValue("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "instr");
            FieldMetadata fieldAsTextStyling = this.handler.getFieldAsTextStyling(instrText);
            instrText = this.handler.processRowIfNeeded(attributes.getValue("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "instr"));
            this.currentFldSimpleRegion = new FldSimpleBufferedRegion(this.handler, parent, uri, localName, name, attributes);
            this.currentFldSimpleRegion.setInstrText(instrText, fieldAsTextStyling);
            if (this.currentFldSimpleRegion.getFieldName() == null) {
                // empty if block
            }
            return this.currentFldSimpleRegion;
        }
        if (DocxUtils.isBookmarkStart(uri, localName, name)) {
            String imageFieldName;
            String bookmarkName = attributes.getValue("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "name");
            FieldsMetadata fieldsMetadata = this.handler.getFieldsMetadata();
            if (fieldsMetadata != null && (imageFieldName = fieldsMetadata.getImageFieldName(bookmarkName)) != null) {
                this.currentBookmark = new BookmarkBufferedRegion(bookmarkName, imageFieldName, parent, uri, localName, imageFieldName, attributes);
                IDocumentFormatter formatter = this.handler.getFormatter();
                if (formatter != null) {
                    String set = formatter.getSetDirective("___imageInfo", formatter.getFunctionDirective(false, "___ImageRegistry", "registerImage", this.handler.processRowIfNeeded(this.currentBookmark.getImageFieldName(), true), "'" + this.currentBookmark.getBookmarkName() + "'", "___context"), false);
                    String imageInfoIf = formatter.getStartIfDirective(formatter.formatAsSimpleField(false, "___imageInfo", "notRemoveImageTemplate"), false);
                    StringBuilder before = new StringBuilder();
                    before.append(set);
                    before.append(imageInfoIf);
                    this.currentBookmark.setContentBeforeStartTagElement(before.toString());
                }
                return this.currentBookmark;
            }
            return super.createElement(parent, uri, localName, name, attributes);
        }
        if (DocxUtils.isBookmarkEnd(uri, localName, name)) {
            IDocumentFormatter formatter;
            BufferedElement bookmarkEnd = super.createElement(parent, uri, localName, name, attributes);
            if (this.currentBookmark != null && (formatter = this.handler.getFormatter()) != null) {
                bookmarkEnd.setContentAfterEndTagElement(formatter.getEndIfDirective("___imageInfo"));
            }
            this.currentBookmark = null;
            return bookmarkEnd;
        }
        if (DocxUtils.isDrawing(uri, localName, name)) {
            BufferedElement element = super.createElement(parent, uri, localName, name, attributes);
            if (StringUtils.isNotEmpty(this.handler.getStartNoParse())) {
                element.setContentBeforeStartTagElement(this.handler.getEndNoParse());
                element.setContentAfterEndTagElement(this.handler.getStartNoParse());
            }
            return element;
        }
        if (DocxUtils.isHyperlink(uri, localName, name)) {
            int idIndex = attributes.getIndex("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "id");
            if (idIndex != -1) {
                String attrName = attributes.getQName(idIndex);
                AttributesImpl attributesImpl = XMLUtils.toAttributesImpl(attributes);
                attributesImpl.removeAttribute(idIndex);
                String id = attributes.getValue(idIndex);
                this.currentHyperlink = new HyperlinkBufferedRegion(this.handler, parent, uri, localName, name, attributesImpl);
                this.currentHyperlink.setId(attrName, id);
                return this.currentHyperlink;
            }
            return super.createElement(parent, uri, localName, name, attributes);
        }
        if (DocxUtils.isFootnoteReference(uri, localName, name)) {
            int idIndex = attributes.getIndex("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "id");
            if (idIndex != -1) {
                String attrName = attributes.getQName(idIndex);
                AttributesImpl attributesImpl = XMLUtils.toAttributesImpl(attributes);
                attributesImpl.removeAttribute(idIndex);
                String id = attributes.getValue(idIndex);
                FootnoteReferenceBufferedRegion noteReference = new FootnoteReferenceBufferedRegion(this.handler, parent, uri, localName, name, attributesImpl);
                noteReference.setId(attrName, id);
                if (this.currentRRegion != null) {
                    this.currentRRegion.setContainsNote(true);
                }
                return noteReference;
            }
            return super.createElement(parent, uri, localName, name, attributes);
        }
        if (DocxUtils.isEndnoteReference(uri, localName, name)) {
            int idIndex = attributes.getIndex("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "id");
            if (idIndex != -1) {
                String attrName = attributes.getQName(idIndex);
                AttributesImpl attributesImpl = XMLUtils.toAttributesImpl(attributes);
                attributesImpl.removeAttribute(idIndex);
                String id = attributes.getValue(idIndex);
                EndnoteReferenceBufferedRegion noteReference = new EndnoteReferenceBufferedRegion(this.handler, parent, uri, localName, name, attributesImpl);
                noteReference.setId(attrName, id);
                if (this.currentRRegion != null) {
                    this.currentRRegion.setContainsNote(true);
                }
                return noteReference;
            }
            return super.createElement(parent, uri, localName, name, attributes);
        }
        return super.createElement(parent, uri, localName, name, attributes);
    }

    public BookmarkBufferedRegion getCurrentBookmark() {
        return this.currentBookmark;
    }

    public FldSimpleBufferedRegion getCurrentFldSimpleRegion() {
        return this.currentFldSimpleRegion;
    }

    public HyperlinkBufferedRegion getCurrentHyperlink() {
        return this.currentHyperlink;
    }

    public PBufferedRegion getCurrentPRegion() {
        return this.currentPRegion;
    }

    public RBufferedRegion getCurrentRRegion() {
        return this.currentRRegion;
    }

    @Override
    public void onEndEndElement(String uri, String localName, String name) {
        if (DocxUtils.isP(uri, localName, name) && this.currentPRegion != null) {
            super.onEndEndElement(uri, localName, name);
            this.currentPRegion.process();
            this.currentPRegion = null;
            return;
        }
        if (DocxUtils.isR(uri, localName, name) && this.currentRRegion != null && this.currentFldSimpleRegion == null) {
            super.onEndEndElement(uri, localName, name);
            this.currentRRegion = null;
            return;
        }
        if (DocxUtils.isFldSimple(uri, localName, name) && this.currentFldSimpleRegion != null) {
            boolean hasScript = this.processScriptBeforeAfter(this.currentFldSimpleRegion);
            if (hasScript) {
                this.currentFldSimpleRegion.reset();
            }
            super.onEndEndElement(uri, localName, name);
            this.currentFldSimpleRegion = null;
            return;
        }
        if (DocxUtils.isHyperlink(uri, localName, name)) {
            HyperlinkBufferedRegion hyperlink = this.currentHyperlink;
            super.onEndEndElement(uri, localName, name);
            if (hyperlink != null) {
                hyperlink.process();
            }
            this.currentHyperlink = null;
            return;
        }
        super.onEndEndElement(uri, localName, name);
    }

    public boolean processScriptBeforeAfter(MergefieldBufferedRegion mergefield) {
        boolean hasScript;
        String startNoParse;
        String fieldName = mergefield.getFieldName();
        if (fieldName == null) {
            return false;
        }
        String endNoParse = this.handler.getEndNoParse();
        if (endNoParse != null && fieldName.startsWith(endNoParse)) {
            fieldName = fieldName.substring(endNoParse.length(), fieldName.length());
        }
        if ((startNoParse = this.handler.getStartNoParse()) != null && fieldName.endsWith(startNoParse)) {
            fieldName = fieldName.substring(0, fieldName.length() - startNoParse.length());
        }
        if (hasScript = this.handler.processScriptBefore(fieldName)) {
            return hasScript;
        }
        return this.handler.processScriptAfter(fieldName);
    }

    @Override
    protected boolean isTable(String uri, String localName, String name) {
        return DocxUtils.isTable(uri, localName, name);
    }

    @Override
    protected boolean isTableRow(String uri, String localName, String name) {
        return DocxUtils.isTableRow(uri, localName, name);
    }
}

