/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans;

import datechooser.beans.BeanTableCell;
import datechooser.beans.BeanTableCellRenderer;
import datechooser.beans.DateChooserVisual;
import datechooser.events.CommitEvent;
import datechooser.events.CommitListener;
import datechooser.model.multiple.MultyModelBehavior;
import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

class BeanTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
BeanTableCell {
    private DateChooserVisual bean;
    private boolean commitLocked;
    private BeanTableCellRenderer renderer;

    public BeanTableCellEditor(DateChooserVisual bean) {
        this.setCommitLocked(false);
        this.renderer = new BeanTableCellRenderer(bean);
        this.bean = bean;
        bean.addCommitListener(new CommitListener(){

            public void onCommit(CommitEvent evt) {
                if (!BeanTableCellEditor.this.isCommitLocked()) {
                    BeanTableCellEditor.this.stopCellEditing();
                }
            }
        });
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return this.renderer.getTableCellRendererComponent(table, value, isSelected, true, row, column);
    }

    public Object getCellEditorValue() {
        if (this.bean.getBehavior() == MultyModelBehavior.SELECT_SINGLE && this.isUseCalendarForSingleDate()) {
            return this.bean.getSelectedDate();
        }
        return this.bean.getSelectedPeriodSet();
    }

    public boolean isCommitLocked() {
        return this.commitLocked;
    }

    public void setCommitLocked(boolean commitLocked) {
        this.commitLocked = commitLocked;
    }

    public boolean isUseCalendarForSingleDate() {
        return this.renderer.isUseCalendarForSingleDate();
    }

    public void setUseCalendarForSingleDate(boolean useCalendarForSingleDate) {
        this.renderer.setUseCalendarForSingleDate(useCalendarForSingleDate);
    }
}

