/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans;

import datechooser.beans.DateChooserPanel;
import datechooser.beans.DateChooserVisual;
import datechooser.beans.pic.Pictures;
import datechooser.events.CommitEvent;
import datechooser.events.CommitListener;
import datechooser.events.CursorMoveListener;
import datechooser.events.SelectionChangedEvent;
import datechooser.events.SelectionChangedListener;
import datechooser.model.exeptions.IncompatibleDataExeption;
import datechooser.model.multiple.DateOutputStyle;
import datechooser.model.multiple.MultyModelBehavior;
import datechooser.model.multiple.Period;
import datechooser.model.multiple.PeriodSet;
import datechooser.view.WeekDaysStyle;
import datechooser.view.appearance.AppearancesList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateChooserCombo
extends DateChooserVisual {
    public static final long serialVersionUID = -7510689410235869108L;
    public static final String COMBO_PREFIX = "dch_combo_";
    public static final String PROPERTY_BORDER = "dch_combo_border";
    public static final String PROPERTY_FIELD_FONT = "dch_combo_fieldFont";
    public static final String PROPERTY_DATE_FORMAT = "dch_combo_dateFormat";
    private static final int DROP_BUTTON_WIDTH = 25;
    private static final float GOLD = 0.62f;
    private DateChooserPanel chooser;
    private JPopupMenu menu;
    private JFormattedTextField field;
    private JButton bShowPopup;
    private PeriodSet selection;
    protected boolean autoEdit;
    private DateFormat dateFormat = null;

    public DateChooserCombo() {
        this.setAutoEdit(false);
        this.chooser = new DateChooserPanel();
        this.chooser.setCurrentNavigateIndex(1);
        this.chooser.addSelectionChangedListener(new OnSelectionChanged());
        this.chooser.addCommitListener(new CommitListener(){

            public void onCommit(CommitEvent evt) {
                DateChooserCombo.this.menu.setVisible(false);
                DateChooserCombo.this.dateToField();
            }
        });
        this.menu = new JPopupMenu();
        this.menu.add(this.chooser);
        this.menu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
                DateChooserCombo.this.restoreState();
                DateChooserCombo.this.dateToField();
                DateChooserCombo.this.commit();
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                DateChooserCombo.this.saveState();
            }
        });
        this.setLayout(new BorderLayout());
        this.field = new JFormattedTextField();
        this.bShowPopup = new JButton(new ImageIcon(Pictures.getResource("down.gif")));
        this.bShowPopup.setPressedIcon(new ImageIcon(Pictures.getResource("down_active.gif")));
        this.bShowPopup.setPreferredSize(new Dimension(25, this.field.getPreferredSize().height));
        this.add((Component)this.field, "Center");
        this.add((Component)this.bShowPopup, "East");
        this.setPreferredSize(new Dimension((int)((float)this.chooser.getPreferredSize().width * 0.62f), this.field.getPreferredSize().height));
        this.bShowPopup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DateChooserCombo.this.showDropDown();
            }
        });
        this.dateToField();
        this.testEditability();
        this.field.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (!DateChooserCombo.this.isEditable()) {
                    return;
                }
                DateChooserCombo.this.fieldToDate();
            }
        });
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                SwingUtilities.updateComponentTreeUI(DateChooserCombo.this.getComboPanel());
                SwingUtilities.updateComponentTreeUI(DateChooserCombo.this.menu);
            }
        });
    }

    private DateChooserCombo getComboPanel() {
        return this;
    }

    @Override
    public void setBorder(Border border) {
        Border oldBorder = this.getBorder();
        super.setBorder(border);
        this.firePropertyChange(PROPERTY_BORDER, oldBorder, this.getBorder());
    }

    public String getText() {
        return this.field.getText();
    }

    public boolean setText(String text) {
        if (!this.isEditable()) {
            return false;
        }
        if (text == null || text.equals("")) {
            this.chooser.getModel().selectNothing();
            this.field.setText("");
            return true;
        }
        this.field.setText(text);
        return this.fieldToDate();
    }

    private void showDropDown() {
        if (!this.isEnabled()) {
            return;
        }
        this.menu.show(this.getParent(), this.getX(), this.getY() + this.getHeight());
    }

    private void saveState() {
        this.selection = (PeriodSet)this.chooser.getSelectedPeriodSet().clone();
    }

    private void restoreState() {
        this.chooser.setSelection(this.selection);
    }

    @Override
    public Dimension getCalendarPreferredSize() {
        return this.chooser.getCalendarPreferredSize();
    }

    @Override
    public void setCalendarPreferredSize(Dimension dim) {
        this.chooser.setCalendarPreferredSize(dim);
        this.menu.revalidate();
    }

    public Font getFieldFont() {
        return this.field.getFont();
    }

    public void setFieldFont(Font font) {
        Font oldFont = this.getFieldFont();
        this.field.setFont(font);
        this.firePropertyChange(PROPERTY_FIELD_FONT, oldFont, this.getFieldFont());
    }

    public int getFormat() {
        return DateOutputStyle.getFormat();
    }

    public void setFormat(int format) {
        int oldFormat = this.getFormat();
        DateOutputStyle.setFormat(format);
        this.dateToField();
        this.firePropertyChange(PROPERTY_DATE_FORMAT, oldFormat, this.getFormat());
    }

    @Override
    public MultyModelBehavior getBehavior() {
        return this.chooser.getBehavior();
    }

    @Override
    public AppearancesList getCurrentView() {
        return this.chooser.getCurrentView();
    }

    @Override
    public PeriodSet getDefaultPeriods() {
        return this.chooser.getDefaultPeriods();
    }

    @Override
    public PeriodSet getForbiddenPeriods() {
        return this.chooser.getForbiddenPeriods();
    }

    @Override
    public Calendar getMaxDate() {
        return this.chooser.getMaxDate();
    }

    @Override
    public Calendar getMinDate() {
        return this.chooser.getMinDate();
    }

    @Override
    public Calendar getSelectedDate() {
        return this.chooser.getSelectedDate();
    }

    @Override
    public PeriodSet getSelectedPeriodSet() {
        return this.chooser.getSelectedPeriodSet();
    }

    @Override
    public Iterable<Period> getSelection() {
        return this.chooser.getSelection();
    }

    @Override
    public boolean isAutoScroll() {
        return this.chooser.isAutoScroll();
    }

    @Override
    public boolean isShowOneMonth() {
        return this.chooser.isShowOneMonth();
    }

    @Override
    public void setAutoScroll(boolean autoScroll) {
        this.chooser.setAutoScroll(autoScroll);
    }

    private void testEditability() {
        this.field.setEditable(this.isEditable());
    }

    private boolean isEditable() {
        return this.getBehavior().equals((Object)MultyModelBehavior.SELECT_SINGLE);
    }

    @Override
    public void setBehavior(MultyModelBehavior behavior) {
        this.chooser.setBehavior(behavior);
        this.testEditability();
    }

    @Override
    public void setCurrentView(AppearancesList aList) {
        this.chooser.setCurrentView(aList);
    }

    @Override
    public void setDefaultPeriods(PeriodSet periods) throws IncompatibleDataExeption {
        this.chooser.setDefaultPeriods(periods);
        this.dateToField();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.chooser.setEnabled(enabled);
        this.field.setEnabled(enabled);
        this.bShowPopup.setEnabled(enabled);
    }

    @Override
    public void setForbidden(Iterable<Period> forbiddenPeriods) {
        this.chooser.setForbidden(forbiddenPeriods);
    }

    @Override
    public void setForbiddenPeriods(PeriodSet periods) throws IncompatibleDataExeption {
        this.chooser.setForbiddenPeriods(periods);
    }

    @Override
    public void setMaxDate(Calendar aDate) {
        this.chooser.setMaxDate(aDate);
    }

    @Override
    public void setMinDate(Calendar aDate) {
        this.chooser.setMinDate(aDate);
    }

    @Override
    public void setSelectedDate(Calendar aDate) {
        this.chooser.setSelectedDate(aDate);
        this.dateToField();
    }

    @Override
    public void setSelection(Iterable<Period> periods) {
        this.chooser.setSelection(periods);
        this.dateToField();
    }

    @Override
    public void setSelection(PeriodSet periods) {
        this.chooser.setSelection(periods);
        this.dateToField();
    }

    @Override
    public void setShowOneMonth(boolean showOneMonth) {
        this.chooser.setShowOneMonth(showOneMonth);
    }

    @Override
    public Font getNavigateFont() {
        return this.chooser.getNavigateFont();
    }

    @Override
    public void setNavigateFont(Font font) {
        this.chooser.setNavigateFont(font);
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.chooser.setLocale(locale);
        DateOutputStyle.setLocale(locale);
        this.dateToField();
    }

    @Override
    public int getCurrentNavigateIndex() {
        return this.chooser.getCurrentNavigateIndex();
    }

    @Override
    public void setCurrentNavigateIndex(int currentNavigateIndex) {
        if (currentNavigateIndex != 1) {
            return;
        }
        this.chooser.setCurrentNavigateIndex(currentNavigateIndex);
    }

    private void dateToField() {
        this.setAutoEdit(true);
        this.field.setText(this.chooser.getSelectedPeriodSet().toString(this.getDateFormat()));
        this.setAutoEdit(false);
    }

    private boolean fieldToDate() {
        if (this.isAutoEdit()) {
            return true;
        }
        try {
            Date dat = this.getDateFormat().parse(this.field.getText().trim());
            GregorianCalendar newDat = new GregorianCalendar();
            newDat.setTime(dat);
            this.setSelectedDate(newDat);
        }
        catch (ParseException ex) {
            this.dateToField();
            return false;
        }
        return true;
    }

    @Override
    public void addCommitListener(CommitListener listener) {
        this.chooser.addCommitListener(listener);
    }

    @Override
    public void removeCommitListener(CommitListener listener) {
        this.chooser.removeCommitListener(listener);
    }

    @Override
    public void addSelectionChangedListener(SelectionChangedListener listener) {
        this.chooser.addSelectionChangedListener(listener);
    }

    @Override
    public void removeSelectionChangedListener(SelectionChangedListener listener) {
        this.chooser.removeSelectionChangedListener(listener);
    }

    @Override
    public void commit() {
        this.chooser.commit();
    }

    private boolean isAutoEdit() {
        return this.autoEdit;
    }

    private void setAutoEdit(boolean autoEdit) {
        this.autoEdit = autoEdit;
    }

    @Override
    public boolean isLocked() {
        return this.chooser.isLocked();
    }

    @Override
    public void setLocked(boolean lock) {
        this.chooser.setLocked(lock);
    }

    @Override
    public WeekDaysStyle getWeekStyle() {
        return this.chooser.getWeekStyle();
    }

    @Override
    public void setWeekStyle(WeekDaysStyle weekStyle) {
        this.chooser.setWeekStyle(weekStyle);
    }

    @Override
    public void addCursorMoveListener(CursorMoveListener listener) {
        this.chooser.addCursorMoveListener(listener);
    }

    @Override
    public void removeCursorMoveListener(CursorMoveListener listener) {
        this.chooser.removeCursorMoveListener(listener);
    }

    @Override
    public Calendar getCurrent() {
        return this.chooser.getCurrent();
    }

    @Override
    public boolean setCurrent(Calendar aDate) {
        return this.chooser.setCurrent(aDate);
    }

    @Override
    public void setNothingAllowed(boolean allow) {
        this.chooser.setNothingAllowed(allow);
    }

    @Override
    public boolean isNothingAllowed() {
        return this.chooser.isNothingAllowed();
    }

    @Override
    public Color getCalendarBackground() {
        return this.chooser.getCalendarBackground();
    }

    @Override
    public void setCalendarBackground(Color backColor) {
        this.chooser.setCalendarBackground(backColor);
    }

    @Override
    public AppearancesList getAppearancesList() {
        return this.chooser.getAppearancesList();
    }

    public DateFormat getDateFormat() {
        if (this.dateFormat != null) {
            return this.dateFormat;
        }
        DateFormat fmt = DateFormat.getDateInstance(this.getFormat(), this.getLocale());
        return fmt;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.dateToField();
    }

    private class OnSelectionChanged
    implements SelectionChangedListener {
        private OnSelectionChanged() {
        }

        public void onSelectionChange(SelectionChangedEvent evt) {
            DateChooserCombo.this.dateToField();
        }
    }
}

