/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.border.types;

import datechooser.beans.editor.border.types.AbstractBorderEditor;
import datechooser.beans.editor.utils.ColorChooseAction;
import datechooser.beans.editor.utils.ColorHolder;
import datechooser.beans.editor.utils.InsetsPanel;
import datechooser.beans.locale.LocaleUtils;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;

public class MatteBorderEditor
extends AbstractBorderEditor {
    private Insets insets;
    private ColorHolder color = new ColorHolder();
    private InsetsPanel insetsPane;

    public MatteBorderEditor() {
        this.setCaption(LocaleUtils.getEditorLocaleString("Matte"));
        this.initialize();
        this.insetsPane = new InsetsPanel(this.insets);
        this.insetsPane.addPropertyChangeListener(new InsetsListener());
        JButton bColor = new JButton(LocaleUtils.getEditorLocaleString("Matte_color"));
        ColorChooseAction colorChooseAction = new ColorChooseAction(this.color, LocaleUtils.getEditorLocaleString("Matte_color"), this);
        colorChooseAction.addPropertyChangeListener(new ColorListener());
        bColor.addActionListener(colorChooseAction);
        this.setLayout(new GridLayout(2, 1));
        this.add(this.getCenteredPane(this.insetsPane));
        this.add(this.getCenteredPane(bColor));
        this.refreshInterface();
    }

    protected void prepareSelection() {
        this.setValue(new MatteBorder(this.insets, this.color.getColor()));
    }

    private void assignValueToParameters() {
        Insets currIns = this.getValue().getBorderInsets();
        this.insets.set(currIns.top, currIns.left, currIns.bottom, currIns.right);
        this.color.setColor(this.getValue().getMatteColor());
    }

    protected MatteBorder getValue() {
        return (MatteBorder)this.value;
    }

    public void refreshInterface() {
        this.assignValueToParameters();
        this.insetsPane.refresh();
    }

    protected Border getDefaultValue() {
        this.insets = new Insets(1, 1, 1, 1);
        return new MatteBorder(this.insets, Color.GRAY);
    }

    private class ColorListener
    implements PropertyChangeListener {
        private ColorListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!"color".equals(evt.getPropertyName())) {
                return;
            }
            MatteBorderEditor.this.fireChange();
        }
    }

    private class InsetsListener
    implements PropertyChangeListener {
        private InsetsListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!"insets".equals(evt.getPropertyName())) {
                return;
            }
            MatteBorderEditor.this.fireChange();
        }
    }
}

