/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.cell;

import datechooser.beans.editor.cell.MainCellEditorPane;
import datechooser.beans.editor.font.SimpleFontEditor;
import datechooser.beans.editor.utils.EditorDialog;
import datechooser.beans.locale.LocaleUtils;
import datechooser.view.appearance.CellAppearance;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;

public abstract class CellEditorPane
extends JPanel {
    private EditorDialog fontEditorDialog;
    protected MainCellEditorPane mainEditor;
    private JButton selCursorColorCash;

    public CellEditorPane(MainCellEditorPane parentEditor) {
        this.setMainEditor(parentEditor);
        this.fontEditorDialog = new EditorDialog((Frame)this.getParent(), new SimpleFontEditor());
        this.generateInterface();
    }

    protected MainCellEditorPane getMainEditor() {
        return this.mainEditor;
    }

    protected CellAppearance getValue() {
        return this.getMainEditor().getValue();
    }

    protected Color selectColor(Color oldColor, String prompt) {
        Color newColor = JColorChooser.showDialog(this, prompt, oldColor);
        return newColor != null ? newColor : oldColor;
    }

    protected void setMainEditor(MainCellEditorPane mainEditor) {
        this.mainEditor = mainEditor;
    }

    protected JButton createFontChooseButton() {
        JButton bFont = new JButton(LocaleUtils.getEditorLocaleString("Font"));
        bFont.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Font newFont = (Font)CellEditorPane.this.fontEditorDialog.showDialog(CellEditorPane.this.getValue().getFont(), LocaleUtils.getEditorLocaleString("Select_font"));
                if (!CellEditorPane.this.fontEditorDialog.isCanceled()) {
                    CellEditorPane.this.getValue().setFont(newFont);
                    CellEditorPane.this.getMainEditor().fireLocalPropertyChange();
                }
            }
        });
        return bFont;
    }

    protected JButton createCursorColorChooseButton() {
        JButton selCursorColor = new JButton(LocaleUtils.getEditorLocaleString("Cursor_color"));
        selCursorColor.setEnabled(this.getValue().isSelectable());
        selCursorColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellEditorPane.this.getValue().setCursorColor(CellEditorPane.this.selectColor(CellEditorPane.this.getValue().getCursorColor(), LocaleUtils.getEditorLocaleString("Select_cursor_color")));
                CellEditorPane.this.getMainEditor().fireLocalPropertyChange();
            }
        });
        this.selCursorColorCash = selCursorColor;
        return selCursorColor;
    }

    protected JButton createTextColorChooseButton() {
        JButton selTextColor = new JButton(LocaleUtils.getEditorLocaleString("Text_color"));
        selTextColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellEditorPane.this.getValue().setTextColor(CellEditorPane.this.selectColor(CellEditorPane.this.getValue().getTextColor(), LocaleUtils.getEditorLocaleString("Select_text_color")));
                CellEditorPane.this.getMainEditor().fireLocalPropertyChange();
            }
        });
        return selTextColor;
    }

    public EditorDialog getFontEditorDialog() {
        return this.fontEditorDialog;
    }

    void updateState() {
        this.selCursorColorCash.setEnabled(this.getValue().isSelectable());
        this.updateEditorState();
    }

    protected abstract void generateInterface();

    protected abstract void updateEditorState();
}

