/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans;

import datechooser.beans.DateChooserVisual;
import datechooser.controller.EventHandlerMultiply;
import datechooser.events.CommitListener;
import datechooser.events.CursorMoveListener;
import datechooser.events.SelectionChangedListener;
import datechooser.model.DateChoose;
import datechooser.model.exeptions.IncompatibleDataExeption;
import datechooser.model.multiple.MultyDateChooseModel;
import datechooser.model.multiple.MultyModelBehavior;
import datechooser.model.multiple.Period;
import datechooser.model.multiple.PeriodSet;
import datechooser.view.CalendarPane;
import datechooser.view.WeekDaysStyle;
import datechooser.view.appearance.AppearancesList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.border.Border;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateChooserPanel
extends DateChooserVisual
implements PropertyChangeListener {
    public static final long serialVersionUID = -267882659809359160L;
    public static final String PANEL_PREFIX = "dch_panel_";
    public static final String PROPERTY_BORDER = "dch_panel_border";
    private MultyDateChooseModel model;
    private CalendarPane calendarPane = new CalendarPane();

    public DateChooserPanel() {
        this.model = new MultyDateChooseModel(new GregorianCalendar());
        this.calendarPane.initialize(this.model, new EventHandlerMultiply());
        this.calendarPane.setPreferredSize(new Dimension(250, 180));
        this.calendarPane.addPropertyChangeListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.calendarPane, "Center");
    }

    @Override
    public boolean isAutoScroll() {
        return this.model.isAutoScroll();
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.calendarPane.setLocale(locale);
    }

    public boolean isDateChooserPanelProperty(String name) {
        if (name == null) {
            return false;
        }
        return name.startsWith("dch_");
    }

    @Override
    public void setAutoScroll(boolean autoScroll) {
        boolean oldAutoScroll = this.isAutoScroll();
        this.model.setAutoScroll(autoScroll);
        this.firePropertyChange("dch_autoScroll", this.isAutoScroll(), autoScroll);
    }

    @Override
    public boolean isShowOneMonth() {
        return !this.model.isShowNeighbourMonth();
    }

    @Override
    public void setShowOneMonth(boolean showOneMonth) {
        boolean oldShowOneMonth = this.isShowOneMonth();
        this.model.setShowNeighbourMonth(!showOneMonth);
        this.firePropertyChange("dch_oneMonth", oldShowOneMonth, showOneMonth);
    }

    @Override
    public boolean isEnabled() {
        return this.model.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.isEnabled();
        this.model.setEnabled(enabled);
        this.firePropertyChange("dch_enabled", oldEnabled, enabled);
    }

    @Override
    public void setBorder(Border border) {
        Border oldBorder = this.getBorder();
        super.setBorder(border);
        this.firePropertyChange(PROPERTY_BORDER, oldBorder, this.getBorder());
    }

    @Override
    public MultyModelBehavior getBehavior() {
        return this.model.getBehavior();
    }

    @Override
    public void setBehavior(MultyModelBehavior behavior) {
        MultyModelBehavior oldBehavior = this.getBehavior();
        this.model.setBehavior(behavior);
        this.firePropertyChange("dch_behavior", (Object)oldBehavior, (Object)behavior);
    }

    @Override
    public AppearancesList getCurrentView() {
        return this.calendarPane.getAppearancesList();
    }

    @Override
    public void setCurrentView(AppearancesList aList) {
        this.calendarPane.setAppearancesList(aList);
    }

    @Override
    public PeriodSet getDefaultPeriods() {
        return this.model.getDefaultPeriodSet();
    }

    @Override
    public void setDefaultPeriods(PeriodSet periods) throws IncompatibleDataExeption {
        PeriodSet oldDefault = this.getDefaultPeriods();
        this.model.setDefaultPeriodSet(periods);
        this.firePropertyChange("dch_defaultDates", oldDefault, periods);
    }

    @Override
    public Iterable<Period> getSelection() {
        return this.model.getSelectedPeriods();
    }

    @Override
    public PeriodSet getSelectedPeriodSet() {
        return this.model.getSelectedPeriodSet();
    }

    @Override
    public Calendar getSelectedDate() {
        return this.model.getSelectedDate();
    }

    @Override
    public void setSelectedDate(Calendar aDate) {
        if (aDate == null) {
            this.model.selectNothing();
        } else {
            this.model.setSelectedDate(aDate);
        }
    }

    @Override
    public void setSelection(Iterable<Period> periods) {
        if (periods == null) {
            this.model.selectNothing();
        } else {
            this.model.setSelectedPeriods(periods);
        }
    }

    @Override
    public void setSelection(PeriodSet periods) {
        if (periods == null) {
            this.model.selectNothing();
        } else {
            this.model.setSelectedPeriods(periods);
        }
    }

    @Override
    public PeriodSet getForbiddenPeriods() {
        return this.model.getForbiddenSet();
    }

    @Override
    public void setForbiddenPeriods(PeriodSet periods) throws IncompatibleDataExeption {
        PeriodSet oldForbid = this.getForbiddenPeriods();
        this.model.setForbiddenSet(periods);
        this.firePropertyChange("dch_forbidDates", oldForbid, periods);
    }

    @Override
    public void setForbidden(Iterable<Period> forbiddenPeriods) {
        this.model.setForbidden(forbiddenPeriods);
    }

    @Override
    public Calendar getMaxDate() {
        return this.model.getMaxConstraint();
    }

    @Override
    public void setMaxDate(Calendar aDate) {
        Calendar oldMax = this.getMaxDate();
        this.model.setMaxConstraint(aDate);
        this.firePropertyChange("dch_maxDate", oldMax, aDate);
    }

    @Override
    public Calendar getMinDate() {
        return this.model.getMinConstraint();
    }

    @Override
    public void setMinDate(Calendar aDate) {
        Calendar oldMin = this.getMinDate();
        this.model.setMinConstraint(aDate);
        this.firePropertyChange("dch_minDate", oldMin, aDate);
    }

    @Override
    public void addCommitListener(CommitListener listener) {
        this.model.addCommitListener(listener);
    }

    @Override
    public void removeCommitListener(CommitListener listener) {
        this.model.removeCommitListener(listener);
    }

    @Override
    public void addSelectionChangedListener(SelectionChangedListener listener) {
        this.model.addSelectionChangedListener(listener);
    }

    @Override
    public void removeSelectionChangedListener(SelectionChangedListener listener) {
        this.model.removeSelectionChangedListener(listener);
    }

    @Override
    public void commit() {
        this.model.commit();
    }

    @Override
    public boolean isLocked() {
        return this.model.isLocked();
    }

    @Override
    public void setLocked(boolean lock) {
        boolean oldLock = this.isLocked();
        this.model.setLocked(lock);
        this.firePropertyChange("dch_locked", oldLock, lock);
    }

    @Override
    public void addCursorMoveListener(CursorMoveListener listener) {
        this.model.addCursorMoveListener(listener);
    }

    @Override
    public void removeCursorMoveListener(CursorMoveListener listener) {
        this.model.removeCursorMoveListener(listener);
    }

    @Override
    public Calendar getCurrent() {
        return this.model.getCurrent();
    }

    @Override
    public boolean setCurrent(Calendar aDate) {
        Calendar oldDate = this.getCurrent();
        if (aDate == null) {
            this.model.selectNothing();
            return true;
        }
        boolean result = this.model.select(aDate);
        this.firePropertyChange("dch_current", oldDate, aDate);
        return result;
    }

    @Override
    public void setNothingAllowed(boolean allow) {
        boolean oldAllow = this.isNothingAllowed();
        this.model.setNothingAllowed(allow);
        this.firePropertyChange("dch_nothingAllowed", oldAllow, allow);
    }

    @Override
    public boolean isNothingAllowed() {
        return this.model.isNothingAllowed();
    }

    @Override
    public Color getCalendarBackground() {
        return this.calendarPane.getGridBackground();
    }

    @Override
    public void setCalendarBackground(Color backColor) {
        Color was = this.getCalendarBackground();
        this.calendarPane.setGridBackground(backColor);
        this.firePropertyChange("dch_backgroundColor", was, backColor);
    }

    @Override
    public Dimension getCalendarPreferredSize() {
        return this.getPreferredSize();
    }

    @Override
    public void setCalendarPreferredSize(Dimension dim) {
        Dimension oldSize = this.getCalendarPreferredSize();
        this.setPreferredSize(dim);
        this.firePropertyChange("dch_calSize", oldSize, this.getCalendarPreferredSize());
    }

    @Override
    public WeekDaysStyle getWeekStyle() {
        return this.calendarPane.getWeekStyle();
    }

    @Override
    public void setWeekStyle(WeekDaysStyle weekStyle) {
        this.calendarPane.setWeekStyle(weekStyle);
    }

    @Override
    public Font getNavigateFont() {
        return this.calendarPane.getNavigateFont();
    }

    @Override
    public void setNavigateFont(Font font) {
        this.calendarPane.setNavigateFont(font);
    }

    @Override
    public int getCurrentNavigateIndex() {
        return this.calendarPane.getCurrentNavigateIndex();
    }

    @Override
    public void setCurrentNavigateIndex(int currentNavigateIndex) {
        this.calendarPane.setCurrentNavigateIndex(currentNavigateIndex);
    }

    public DateChoose getModel() {
        return this.model;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    @Override
    public AppearancesList getAppearancesList() {
        return this.calendarPane.getAppearancesList();
    }
}

