/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor;

import datechooser.beans.editor.VisualEditorCashed;
import datechooser.beans.editor.descriptor.DescriptionManager;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SimpleColorEditor
extends VisualEditorCashed
implements ColorSelectionModel {
    private Set<ChangeListener> changeListeners;

    protected JComponent createEditor() {
        this.changeListeners = new HashSet<ChangeListener>();
        JColorChooser editorPane = new JColorChooser(this);
        return editorPane;
    }

    public Color getSelectedColor() {
        return (Color)this.getValue();
    }

    public void setSelectedColor(Color color) {
        this.setValue(color);
        this.fireStateChange();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void fireStateChange() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener listener : this.changeListeners) {
            listener.stateChanged(e);
        }
    }

    public String getJavaInitializationString() {
        return DescriptionManager.describeJava(this.getValue(), Color.class);
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        Color color = (Color)this.getValue();
        gfx.setColor(color);
        gfx.fillRect(2, 2, box.height - 4, box.height - 4);
        gfx.setColor(Color.BLACK);
        gfx.drawRect(2, 2, box.height - 4, box.height - 4);
        gfx.drawString("[" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + "]", box.height + 2, box.height - 4);
    }
}

