/*
 * Decompiled with CFR 0.152.
 */
package Modelos.Dao;

import Modelos.Dao.CalificacionDao;
import Modelos.Entidades.Calificacion;
import Servicios.ConexionSQLite;
import Util.MsgLog;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.lang.exception.ExceptionUtils;
import vo.CalificacionVO;
import vo.ComportamientoVO;

public class CalificacionDaoImpl
extends ConexionSQLite
implements CalificacionDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarListaCalificacion(List<Calificacion> lilstaCalificacion) throws Exception {
        if (null != lilstaCalificacion && !lilstaCalificacion.isEmpty()) {
            try {
                String sql = " INSERT INTO calificacion(id, id_instructor, id_asignacion,id_esquema,nombre_esquema,id_periodo,nombre_periodo,promedio_anual_ec,reg_anio_inicio,tipo_promedio,id_usuario_creacion,promedio_anual,nota_examen_mejora,nota_anual_cualitativa,observacion, id_escenario, id_escenario_discrecion )  values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? )";
                this.Conectar();
                this.getConexion().setAutoCommit(false);
                PreparedStatement ps = this.getConexion().prepareStatement(sql);
                for (Calificacion calificacion : lilstaCalificacion) {
                    if (null == calificacion) continue;
                    ps.setInt(1, calificacion.getId());
                    ps.setObject(2, (Object)0, 4);
                    ps.setInt(3, calificacion.getIdAsignacion());
                    ps.setObject(4, (Object)calificacion.getIdEsquema(), 4);
                    ps.setString(5, "QUIMESTRAL");
                    ps.setInt(6, 1);
                    ps.setString(7, "SN");
                    ps.setString(8, calificacion.getPromedioAnualEc());
                    ps.setString(9, calificacion.getRegAnioInicio());
                    ps.setString(10, calificacion.getTipoPromedio());
                    ps.setObject(11, (Object)calificacion.getIdUsuarioCreacion(), 4);
                    ps.setObject(12, (Object)calificacion.getPromedioAnual(), 8);
                    ps.setObject(13, (Object)calificacion.getNotaExamenMejora(), 8);
                    ps.setString(14, calificacion.getNotaAnualCualitativa());
                    ps.setString(15, calificacion.getObservacion());
                    ps.setObject(16, (Object)calificacion.getIdEscenario(), 4);
                    ps.setObject(17, (Object)calificacion.getIdEscenarioDiscrecion(), 4);
                    ps.addBatch();
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (Exception e) {
                System.out.println("Modelos.Dao.CalificacionDaoImpl.guardarListaCalificacion()" + e);
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
            finally {
                this.cerrar();
            }
        }
    }

    @Override
    public List<CalificacionVO> recuperarCalificaciones(Integer idEscenario, Integer idEscenarioDiscrecion, Integer idParaleloCenso) throws Exception {
        ArrayList<CalificacionVO> listaNotas = new ArrayList<CalificacionVO>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT c.id_aplicacion as idCalificacion, c.promedio_anual as promedioAnual, a.nombre_apellido_estudiante as nombreApellidoEstudiante,");
            query.append(" n1.id_aplicacion as idNota1, n1.nota1 as nota1Nota1, n1.nota2 as nota2Nota1, ");
            query.append(" n1.nota3 as nota3Nota1, n1.promedio_nota as promedioNotaNota1, ");
            query.append(" n1.porcentaje_promedio as porcentajePromedioNota1, ");
            query.append(" n1.nota_examen as notaExamenNota1, ");
            query.append(" n1.porcentaje_examen as porcentajeExamenNota1, ");
            query.append(" n1.promedio as promedioNota1, ");
            query.append(" n1.promedio_ec as promedioEcNota1, ");
            query.append(" n1.nombre_modelo as nombreModeloNota1, ");
            query.append(" n2.id_aplicacion as idNota2, n2.nota1 as nota1Nota2, n2.nota2 as nota2Nota2, ");
            query.append(" n2.nota3 as nota3Nota2, n2.promedio_nota as promedioNotaNota2, ");
            query.append(" n2.porcentaje_promedio as porcentajePromedioNota2, ");
            query.append(" n2.nota_examen as notaExamenNota2, ");
            query.append(" n2.porcentaje_examen as porcentajeExamenNota2, ");
            query.append(" n2.promedio as promedioNota2, ");
            query.append(" n2.promedio_ec as promedioEcNota2, ");
            query.append(" n2.nombre_modelo as nombreModeloNota2, ");
            query.append(" c.nota_examen_mejora as notaExamenMejora, ");
            query.append(" s.id_aplicacion as idSupletorio, ");
            query.append(" s.nota_supletorio as notaSupletorio, ");
            query.append(" s.nota_remedial as notaRemedial, ");
            query.append(" s.nota_gracia as notaGracia, ");
            query.append(" a.id as idAsignacion ");
            query.append(" FROM asignacion a  ");
            query.append(" LEFT OUTER JOIN calificacion c on c.id_asignacion = a.id and c.id_escenario = ? ");
            if (idEscenarioDiscrecion == null || idEscenarioDiscrecion == 0) {
                query.append("and c.id_escenario_discrecion is null ");
            } else {
                query.append("and c.id_escenario_discrecion=? ");
            }
            query.append(" and tipo_promedio='Q' ");
            query.append(" LEFT OUTER JOIN nota n1 on n1.id_calificacion = c.id_aplicacion and n1.id_modelo = 2 ");
            query.append(" LEFT OUTER JOIN nota n2 on n2.id_calificacion = c.id_aplicacion and n2.id_modelo = 3 ");
            query.append(" LEFT OUTER JOIN supletorio s on s.id_calificacion = c.id_aplicacion ");
            query.append(" WHERE a.id_paralelo = ? order by a.nombre_apellido_estudiante; ");
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ps.setInt(1, idEscenario);
            if (idEscenarioDiscrecion == null || idEscenarioDiscrecion == 0) {
                ps.setInt(2, idParaleloCenso);
            } else {
                ps.setInt(2, idEscenarioDiscrecion);
                ps.setInt(3, idParaleloCenso);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                CalificacionVO instructor = new CalificacionVO();
                instructor.setIdCalificacion(rs.getInt("idCalificacion"));
                instructor.setPromedioAnual(rs.getBigDecimal("promedioAnual"));
                instructor.setNombreApellidoEstudiante(rs.getString("nombreApellidoEstudiante"));
                instructor.setIdNota1(rs.getInt("idNota1"));
                instructor.setNota1Nota1(rs.getBigDecimal("nota1Nota1"));
                instructor.setNota2Nota1(rs.getBigDecimal("nota2Nota1"));
                instructor.setNota3Nota1(rs.getBigDecimal("nota3Nota1"));
                instructor.setPromedioNotaNota1(rs.getBigDecimal("promedioNotaNota1"));
                instructor.setPorcentajePromedioNota1(rs.getBigDecimal("porcentajePromedioNota1"));
                instructor.setNotaExamenNota1(rs.getBigDecimal("notaExamenNota1"));
                instructor.setPorcentajeExamenNota1(rs.getBigDecimal("porcentajeExamenNota1"));
                instructor.setPromedioNota1(rs.getBigDecimal("promedioNota1"));
                instructor.setPromedioEcNota1(rs.getString("promedioEcNota1"));
                instructor.setNombreModeloNota1(rs.getString("nombreModeloNota1"));
                instructor.setIdNota2(rs.getInt("idNota2"));
                instructor.setNota1Nota2(rs.getBigDecimal("nota1Nota2"));
                instructor.setNota2Nota2(rs.getBigDecimal("nota2Nota2"));
                instructor.setNota3Nota2(rs.getBigDecimal("nota3Nota2"));
                instructor.setPromedioNotaNota2(rs.getBigDecimal("promedioNotaNota2"));
                instructor.setPorcentajePromedioNota2(rs.getBigDecimal("porcentajePromedioNota2"));
                instructor.setNotaExamenNota2(rs.getBigDecimal("notaExamenNota2"));
                instructor.setPorcentajeExamenNota2(rs.getBigDecimal("porcentajeExamenNota2"));
                instructor.setPromedioNota2(rs.getBigDecimal("promedioNota2"));
                instructor.setPromedioEcNota2(rs.getString("promedioEcNota2"));
                instructor.setNombreModeloNota1(rs.getString("nombreModeloNota2"));
                instructor.setNotaExamenMejora(rs.getBigDecimal("notaExamenMejora"));
                instructor.setIdSupletorio(rs.getInt("idSupletorio"));
                instructor.setNotaSupletorio(rs.getBigDecimal("notaSupletorio"));
                instructor.setNotaRemedial(rs.getBigDecimal("notaRemedial"));
                instructor.setNotaGracia(rs.getBigDecimal("notaGracia"));
                instructor.setIdAsignacion(rs.getInt("idAsignacion"));
                listaNotas.add(instructor);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.cerrar();
        }
        return listaNotas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean actualizarPromedio(Float promedio, Integer idCalificacion) throws Exception {
        boolean res = false;
        this.Conectar();
        String q = " UPDATE calificacion SET promedio_anual =" + promedio + " WHERE id_aplicacion= " + idCalificacion;
        try {
            PreparedStatement ps = this.getConexion().prepareStatement(q);
            ps.execute();
            res = true;
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            this.cerrar();
        }
        return res;
    }

    @Override
    public Calificacion obtenerNotaPorId(Integer idcalificacion) throws Exception {
        this.Conectar();
        Calificacion calificacion = new Calificacion();
        PreparedStatement ps = this.getConexion().prepareStatement("SELECT * FROM calificacion WHERE id_aplicacion =? ");
        ps.setInt(1, idcalificacion);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            calificacion.setIdAplicacion(rs.getInt("id_aplicacion"));
        }
        this.cerrar();
        return calificacion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarCalificacion(Calificacion calificacion) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " UPDATE calificacion set promedio_anual = ?, nota_examen_mejora = ?, id = ?, promedio_anual_ec = ?, id_usuario_creacion = ?, reg_anio_inicio = ?, tipo_promedio = ? where id_aplicacion= ? ";
        try {
            run.update(conn, sql, new Object[]{calificacion.getPromedioAnual(), calificacion.getNotaExamenMejora(), calificacion.getId(), calificacion.getPromedioAnualEc(), calificacion.getIdUsuarioCreacion(), calificacion.getRegAnioInicio(), calificacion.getTipoPromedio(), calificacion.getIdAplicacion()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarCualitativa(Calificacion calificacion) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " UPDATE calificacion set nota_anual_cualitativa = ?, reg_anio_inicio = ?, tipo_promedio = ?, observacion = ? where id_aplicacion= ? ";
        try {
            run.update(conn, sql, new Object[]{calificacion.getNotaAnualCualitativa(), calificacion.getRegAnioInicio(), calificacion.getTipoPromedio(), calificacion.getObservacion(), calificacion.getIdAplicacion()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public Calificacion buscarCalificacionPorAsignacionInstructor(Integer idAsignacion, Integer idEscenario, Integer idEscenarioDiscrecion) throws Exception {
        Calificacion calificacion = new Calificacion();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT a.id_aplicacion as idAplicacion , ");
            query.append(" a.id_esquema as idEsquema, ");
            query.append(" a.nombre_esquema as nombreEsquema, ");
            query.append(" a.id_periodo as idPeriodo, ");
            query.append(" a.nombre_periodo as nombrePeriodo, ");
            query.append(" a.tipo_promedio as tipoPromedio, ");
            query.append(" a.promedio_anual as promedioAnual, ");
            query.append(" a.promedio_anual_ec as promedioAnualEc, ");
            query.append(" a.observacion as observacion, ");
            query.append(" a.nota_examen_mejora as notaExamenMejora, ");
            query.append(" a.id_escenario as idEscenario, ");
            query.append(" a.id_escenario_discrecion as idEscenarioDiscrecion, ");
            query.append(" a.nota_anual_cualitativa as notaAnualCualitativa, ");
            query.append(" a.id as id ");
            query.append(" FROM calificacion a ");
            query.append(" WHERE a.id_asignacion=? ");
            query.append(" and a.id_escenario=? ");
            if (idEscenarioDiscrecion == null || idEscenarioDiscrecion == 0) {
                query.append("and a.id_escenario_discrecion is null ");
            } else {
                query.append("and a.id_escenario_discrecion=? ");
            }
            query.append(" and a.tipo_promedio='Q' ");
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ps.setInt(1, idAsignacion);
            if (idEscenarioDiscrecion == null || idEscenarioDiscrecion == 0) {
                ps.setInt(2, idEscenario);
            } else {
                ps.setInt(2, idEscenario);
                ps.setInt(3, idEscenarioDiscrecion);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                calificacion = new Calificacion();
                calificacion.setIdAplicacion(rs.getInt("idAplicacion"));
                calificacion.setIdEsquema(rs.getInt("idEsquema"));
                calificacion.setNombreEsquema(rs.getString("nombreEsquema"));
                calificacion.setIdPeriodo(rs.getInt("idPeriodo"));
                calificacion.setNombreEsquema(rs.getString("nombrePeriodo"));
                calificacion.setTipoPromedio(rs.getString("tipoPromedio"));
                calificacion.setPromedioAnual(rs.getBigDecimal("promedioAnual"));
                calificacion.setPromedioAnualEc(rs.getString("promedioAnualEc"));
                calificacion.setObservacion(rs.getString("observacion"));
                calificacion.setNotaExamenMejora(rs.getBigDecimal("notaExamenMejora"));
                calificacion.setIdEscenario(rs.getInt("idEscenario"));
                calificacion.setIdEscenarioDiscrecion(rs.getInt("idEscenarioDiscrecion"));
                calificacion.setNotaAnualCualitativa(rs.getString("notaAnualCualitativa"));
                calificacion.setId(rs.getInt("id"));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.cerrar();
        }
        return calificacion;
    }

    @Override
    public Calificacion buscarCalificacionPorAsignacionInstructorRecomendaciones(Integer idAsignacion, Integer idEscenario, Integer idEscenarioDiscrecion) throws Exception {
        Calificacion calificacion = new Calificacion();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT a.id_aplicacion as idAplicacion , ");
            query.append(" a.id_esquema as idEsquema, ");
            query.append(" a.nombre_esquema as nombreEsquema, ");
            query.append(" a.id_periodo as idPeriodo, ");
            query.append(" a.nombre_periodo as nombrePeriodo, ");
            query.append(" a.tipo_promedio as tipoPromedio, ");
            query.append(" a.promedio_anual as promedioAnual, ");
            query.append(" a.promedio_anual_ec as promedioAnualEc, ");
            query.append(" a.observacion as observacion, ");
            query.append(" a.nota_examen_mejora as notaExamenMejora, ");
            query.append(" a.id_escenario as idEscenario, ");
            query.append(" a.id_escenario_discrecion as idEscenarioDiscrecion, ");
            query.append(" a.id as id ");
            query.append(" FROM calificacion a ");
            query.append(" WHERE a.id_asignacion=? ");
            query.append(" and a.tipo_promedio='Q' ");
            query.append(" and a.id_escenario=? ");
            if (idEscenarioDiscrecion.equals(0)) {
                query.append(" and a.id_escenario_discrecion is null ");
            } else {
                query.append(" and a.id_escenario_discrecion=? ");
            }
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ps.setInt(1, idAsignacion);
            ps.setInt(2, idEscenario);
            if (!idEscenarioDiscrecion.equals(0)) {
                ps.setInt(3, idEscenarioDiscrecion);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                calificacion = new Calificacion();
                calificacion.setIdAplicacion(rs.getInt("idAplicacion"));
                calificacion.setIdEsquema(rs.getInt("idEsquema"));
                calificacion.setNombreEsquema(rs.getString("nombreEsquema"));
                calificacion.setIdPeriodo(rs.getInt("idPeriodo"));
                calificacion.setNombreEsquema(rs.getString("nombrePeriodo"));
                calificacion.setTipoPromedio(rs.getString("tipoPromedio"));
                calificacion.setPromedioAnual(rs.getBigDecimal("promedioAnual"));
                calificacion.setPromedioAnualEc(rs.getString("promedioAnualEc"));
                calificacion.setObservacion(rs.getString("observacion"));
                calificacion.setNotaExamenMejora(rs.getBigDecimal("notaExamenMejora"));
                calificacion.setIdEscenario(rs.getInt("idEscenario"));
                calificacion.setIdEscenarioDiscrecion(rs.getInt("idEscenarioDiscrecion"));
                calificacion.setId(rs.getInt("id"));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.cerrar();
        }
        return calificacion;
    }

    @Override
    public Calificacion buscarCalificacionPorAsignacionInstructorComportamiento(Integer idAsignacion) throws Exception {
        Calificacion calificacion = new Calificacion();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT a.id_aplicacion as idAplicacion , ");
            query.append(" a.id_esquema as idEsquema, ");
            query.append(" a.nombre_esquema as nombreEsquema, ");
            query.append(" a.id_periodo as idPeriodo, ");
            query.append(" a.nombre_periodo as nombrePeriodo, ");
            query.append(" a.tipo_promedio as tipoPromedio, ");
            query.append(" a.promedio_anual as promedioAnual, ");
            query.append(" a.promedio_anual_ec as promedioAnualEc, ");
            query.append(" a.observacion as observacion, ");
            query.append(" a.nota_examen_mejora as notaExamenMejora, ");
            query.append(" a.id_escenario as idEscenario, ");
            query.append(" a.id_escenario_discrecion as idEscenarioDiscrecion, ");
            query.append(" a.nota_anual_cualitativa as notaAnualCualitativa, ");
            query.append(" a.id as id ");
            query.append(" FROM calificacion a ");
            query.append(" WHERE a.id_asignacion=? ");
            query.append(" and a.tipo_promedio='C' ");
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ps.setInt(1, idAsignacion);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                calificacion = new Calificacion();
                calificacion.setIdAplicacion(rs.getInt("idAplicacion"));
                calificacion.setIdEsquema(rs.getInt("idEsquema"));
                calificacion.setNombreEsquema(rs.getString("nombreEsquema"));
                calificacion.setIdPeriodo(rs.getInt("idPeriodo"));
                calificacion.setNombreEsquema(rs.getString("nombrePeriodo"));
                calificacion.setTipoPromedio(rs.getString("tipoPromedio"));
                calificacion.setPromedioAnual(rs.getBigDecimal("promedioAnual"));
                calificacion.setPromedioAnualEc(rs.getString("promedioAnualEc"));
                calificacion.setObservacion(rs.getString("observacion"));
                calificacion.setNotaExamenMejora(rs.getBigDecimal("notaExamenMejora"));
                calificacion.setIdEscenario(rs.getInt("idEscenario"));
                calificacion.setIdEscenarioDiscrecion(rs.getInt("idEscenarioDiscrecion"));
                calificacion.setNotaAnualCualitativa(rs.getString("notaAnualCualitativa"));
                calificacion.setId(rs.getInt("id"));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.cerrar();
        }
        return calificacion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarCalificacion(Calificacion calificacion) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " INSERT INTO calificacion(id_asignacion,id_instructor,id_esquema,nombre_esquema,id_periodo,nombre_periodo,promedio_anual_ec,id_usuario_creacion,reg_anio_inicio,tipo_promedio,promedio_anual, id_escenario, id_escenario_discrecion )  values(?,?,?,?,?,?,?,?,?,?,?,?,? )";
        try {
            run.update(conn, sql, new Object[]{calificacion.getAsignacion().getId(), 0, calificacion.getIdEsquema(), calificacion.getNombreEsquema(), calificacion.getIdPeriodo(), calificacion.getNombrePeriodo(), calificacion.getPromedioAnualEc(), calificacion.getIdUsuarioCreacion(), calificacion.getRegAnioInicio(), calificacion.getTipoPromedio(), calificacion.getPromedioAnual(), calificacion.getIdEscenario(), calificacion.getIdEscenarioDiscrecion()});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public List<Calificacion> obtenerPorParalelo(Integer idEscenario, Integer idEscenarioDiscrecion) throws Exception {
        ArrayList<Calificacion> calificaciones = new ArrayList<Calificacion>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT a.id_aplicacion as idAplicacion , ");
            query.append(" a.id_esquema as idEsquema, ");
            query.append(" a.nombre_esquema as nombreEsquema, ");
            query.append(" a.id_periodo as idPeriodo, ");
            query.append(" a.nombre_periodo as nombrePeriodo, ");
            query.append(" a.tipo_promedio as tipoPromedio, ");
            query.append(" a.promedio_anual as promedioAnual, ");
            query.append(" a.promedio_anual_ec as promedioAnualEc, ");
            query.append(" a.observacion as observacion, ");
            query.append(" a.nota_examen_mejora as notaExamenMejora, ");
            query.append(" a.id_usuario_creacion as idUsuarioCreacion, ");
            query.append(" null as idInstructor, ");
            query.append(" c.id as idAsignacion, ");
            query.append(" a.id as id, ");
            query.append(" a.nota_anual_cualitativa as notaAnualCualitativa, ");
            query.append(" a.reg_anio_inicio as regAnioInicio, ");
            query.append(" a.id_escenario as idEscenario, ");
            query.append(" a.id_escenario_discrecion as idEscenarioDiscrecion ");
            query.append(" FROM calificacion a ");
            query.append(" join asignacion c on c.id=a.id_asignacion ");
            query.append(" where  a.id_escenario=? ");
            query.append(" and a.reg_anio_inicio is not null ");
            if (idEscenarioDiscrecion == null || idEscenarioDiscrecion == 0) {
                query.append(" and a.id_escenario_discrecion is null ");
            } else {
                query.append(" and a.id_escenario_discrecion=? ");
            }
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ps.setInt(1, idEscenario);
            if (idEscenarioDiscrecion != null && idEscenarioDiscrecion != 0) {
                ps.setInt(2, idEscenarioDiscrecion);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Calificacion calificacion = new Calificacion();
                calificacion.setIdAplicacion(rs.getInt("idAplicacion"));
                calificacion.setIdEsquema(rs.getInt("idEsquema"));
                calificacion.setNombreEsquema(rs.getString("nombreEsquema"));
                calificacion.setIdPeriodo(rs.getInt("idPeriodo"));
                calificacion.setNombreEsquema(rs.getString("nombrePeriodo"));
                calificacion.setTipoPromedio(rs.getString("tipoPromedio"));
                calificacion.setPromedioAnual(rs.getBigDecimal("promedioAnual"));
                calificacion.setPromedioAnualEc(rs.getString("promedioAnualEc"));
                calificacion.setObservacion(rs.getString("observacion"));
                calificacion.setNotaExamenMejora(rs.getBigDecimal("notaExamenMejora"));
                calificacion.setIdUsuarioCreacion(rs.getInt("idUsuarioCreacion"));
                calificacion.setIdInstructor(rs.getInt("idInstructor"));
                calificacion.setIdAsignacion(rs.getInt("idAsignacion"));
                calificacion.setId(rs.getInt("id"));
                calificacion.setRegAnioInicio(rs.getString("regAnioInicio"));
                calificacion.setNotaAnualCualitativa(rs.getString("notaAnualCualitativa"));
                calificacion.setIdEscenario(rs.getInt("idEscenario"));
                calificacion.setIdEscenarioDiscrecion(rs.getInt("idEscenarioDiscrecion"));
                calificaciones.add(calificacion);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.cerrar();
        }
        return calificaciones;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ComportamientoVO> recuperarCalificacionesCualitativas(Integer idInstructor, Integer idParaleloCenso) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ComportamientoVO.class);
        List<ComportamientoVO> asistencia = new ArrayList<ComportamientoVO>();
        try {
            asistencia = (List)run.query(conn, "SELECT c.id_aplicacion as idCalificacion, c.promedio_anual as promedioAnual, a.nombre_apellido_estudiante as nombreApellidoEstudiante, n1.id_aplicacion as idNota1, n1.nota1 as nota1Nota1, n1.nota2 as nota2Nota1,  n1.nota3 as nota3Nota1, n1.nota_quimestre as notaQuimestreNota1, n1.nombre_modelo as nombreModeloNota1, n2.id_aplicacion as idNota2, n2.nota1 as nota1Nota2, n2.nota2 as nota2Nota2, n2.nota3 as nota3Nota2, n2.nota_quimestre as notaQuimestreNota2,  n2.nombre_modelo as nombreModeloNota2, c.nota_anual_cualitativa as notaCualitativa,a.id as idAsignacion FROM asignacion a LEFT OUTER JOIN calificacion c on c.id_asignacion = a.id and c.id_escenario = ? and tipo_promedio='Q'LEFT OUTER JOIN nota_cualitativa n1 on n1.id_calificacion = c.id_aplicacion and n1.id_modelo = 2 LEFT OUTER JOIN nota_cualitativa n2 on n2.id_calificacion = c.id_aplicacion and n2.id_modelo = 3 WHERE a.id_paralelo = ? order by a.nombre_apellido_estudiante; ", (ResultSetHandler)handler, new Object[]{idInstructor, idParaleloCenso});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return asistencia;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ComportamientoVO> recuperarCalificacionesCualitativasComportamiento(Integer idParaleloCenso) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ComportamientoVO.class);
        List<ComportamientoVO> asistencia = new ArrayList<ComportamientoVO>();
        try {
            asistencia = (List)run.query(conn, "SELECT c.id_aplicacion as idCalificacion, c.promedio_anual as promedioAnual, a.nombre_apellido_estudiante as nombreApellidoEstudiante, n1.id_aplicacion as idNota1, n1.nota1 as nota1Nota1, n1.nota2 as nota2Nota1,  n1.nota3 as nota3Nota1, n1.nota_quimestre as notaQuimestreNota1, n1.nombre_modelo as nombreModeloNota1, n2.id_aplicacion as idNota2, n2.nota1 as nota1Nota2, n2.nota2 as nota2Nota2, n2.nota3 as nota3Nota2, n2.nota_quimestre as notaQuimestreNota2,  n2.nombre_modelo as nombreModeloNota2, c.nota_anual_cualitativa as notaCualitativa,a.id as idAsignacion FROM asignacion a LEFT OUTER JOIN calificacion c on c.id_asignacion = a.id and c.tipo_promedio='C'LEFT OUTER JOIN nota_cualitativa n1 on n1.id_calificacion = c.id_aplicacion and n1.id_modelo = 2 LEFT OUTER JOIN nota_cualitativa n2 on n2.id_calificacion = c.id_aplicacion and n2.id_modelo = 3 WHERE a.id_paralelo = ? order by a.nombre_apellido_estudiante; ", (ResultSetHandler)handler, new Object[]{idParaleloCenso});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return asistencia;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ComportamientoVO> recuperarRecomendaciones(Integer idEscenario, Integer idParaleloCenso) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ComportamientoVO.class);
        List<ComportamientoVO> asistencia = new ArrayList<ComportamientoVO>();
        try {
            asistencia = (List)run.query(conn, "SELECT c.id_aplicacion as idCalificacion, c.promedio_anual as promedioAnual, a.nombre_apellido_estudiante as nombreApellidoEstudiante, n1.id_aplicacion as idNota1, n1.recomendacion1 as nota1Nota1, n1.recomendacion2 as nota2Nota1,  n1.recomendacion3 as nota3Nota1, n1.recomendacion_quimestre as notaQuimestreNota1, n1.nombre_modelo as nombreModeloNota1, n2.id_aplicacion as idNota2, n2.recomendacion1 as nota1Nota2, n2.recomendacion2 as nota2Nota2, n2.recomendacion3 as nota3Nota2, n2.recomendacion_quimestre as notaQuimestreNota2,  n2.nombre_modelo as nombreModeloNota2, c.nota_anual_cualitativa as notaCualitativa,a.id as idAsignacion, c.observacion as observacion FROM asignacion a LEFT OUTER JOIN calificacion c on c.id_asignacion = a.id and c.id_escenario = ? and c.tipo_promedio='Q'LEFT OUTER JOIN recomendacion n1 on n1.id_calificacion = c.id_aplicacion and n1.id_modelo = 2 LEFT OUTER JOIN recomendacion n2 on n2.id_calificacion = c.id_aplicacion and n2.id_modelo = 3 WHERE a.id_paralelo = ? order by a.nombre_apellido_estudiante; ", (ResultSetHandler)handler, new Object[]{idEscenario, idParaleloCenso});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return asistencia;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarNotaSincronizacion(Calificacion calificacion) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " UPDATE calificacion set id = ?,codigo_error = ? where id_aplicacion =? ";
        try {
            run.update(conn, sql, new Object[]{calificacion.getId(), calificacion.getCodigoError(), calificacion.getIdAplicacion()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public List<Calificacion> buscarTodo() throws Exception {
        ArrayList<Calificacion> calificaciones = new ArrayList<Calificacion>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT a.id_aplicacion as idAplicacion , ");
            query.append(" a.id_esquema as idEsquema, ");
            query.append(" a.nombre_esquema as nombreEsquema, ");
            query.append(" a.id_periodo as idPeriodo, ");
            query.append(" a.nombre_periodo as nombrePeriodo, ");
            query.append(" a.tipo_promedio as tipoPromedio, ");
            query.append(" a.promedio_anual as promedioAnual, ");
            query.append(" a.promedio_anual_ec as promedioAnualEc, ");
            query.append(" a.observacion as observacion, ");
            query.append(" a.nota_examen_mejora as notaExamenMejora, ");
            query.append(" a.id_usuario_creacion as idUsuarioCreacion, ");
            query.append(" i.id as idInstructor, ");
            query.append(" c.id as idAsignacion, ");
            query.append(" a.id as id, ");
            query.append(" a.nota_anual_cualitativa as notaAnualCualitativa, ");
            query.append(" a.reg_anio_inicio as regAnioInicio, ");
            query.append(" i.id_escenario as idEscenario, ");
            query.append(" i.id_escenario_discrecion as idEscenarioDiscrecion ");
            query.append(" FROM calificacion a ");
            query.append(" join instructor i on i.id=a.id_instructor ");
            query.append(" join asignacion c on c.id=a.id_asignacion ");
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Calificacion calificacion = new Calificacion();
                calificacion.setIdAplicacion(rs.getInt("idAplicacion"));
                calificacion.setIdEsquema(rs.getInt("idEsquema"));
                calificacion.setNombreEsquema(rs.getString("nombreEsquema"));
                calificacion.setIdPeriodo(rs.getInt("idPeriodo"));
                calificacion.setNombreEsquema(rs.getString("nombrePeriodo"));
                calificacion.setTipoPromedio(rs.getString("tipoPromedio"));
                calificacion.setPromedioAnual(rs.getBigDecimal("promedioAnual"));
                calificacion.setPromedioAnualEc(rs.getString("promedioAnualEc"));
                calificacion.setObservacion(rs.getString("observacion"));
                calificacion.setNotaExamenMejora(rs.getBigDecimal("notaExamenMejora"));
                calificacion.setIdUsuarioCreacion(rs.getInt("idUsuarioCreacion"));
                calificacion.setIdInstructor(rs.getInt("idInstructor"));
                calificacion.setIdAsignacion(rs.getInt("idAsignacion"));
                calificacion.setId(rs.getInt("id"));
                calificacion.setRegAnioInicio(rs.getString("regAnioInicio"));
                calificacion.setNotaAnualCualitativa(rs.getString("notaAnualCualitativa"));
                calificacion.setIdEscenario(rs.getInt("idEscenario"));
                calificacion.setIdEscenarioDiscrecion(rs.getInt("idEscenarioDiscrecion"));
                calificaciones.add(calificacion);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.cerrar();
        }
        return calificaciones;
    }

    @Override
    public List<Calificacion> buscarSoloCalificacionesComportamiento(Integer idParaleloCenso) throws Exception {
        ArrayList<Calificacion> calificaciones = new ArrayList<Calificacion>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT a.id_aplicacion as idAplicacion , ");
            query.append(" a.id_esquema as idEsquema, ");
            query.append(" a.nombre_esquema as nombreEsquema, ");
            query.append(" a.id_periodo as idPeriodo, ");
            query.append(" a.nombre_periodo as nombrePeriodo, ");
            query.append(" a.tipo_promedio as tipoPromedio, ");
            query.append(" a.promedio_anual as promedioAnual, ");
            query.append(" a.promedio_anual_ec as promedioAnualEc, ");
            query.append(" a.observacion as observacion, ");
            query.append(" a.nota_examen_mejora as notaExamenMejora, ");
            query.append(" a.id_usuario_creacion as idUsuarioCreacion, ");
            query.append(" null as idInstructor, ");
            query.append(" c.id as idAsignacion, ");
            query.append(" a.id as id, ");
            query.append(" a.nota_anual_cualitativa as notaAnualCualitativa, ");
            query.append(" a.reg_anio_inicio as regAnioInicio, ");
            query.append(" a.id_escenario as idEscenario, ");
            query.append(" a.id_escenario_discrecion as idEscenarioDiscrecion ");
            query.append(" FROM calificacion a ");
            query.append(" join asignacion c on c.id=a.id_asignacion ");
            query.append(" where  c.id_paralelo=? ");
            query.append(" and a.tipo_promedio='C' ");
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ps.setInt(1, idParaleloCenso);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Calificacion calificacion = new Calificacion();
                calificacion.setIdAplicacion(rs.getInt("idAplicacion"));
                calificacion.setIdEsquema(rs.getInt("idEsquema"));
                calificacion.setNombreEsquema(rs.getString("nombreEsquema"));
                calificacion.setIdPeriodo(rs.getInt("idPeriodo"));
                calificacion.setNombreEsquema(rs.getString("nombrePeriodo"));
                calificacion.setTipoPromedio(rs.getString("tipoPromedio"));
                calificacion.setPromedioAnual(rs.getBigDecimal("promedioAnual"));
                calificacion.setPromedioAnualEc(rs.getString("promedioAnualEc"));
                calificacion.setObservacion(rs.getString("observacion"));
                calificacion.setNotaExamenMejora(rs.getBigDecimal("notaExamenMejora"));
                calificacion.setIdUsuarioCreacion(rs.getInt("idUsuarioCreacion"));
                calificacion.setIdInstructor(rs.getInt("idInstructor"));
                calificacion.setIdAsignacion(rs.getInt("idAsignacion"));
                calificacion.setId(rs.getInt("id"));
                calificacion.setRegAnioInicio(rs.getString("regAnioInicio"));
                calificacion.setNotaAnualCualitativa(rs.getString("notaAnualCualitativa"));
                calificacion.setIdEscenario(rs.getInt("idEscenario"));
                calificacion.setIdEscenarioDiscrecion(rs.getInt("idEscenarioDiscrecion"));
                calificaciones.add(calificacion);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.cerrar();
        }
        return calificaciones;
    }
}

