/*
 * Decompiled with CFR 0.152.
 */
package Modelos.Dao;

import Modelos.Dao.JustificacionEducacionBasicaDao;
import Modelos.Entidades.JusticacionEducacionBasica;
import Servicios.ConexionSQLite;
import Util.MsgLog;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.lang.exception.ExceptionUtils;

public class JustificacionEducacionBasicaDaoImpl
extends ConexionSQLite
implements JustificacionEducacionBasicaDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarAsistencia(JusticacionEducacionBasica asistencia) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " INSERT INTO justicacion_educacion_basica(id_asignacion, id_mes,justificada,reg_anio_inicio, estado,observacion_justificacion,id_usuario_creacion,fecha )  values(?,?,?,?,?,?,?,? )";
        try {
            run.update(conn, sql, new Object[]{asistencia.getIdAsignacion(), asistencia.getIdMes(), asistencia.getJustificada(), asistencia.getRegAnioInicio(), asistencia.getEstado(), asistencia.getObservacionJustificacion(), asistencia.getIdUsuarioCreacion(), asistencia.getFecha()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarAsistencia(JusticacionEducacionBasica asistencia) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " UPDATE justicacion_educacion_basica set id_asignacion = ?, id_mes=?,justificada = ?, reg_anio_inicio = ?, observacion_justificacion=?,fecha = ?, id= ?, id_usuario_creacion= ?, codigo_error = ?  where id_aplicacion= ? ";
        try {
            run.update(conn, sql, new Object[]{asistencia.getIdAsignacion(), asistencia.getIdMes(), asistencia.getJustificada(), asistencia.getRegAnioInicio(), asistencia.getObservacionJustificacion(), asistencia.getFecha(), asistencia.getId(), asistencia.getIdUsuarioCreacion(), asistencia.getCodigoError(), asistencia.getIdAplicacion()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JusticacionEducacionBasica buscarAsistenciaEstudiantePorDiaAsignacion(Integer codigoAsignacion, String fechaAsistencia) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(JusticacionEducacionBasica.class);
        JusticacionEducacionBasica asistenciaEstudiante = null;
        try {
            asistenciaEstudiante = (JusticacionEducacionBasica)run.query(conn, "SELECT at.id_asignacion as idAsignacion, at.id_mes as idMes, at.justificada as justificada, at.id_aplicacion as idAplicacion, at.estado as estado, at.fecha as fecha, at.codigo_error as codigoError, at.id as id, at.reg_anio_inicio as regAnioInicio, at.id_usuario_creacion as idUsuarioCreacion, at.observacion_justificacion as observacionJustificacion  FROM asignacion a, justicacion_educacion_basica at WHERE  at.id_asignacion = ? and at.fecha=? and a.id = at.id_asignacion  order by a.nombre_apellido_estudiante asc ", (ResultSetHandler)handler, new Object[]{codigoAsignacion, fechaAsistencia});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return asistenciaEstudiante;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JusticacionEducacionBasica> listarJustificacionEstudiante(Integer codigoAsignacion) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(JusticacionEducacionBasica.class);
        List<JusticacionEducacionBasica> justificacion = new ArrayList<JusticacionEducacionBasica>();
        try {
            justificacion = (List)run.query(conn, "SELECT at.id_asignacion as idAsignacion, at.id_mes as idMes, at.justificada as justificada, at.id_aplicacion as idAplicacion, at.estado as estado, at.fecha as fecha, at.codigo_error as codigoError, at.id as id, at.reg_anio_inicio as regAnioInicio, at.id_usuario_creacion as idUsuarioCreacion, at.observacion_justificacion as observacionJustificacion  FROM asignacion a, justicacion_educacion_basica at WHERE  at.id_asignacion = ? and a.id = at.id_asignacion  order by a.nombre_apellido_estudiante asc ", (ResultSetHandler)handler, new Object[]{codigoAsignacion});
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return justificacion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JusticacionEducacionBasica> buscarAsistenciaPorParalelo(Integer codigoParalelo) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(JusticacionEducacionBasica.class);
        List<JusticacionEducacionBasica> justificacion = new ArrayList<JusticacionEducacionBasica>();
        try {
            justificacion = (List)run.query(conn, "SELECT at.id_asignacion as idAsignacion, at.id_mes as idMes, at.justificada as justificada, at.id_aplicacion as idAplicacion, at.estado as estado, at.fecha as fecha, at.codigo_error as codigoError, at.id as id, at.reg_anio_inicio as regAnioInicio, at.id_usuario_creacion as idUsuarioCreacion, at.observacion_justificacion as observacionJustificacion  FROM asignacion a, justicacion_educacion_basica at WHERE  a.id_paralelo = ? and justificada=1 and a.id = at.id_asignacion ", (ResultSetHandler)handler, new Object[]{codigoParalelo});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return justificacion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarJustificacionSincronizacion(JusticacionEducacionBasica justificacion) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " UPDATE justicacion_educacion_basica set id = ?,codigo_error = ? where id_aplicacion =? ";
        try {
            run.update(conn, sql, new Object[]{justificacion.getId(), justificacion.getCodigoError(), justificacion.getIdAplicacion()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarListaJustificacion(List<JusticacionEducacionBasica> listaJustificacion) throws Exception {
        if (null != listaJustificacion && !listaJustificacion.isEmpty()) {
            try {
                String sql = " INSERT INTO justicacion_educacion_basica(id, id_asignacion, id_mes,justificada,reg_anio_inicio, estado,observacion_justificacion,id_usuario_creacion,fecha )  values(?,?,?,?,?,?,?,?,? )";
                this.Conectar();
                PreparedStatement ps = this.getConexion().prepareStatement(sql);
                for (JusticacionEducacionBasica justificacion : listaJustificacion) {
                    if (null == justificacion) continue;
                    ps.setInt(1, justificacion.getId());
                    ps.setInt(2, justificacion.getIdAsignacion());
                    ps.setInt(3, justificacion.getIdMes());
                    ps.setObject(4, (Object)justificacion.getJustificada(), 16);
                    ps.setString(5, justificacion.getRegAnioInicio());
                    ps.setString(6, justificacion.getEstado());
                    ps.setString(7, justificacion.getObservacionJustificacion());
                    ps.setObject(8, (Object)justificacion.getIdUsuarioCreacion(), 4);
                    ps.setString(9, justificacion.getFecha());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            catch (SQLException e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
            finally {
                this.cerrar();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JusticacionEducacionBasica buscarXEstudianteXFechaXMes(Integer codigoAsignacion, Integer codigoMes, String fecha) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(JusticacionEducacionBasica.class);
        JusticacionEducacionBasica justificacion = new JusticacionEducacionBasica();
        try {
            justificacion = (JusticacionEducacionBasica)run.query(conn, "SELECT at.id_asignacion as idAsignacion, at.id_mes as idMes, at.justificada as justificada, at.id_aplicacion as idAplicacion, at.estado as estado, at.fecha as fecha, at.codigo_error as codigoError, at.id as id, at.reg_anio_inicio as regAnioInicio, at.id_usuario_creacion as idUsuarioCreacion, at.observacion_justificacion as observacionJustificacion  FROM asignacion a, justicacion_educacion_basica at WHERE  at.id_asignacion = ?  and at.id_mes = ?  and at.fecha like ?  and a.id = at.id_asignacion ", (ResultSetHandler)handler, new Object[]{codigoAsignacion, codigoMes, fecha});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return justificacion;
    }
}

