/*
 * Decompiled with CFR 0.152.
 */
package Modelos.Dao;

import Modelos.Dao.NotaInsumoDao;
import Modelos.Entidades.NotaInsumo;
import Servicios.ConexionSQLite;
import Util.MsgLog;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.lang.exception.ExceptionUtils;

public class NotaInsumoDaoImpl
extends ConexionSQLite
implements NotaInsumoDao {
    @Override
    public NotaInsumo buscarPorNota(Integer idNota) throws Exception {
        NotaInsumo notaInsumo = new NotaInsumo();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT r.id , ");
            query.append(" r.id_aplicacion as idAplicacion, ");
            query.append(" r.nota1_1 as nota11, ");
            query.append(" r.nota1_2 as nota12, ");
            query.append(" r.nota1_3 as nota13, ");
            query.append(" r.nota1_4 as nota14, ");
            query.append(" r.nota1_5 as nota15, ");
            query.append(" r.nota2_1 as nota21, ");
            query.append(" r.nota2_2 as nota22, ");
            query.append(" r.nota2_3 as nota23, ");
            query.append(" r.nota2_4 as nota24, ");
            query.append(" r.nota2_5 as nota25, ");
            query.append(" r.nota3_1 as nota31, ");
            query.append(" r.nota3_2 as nota32, ");
            query.append(" r.nota3_3 as nota33, ");
            query.append(" r.nota3_4 as nota34, ");
            query.append(" r.nota3_5 as nota35, ");
            query.append(" r.estado as estado, ");
            query.append(" r.id_usuario_creacion as idUsuarioCreacion ");
            query.append(" FROM nota_insumo r ");
            query.append(" WHERE r.id_nota = ? ");
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ps.setInt(1, idNota);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                notaInsumo = new NotaInsumo();
                notaInsumo.setId(rs.getInt("id"));
                notaInsumo.setIdAplicacion(rs.getInt("idAplicacion"));
                notaInsumo.setNota11(rs.getBigDecimal("nota11"));
                notaInsumo.setNota12(rs.getBigDecimal("nota12"));
                notaInsumo.setNota13(rs.getBigDecimal("nota13"));
                notaInsumo.setNota14(rs.getBigDecimal("nota14"));
                notaInsumo.setNota15(rs.getBigDecimal("nota15"));
                notaInsumo.setNota21(rs.getBigDecimal("nota21"));
                notaInsumo.setNota22(rs.getBigDecimal("nota22"));
                notaInsumo.setNota23(rs.getBigDecimal("nota23"));
                notaInsumo.setNota24(rs.getBigDecimal("nota24"));
                notaInsumo.setNota25(rs.getBigDecimal("nota25"));
                notaInsumo.setNota31(rs.getBigDecimal("nota31"));
                notaInsumo.setNota32(rs.getBigDecimal("nota32"));
                notaInsumo.setNota33(rs.getBigDecimal("nota33"));
                notaInsumo.setNota34(rs.getBigDecimal("nota34"));
                notaInsumo.setNota35(rs.getBigDecimal("nota35"));
                notaInsumo.setEstado(rs.getString("estado"));
                notaInsumo.setIdUsuarioCreacion(rs.getInt("idUsuarioCreacion"));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.cerrar();
        }
        return notaInsumo;
    }

    @Override
    public List<NotaInsumo> obtenerPorParalelo(Integer idParalelo) throws Exception {
        ArrayList<NotaInsumo> notaInsumos = new ArrayList<NotaInsumo>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT r.id , ");
            query.append(" r.id_aplicacion as idAplicacion, ");
            query.append(" r.nota1_1 as nota11, ");
            query.append(" r.nota1_2 as nota12, ");
            query.append(" r.nota1_3 as nota13, ");
            query.append(" r.nota1_4 as nota14, ");
            query.append(" r.nota1_5 as nota15, ");
            query.append(" r.nota2_1 as nota21, ");
            query.append(" r.nota2_2 as nota22, ");
            query.append(" r.nota2_3 as nota23, ");
            query.append(" r.nota2_4 as nota24, ");
            query.append(" r.nota2_5 as nota25, ");
            query.append(" r.nota3_1 as nota31, ");
            query.append(" r.nota3_2 as nota32, ");
            query.append(" r.nota3_3 as nota33, ");
            query.append(" r.nota3_4 as nota34, ");
            query.append(" r.nota3_5 as nota35, ");
            query.append(" r.estado as estado, ");
            query.append(" r.id_usuario_creacion as idUsuarioCreacion, ");
            query.append(" r.reg_anio_inicio as regAnioInicio, ");
            query.append(" n.id as idNota ");
            query.append(" FROM nota_insumo r ");
            query.append(" inner join nota n on n.id_aplicacion=r.id_nota ");
            query.append(" inner join calificacion c on c.id_aplicacion=n.id_calificacion ");
            query.append(" inner join asignacion a on a.id=c.id_asignacion and a.id_paralelo=? ");
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ps.setInt(1, idParalelo);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                NotaInsumo notaInsumo = new NotaInsumo();
                notaInsumo.setId(rs.getInt("id"));
                notaInsumo.setIdAplicacion(rs.getInt("idAplicacion"));
                notaInsumo.setNota11(rs.getBigDecimal("nota11"));
                notaInsumo.setNota12(rs.getBigDecimal("nota12"));
                notaInsumo.setNota13(rs.getBigDecimal("nota13"));
                notaInsumo.setNota14(rs.getBigDecimal("nota14"));
                notaInsumo.setNota15(rs.getBigDecimal("nota15"));
                notaInsumo.setNota21(rs.getBigDecimal("nota21"));
                notaInsumo.setNota22(rs.getBigDecimal("nota22"));
                notaInsumo.setNota23(rs.getBigDecimal("nota23"));
                notaInsumo.setNota24(rs.getBigDecimal("nota24"));
                notaInsumo.setNota25(rs.getBigDecimal("nota25"));
                notaInsumo.setNota31(rs.getBigDecimal("nota31"));
                notaInsumo.setNota32(rs.getBigDecimal("nota32"));
                notaInsumo.setNota33(rs.getBigDecimal("nota33"));
                notaInsumo.setNota34(rs.getBigDecimal("nota34"));
                notaInsumo.setNota35(rs.getBigDecimal("nota35"));
                notaInsumo.setEstado(rs.getString("estado"));
                notaInsumo.setIdUsuarioCreacion(rs.getInt("idUsuarioCreacion"));
                notaInsumo.setRegAnioInicio(rs.getString("regAnioInicio"));
                notaInsumo.setIdNota(rs.getInt("idNota"));
                notaInsumos.add(notaInsumo);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.cerrar();
        }
        return notaInsumos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotaInsumo buscarPorId(Integer id) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(NotaInsumo.class);
        NotaInsumo estudiante = null;
        try {
            estudiante = (NotaInsumo)run.query(conn, " SELECT  r.id ,  r.id_aplicacion as idAplicacion,  r.nota1_1 as nota11,  r.nota1_2 as nota12,  r.nota1_3 as nota13,  r.nota1_4 as nota14,  r.nota1_5 as nota15,  r.nota2_1 as nota21,  r.nota2_2 as nota22,  r.nota2_3 as nota23,  r.nota2_4 as nota24,  r.nota2_5 as nota25,  r.nota3_1 as nota31,  r.nota3_2 as nota32,  r.nota3_3 as nota33,  r.nota3_4 as nota34,  r.nota3_5 as nota35,  r.estado as estado, r.id_usuario_creacion as idUsuarioCreacion  FROM nota_insumo r  WHERE  r.id = ? ", (ResultSetHandler)handler, new Object[]{id});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return estudiante;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarNotaInsumo(NotaInsumo notaInsumo) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " INSERT INTO nota_insumo( id_nota,  nota1_1,  nota1_2,  nota1_3,  nota1_4,  nota1_5,  nota2_1,  nota2_2,  nota2_3,  nota2_4,  nota2_5,  nota3_1,  nota3_2,  nota3_3,  nota3_4,  nota3_5,  estado, id_usuario_creacion,  reg_anio_inicio)  values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try {
            run.update(conn, sql, new Object[]{notaInsumo.getIdNota(), notaInsumo.getNota11(), notaInsumo.getNota12(), notaInsumo.getNota13(), notaInsumo.getNota14(), notaInsumo.getNota15(), notaInsumo.getNota21(), notaInsumo.getNota22(), notaInsumo.getNota23(), notaInsumo.getNota24(), notaInsumo.getNota25(), notaInsumo.getNota31(), notaInsumo.getNota32(), notaInsumo.getNota33(), notaInsumo.getNota34(), notaInsumo.getNota35(), notaInsumo.getEstado(), notaInsumo.getIdUsuarioCreacion(), notaInsumo.getRegAnioInicio()});
        }
        catch (Exception e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (Exception e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarNotaInsumo(NotaInsumo notaInsumo) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " UPDATE nota_insumo set  nota1_1=?,  nota1_2=?,  nota1_3=?,  nota1_4=?,  nota1_5=?,  nota2_1=?,  nota2_2=?,  nota2_3=?,  nota2_4=?,  nota2_5=?,  nota3_1=?,  nota3_2=?,  nota3_3=?,  nota3_4=?,  nota3_5=?,  estado=?, id_usuario_creacion=?, reg_anio_inicio=? where id_aplicacion= ? ";
        try {
            run.update(conn, sql, new Object[]{notaInsumo.getNota11(), notaInsumo.getNota12(), notaInsumo.getNota13(), notaInsumo.getNota14(), notaInsumo.getNota15(), notaInsumo.getNota21(), notaInsumo.getNota22(), notaInsumo.getNota23(), notaInsumo.getNota24(), notaInsumo.getNota25(), notaInsumo.getNota31(), notaInsumo.getNota32(), notaInsumo.getNota33(), notaInsumo.getNota34(), notaInsumo.getNota35(), notaInsumo.getEstado(), notaInsumo.getIdUsuarioCreacion(), notaInsumo.getRegAnioInicio(), notaInsumo.getIdAplicacion()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarNotaInsumoSincronizacion(NotaInsumo notaInsumo) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " UPDATE nota_insumo set id = ?,codigo_error = ? where id_aplicacion =? ";
        try {
            run.update(conn, sql, new Object[]{notaInsumo.getId(), notaInsumo.getCodigoError(), notaInsumo.getIdAplicacion()});
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public List<NotaInsumo> buscarTodo() throws Exception {
        ArrayList<NotaInsumo> notaInsumos = new ArrayList<NotaInsumo>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT r.id , ");
            query.append(" r.id_aplicacion as idAplicacion, ");
            query.append(" r.nota1_1 as nota11, ");
            query.append(" r.nota1_2 as nota12, ");
            query.append(" r.nota1_3 as nota13, ");
            query.append(" r.nota1_4 as nota14, ");
            query.append(" r.nota1_5 as nota15, ");
            query.append(" r.nota2_1 as nota21, ");
            query.append(" r.nota2_2 as nota22, ");
            query.append(" r.nota2_3 as nota23, ");
            query.append(" r.nota2_4 as nota24, ");
            query.append(" r.nota2_5 as nota25, ");
            query.append(" r.nota3_1 as nota31, ");
            query.append(" r.nota3_2 as nota32, ");
            query.append(" r.nota3_3 as nota33, ");
            query.append(" r.nota3_4 as nota34, ");
            query.append(" r.nota3_5 as nota35, ");
            query.append(" r.estado as estado, ");
            query.append(" r.id_usuario_creacion as idUsuarioCreacion, ");
            query.append(" r.reg_anio_inicio as regAnioInicio, ");
            query.append(" r.id_nota as idNota ");
            query.append(" FROM nota_insumo r ");
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                NotaInsumo notaInsumo = new NotaInsumo();
                notaInsumo.setId(rs.getInt("id"));
                notaInsumo.setIdAplicacion(rs.getInt("idAplicacion"));
                notaInsumo.setNota11(rs.getBigDecimal("nota11"));
                notaInsumo.setNota12(rs.getBigDecimal("nota12"));
                notaInsumo.setNota13(rs.getBigDecimal("nota13"));
                notaInsumo.setNota14(rs.getBigDecimal("nota14"));
                notaInsumo.setNota15(rs.getBigDecimal("nota15"));
                notaInsumo.setNota21(rs.getBigDecimal("nota21"));
                notaInsumo.setNota22(rs.getBigDecimal("nota22"));
                notaInsumo.setNota23(rs.getBigDecimal("nota23"));
                notaInsumo.setNota24(rs.getBigDecimal("nota24"));
                notaInsumo.setNota25(rs.getBigDecimal("nota25"));
                notaInsumo.setNota31(rs.getBigDecimal("nota31"));
                notaInsumo.setNota32(rs.getBigDecimal("nota32"));
                notaInsumo.setNota33(rs.getBigDecimal("nota33"));
                notaInsumo.setNota34(rs.getBigDecimal("nota34"));
                notaInsumo.setNota35(rs.getBigDecimal("nota35"));
                notaInsumo.setEstado(rs.getString("estado"));
                notaInsumo.setIdUsuarioCreacion(rs.getInt("idUsuarioCreacion"));
                notaInsumo.setRegAnioInicio(rs.getString("regAnioInicio"));
                notaInsumo.setIdNota(rs.getInt("idNota"));
                notaInsumos.add(notaInsumo);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.cerrar();
        }
        return notaInsumos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarNotaInsumo(List<NotaInsumo> listaInsumo) throws Exception {
        if (null != listaInsumo && !listaInsumo.isEmpty()) {
            try {
                String sql = " INSERT INTO nota_insumo( id_nota,  nota1_1,  nota1_2,  nota1_3,  nota1_4,  nota1_5,  nota2_1,  nota2_2,  nota2_3,  nota2_4,  nota2_5,  nota3_1,  nota3_2,  nota3_3,  nota3_4,  nota3_5,  estado, id_usuario_creacion, reg_anio_inicio, id)  values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                this.Conectar();
                PreparedStatement ps = this.getConexion().prepareStatement(sql);
                for (NotaInsumo nota : listaInsumo) {
                    if (null == nota) continue;
                    PreparedStatement psc = this.getConexion().prepareStatement("SELECT * FROM nota WHERE id =? ");
                    psc.setInt(1, nota.getIdNota());
                    ResultSet rsc = psc.executeQuery();
                    ps.setInt(1, rsc.getInt("id_aplicacion"));
                    ps.setObject(2, (Object)nota.getNota11(), 8);
                    ps.setObject(3, (Object)nota.getNota12(), 8);
                    ps.setObject(4, (Object)nota.getNota13(), 8);
                    ps.setObject(5, (Object)nota.getNota14(), 8);
                    ps.setObject(6, (Object)nota.getNota15(), 8);
                    ps.setObject(7, (Object)nota.getNota21(), 8);
                    ps.setObject(8, (Object)nota.getNota22(), 8);
                    ps.setObject(9, (Object)nota.getNota23(), 8);
                    ps.setObject(10, (Object)nota.getNota24(), 8);
                    ps.setObject(11, (Object)nota.getNota25(), 8);
                    ps.setObject(12, (Object)nota.getNota31(), 8);
                    ps.setObject(13, (Object)nota.getNota32(), 8);
                    ps.setObject(14, (Object)nota.getNota33(), 8);
                    ps.setObject(15, (Object)nota.getNota34(), 8);
                    ps.setObject(16, (Object)nota.getNota35(), 8);
                    ps.setObject(17, (Object)nota.getEstado(), 4);
                    ps.setObject(18, (Object)nota.getIdUsuarioCreacion(), 4);
                    ps.setString(19, nota.getRegAnioInicio());
                    ps.setObject(20, (Object)nota.getId(), 4);
                    ps.addBatch();
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (Exception e) {
                System.out.println(e);
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
            finally {
                this.cerrar();
            }
        }
    }
}

