/*
 * Decompiled with CFR 0.152.
 */
package Servicios;

import Enumeradores.PorcentajeEnum;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import javax.swing.JTextField;

public class Validaciones {
    public static Float calcula(Float num, int decimalPlace) {
        BigDecimal bd = new BigDecimal(Float.toString(num.floatValue()));
        bd = bd.setScale(decimalPlace, RoundingMode.DOWN);
        return Float.valueOf(bd.floatValue());
    }

    public static Object decimal(Object value) {
        DecimalFormat df = new DecimalFormat("#0.00");
        value = df.format(value);
        return value;
    }

    public static Boolean esFloat(JTextField valorField) {
        Boolean valida = Boolean.TRUE;
        try {
            Float.parseFloat(valorField.getText());
        }
        catch (NumberFormatException e) {
            valida = Boolean.FALSE;
        }
        return valida;
    }

    public static BigDecimal calcularPromedio(BigDecimal ... notas) {
        BigDecimal promedio;
        BigDecimal sumaNotas = new BigDecimal(0.0);
        for (BigDecimal n : notas) {
            if (n == null) continue;
            sumaNotas = sumaNotas.add(n);
        }
        if (notas.length > 2) {
            promedio = new BigDecimal(String.valueOf(sumaNotas)).divide(new BigDecimal(String.valueOf(notas.length - 1)), 2, RoundingMode.DOWN).setScale(2, RoundingMode.DOWN);
            return promedio;
        }
        promedio = new BigDecimal(String.valueOf(sumaNotas)).divide(new BigDecimal(String.valueOf(notas.length)), 2, RoundingMode.DOWN).setScale(2, RoundingMode.DOWN);
        return promedio;
    }

    public static BigDecimal calcularPromedioInsumo(BigDecimal ... notas) {
        BigDecimal sumaNotas = new BigDecimal(0.0);
        int numNotas = 0;
        for (BigDecimal n : notas) {
            if (n == null) continue;
            sumaNotas = sumaNotas.add(n);
            ++numNotas;
        }
        BigDecimal promedio = new BigDecimal(String.valueOf(sumaNotas)).divide(new BigDecimal(String.valueOf(numNotas >= 2 ? numNotas : 2)), 2, RoundingMode.DOWN).setScale(2, RoundingMode.DOWN);
        return promedio;
    }

    public static BigDecimal calculaSuma(BigDecimal ... notas) {
        BigDecimal sumaNotas = new BigDecimal(0.0);
        for (BigDecimal n : notas) {
            if (n == null) continue;
            sumaNotas = sumaNotas.add(n);
        }
        return sumaNotas;
    }

    public static BigDecimal calcularPorcentajeNota(BigDecimal valor) {
        BigDecimal porcentaje = new BigDecimal(String.valueOf(valor)).multiply(new BigDecimal(PorcentajeEnum.P80.getPorcentaje())).divide(new BigDecimal(10), 2, RoundingMode.DOWN);
        BigDecimal resul = porcentaje.setScale(2, RoundingMode.DOWN);
        return resul;
    }

    public static BigDecimal calcularPorcentajeExamen(BigDecimal valor) {
        BigDecimal resul;
        if (valor == null) {
            resul = BigDecimal.ZERO;
        } else {
            BigDecimal porcentaje = new BigDecimal(String.valueOf(valor)).multiply(new BigDecimal(PorcentajeEnum.P20.getPorcentaje())).divide(new BigDecimal(10), 2, RoundingMode.DOWN);
            resul = porcentaje.setScale(2, RoundingMode.DOWN);
        }
        return resul;
    }

    public static String calcularEscalaCualitativa(Float nota) {
        String notaCualitativa = "";
        if (nota.floatValue() >= 9.0f) {
            notaCualitativa = "DA";
        } else if (nota.floatValue() >= 7.0f && nota.floatValue() <= 8.99f) {
            notaCualitativa = "AA";
        } else if (nota.floatValue() >= 4.01f && nota.floatValue() <= 6.99f) {
            notaCualitativa = "PA";
        } else if (nota.floatValue() <= 4.0f) {
            notaCualitativa = "NA";
        }
        return notaCualitativa;
    }
}

