/*
 * Decompiled with CFR 0.152.
 */
package Util;

import Vistas.VistaPrincipal;
import fr.opensagres.xdocreport.converter.ConverterTypeTo;
import fr.opensagres.xdocreport.converter.Options;
import fr.opensagres.xdocreport.core.document.SyntaxKind;
import fr.opensagres.xdocreport.document.IXDocReport;
import fr.opensagres.xdocreport.document.registry.XDocReportRegistry;
import fr.opensagres.xdocreport.template.IContext;
import fr.opensagres.xdocreport.template.TemplateEngineKind;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import java.awt.Desktop;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.poi.POIXMLDocumentPart;

public class FileUtil {
    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static Boolean generarDocumento(String pathArchivoWordTemplate, String pathArchivoPdf, Map<String, Object> mapParametrosArchivo, Map<String, Object> mapMetadata) {
        try {
            File file = new File(pathArchivoWordTemplate);
            FileInputStream inputStream = new FileInputStream(file);
            IXDocReport xdocReport = XDocReportRegistry.getRegistry().loadReport((InputStream)inputStream, TemplateEngineKind.Velocity);
            IContext context = xdocReport.createContext();
            if (null != mapMetadata) {
                FieldsMetadata metadata = xdocReport.createFieldsMetadata();
                for (Map.Entry<String, Object> mm : mapMetadata.entrySet()) {
                    if ("html".equals(mm.getKey())) {
                        String[] listaObjetos = (String[])mm.getValue();
                        for (String l : listaObjetos) {
                            metadata.addFieldAsTextStyling(l, SyntaxKind.Html, true);
                        }
                        continue;
                    }
                    metadata.load(mm.getKey(), mm.getValue().getClass(), true);
                }
            }
            context.putMap(mapParametrosArchivo);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Options options = Options.getTo((ConverterTypeTo)ConverterTypeTo.PDF);
            xdocReport.convert(context, options, (OutputStream)out);
            byte[] bytes = out.toByteArray();
            try {
                FileOutputStream stream = new FileOutputStream(pathArchivoPdf);
                Object object = null;
                try {
                    stream.write(bytes);
                    Boolean bl = true;
                    return bl;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (stream != null) {
                        if (object != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            stream.close();
                        }
                    }
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                ((InputStream)inputStream).close();
                bytes = null;
            }
        }
        catch (Exception e) {
            Logger.getLogger(FileUtil.class.getName()).log(Level.SEVERE, null, e);
            return false;
        }
    }

    public static void abrirArchivoDesktop(String rutaArchivo) {
        if (Desktop.isDesktopSupported()) {
            try {
                File myFile = new File(rutaArchivo);
                Desktop.getDesktop().open(myFile);
            }
            catch (IOException ex) {
                Logger.getLogger(FileUtil.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void rutaJar() {
        ClassLoader classloader = POIXMLDocumentPart.class.getClassLoader();
        URL res = classloader.getResource("org/apache/poi/POIXMLDocumentPart.class");
        String path = res.getPath();
    }

    public static String rutaApp() {
        String ruta = null;
        try {
            File pto = new File(VistaPrincipal.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            ruta = pto.getCanonicalPath();
        }
        catch (IOException | URISyntaxException ex) {
            Logger.getLogger(FileUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        return Paths.get(ruta, new String[0]).getParent().toString();
    }
}

